/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebParam;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerType;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KeyValuesService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.dto.CustomerCreationStatusDto;
import org.kuali.kfs.module.external.kc.dto.CustomerTypeDto;
import org.kuali.kfs.module.external.kc.service.CustomerCreationService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kra.external.sponsor.SponsorDTO;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class CustomerCreationServiceImpl
implements CustomerCreationService {
    private static final Logger LOG = LogManager.getLogger(CustomerCreationServiceImpl.class);
    private static final String CREATED_BY_AGENCY_DOC = "message.ar.createdByAgencyDocument";
    protected ConfigurationService configurationService;
    protected AccountsReceivableModuleService accountsReceivableModuleService;
    protected KeyValuesService keyValuesService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomerCreationStatusDto createCustomer(SponsorDTO sponsor, String initiatedByPrincipalName) {
        CustomerCreationStatusDto result = new CustomerCreationStatusDto();
        UserSession oldSession = GlobalVariables.getUserSession();
        try {
            GlobalVariables.setUserSession((UserSession)new UserSession("kfs"));
            Agency agency = new Agency(sponsor);
            String description = this.configurationService.getPropertyValueAsString(CREATED_BY_AGENCY_DOC);
            String customerNumber = this.accountsReceivableModuleService.createAndSaveCustomer(description, (ContractsAndGrantsBillingAgency)agency);
            result.setCustomerNumber(customerNumber);
        }
        catch (Exception e) {
            result.setErrors(new ArrayList<String>());
            result.getErrors().add(e.getMessage());
            LOG.error("Unable to create customer.", (Throwable)e);
        }
        finally {
            GlobalVariables.setUserSession((UserSession)oldSession);
        }
        return result;
    }

    @Override
    public List<CustomerTypeDto> getCustomerTypes() {
        ArrayList<CustomerTypeDto> dtos = new ArrayList<CustomerTypeDto>();
        Collection customerTypes = this.getKeyValuesService().findAll(AccountsReceivableCustomerType.class);
        for (AccountsReceivableCustomerType type : customerTypes) {
            CustomerTypeDto dto = new CustomerTypeDto();
            dto.setCustomerTypeCode(type.getCustomerTypeCode());
            dto.setCustomerTypeDescription(type.getCustomerTypeDescription());
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public boolean isValidCustomer(@WebParam(name="customerNumber") String customerNumber) {
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(AccountsReceivableCustomer.class);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(AccountsReceivableCustomer.class)) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("customerNumber", customerNumber);
            return responsibleModuleService.getExternalizableBusinessObject(AccountsReceivableCustomer.class, values) != null;
        }
        return false;
    }

    protected ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected AccountsReceivableModuleService getAccountsReceivableModuleService() {
        return this.accountsReceivableModuleService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }

    protected KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = (KeyValuesService)SpringContext.getBean(KeyValuesService.class);
        }
        return this.keyValuesService;
    }

    public void setKeyValuesService(KeyValuesService keyValuesService) {
        this.keyValuesService = keyValuesService;
    }
}

