/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountGuideline;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.IndirectCostRecoveryAccount;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.integration.cg.dto.AccountCreationStatusDTO;
import org.kuali.kfs.integration.cg.dto.AccountParametersDTO;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.validation.ValidationPattern;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.BlanketApproveDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.external.kc.businessobject.AccountAutoCreateDefaults;
import org.kuali.kfs.module.external.kc.businessobject.IndirectCostRecoveryAutoDefAccount;
import org.kuali.kfs.module.external.kc.service.AccountCreationService;
import org.kuali.kfs.module.external.kc.service.AccountDefaultsService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.util.KcUtils;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class AccountCreationServiceImpl
implements AccountCreationService {
    private static final Logger LOG = LogManager.getLogger(AccountCreationServiceImpl.class);
    protected BusinessObjectDictionaryService businessObjectDictionaryService;
    protected DocumentService documentService;
    protected ParameterService parameterService;
    protected BusinessObjectService businessObjectService;
    protected AccountDefaultsService accountDefaultsService;
    protected KualiRuleService kualiRuleService;
    protected MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    protected AccountService accountService;
    protected ChartService chartService;
    protected PersonService personService;

    @Override
    public AccountCreationStatusDTO createAccount(AccountParametersDTO accountParameters) {
        AccountCreationStatusDTO accountCreationStatus = new AccountCreationStatusDTO();
        accountCreationStatus.setErrorMessages(new ArrayList());
        accountCreationStatus.setStatus("success");
        String principalId = accountParameters.getPrincipalId();
        LOG.debug("principalId  ::::" + principalId);
        if (!this.isValidUser(principalId)) {
            this.setFailStatus(accountCreationStatus, KcUtils.getErrorMessage("error.kc.document.invalid.user", new String[]{principalId}));
            return accountCreationStatus;
        }
        String unitNumber = accountParameters.getUnit();
        AccountAutoCreateDefaults defaults = this.getAccountDefaultsService().getAccountDefaults(unitNumber);
        if (defaults == null) {
            this.setFailStatus(accountCreationStatus, "Unit cannot be found in KFS");
            return accountCreationStatus;
        }
        try {
            Account account = this.createAccountObject(accountParameters, defaults);
            if (!this.isValidAccount(account, accountCreationStatus)) {
                return accountCreationStatus;
            }
            this.createAutomaticCGAccountMaintenanceDocument(account, accountCreationStatus);
        }
        catch (Exception ex) {
            this.setFailStatus(accountCreationStatus, "Unable to generate KFS Account from data parameters");
            return accountCreationStatus;
        }
        if (accountCreationStatus.getStatus().equals("success")) {
            accountCreationStatus.setAccountNumber(accountParameters.getAccountNumber());
            accountCreationStatus.setChartOfAccountsCode(defaults.getChartOfAccountsCode());
        }
        return accountCreationStatus;
    }

    public Account createAccountObject(AccountParametersDTO parameters, AccountAutoCreateDefaults defaults) {
        boolean isKCOverrideKFS;
        Account account = new Account();
        account.setChartOfAccountsCode(defaults.getChartOfAccountsCode());
        account.setOrganizationCode(defaults.getOrganizationCode());
        account.setAccountNumber(parameters.getAccountNumber());
        account.setAccountName(parameters.getAccountName());
        account.setAccountPhysicalCampusCode(defaults.getAccountPhysicalCampusCode());
        if (parameters.getExpirationDate() != null) {
            account.setAccountExpirationDate(new Date(parameters.getExpirationDate().getTime()));
        }
        if (parameters.getEffectiveDate() != null) {
            account.setAccountEffectiveDate(new Date(parameters.getEffectiveDate().getTime()));
        }
        if (isKCOverrideKFS = this.parameterService.getParameterValueAsBoolean(Account.class, "KC_OVERRIDES_KFS_DEFAULT_ACCOUNT_IND").booleanValue()) {
            ArrayList addressTypes = new ArrayList(this.parameterService.getParameterValuesAsString(Account.class, "RESEARCH_ADMIN_ACCOUNT_ADDRESS_TYPE"));
            for (String addressType : addressTypes) {
                if (addressType.equals("PI") && !StringUtils.isBlank((CharSequence)parameters.getDefaultAddressStreetAddress())) {
                    account.setAccountStreetAddress(parameters.getDefaultAddressStreetAddress());
                    account.setAccountCityName(parameters.getDefaultAddressCityName());
                    account.setAccountStateCode(parameters.getDefaultAddressStateCode());
                    account.setAccountZipCode(parameters.getDefaultAddressZipCode());
                } else {
                    if (!addressType.equals("ADMIN") || StringUtils.isBlank((CharSequence)parameters.getAdminContactAddressStreetAddress())) continue;
                    account.setAccountStreetAddress(parameters.getAdminContactAddressStreetAddress());
                    account.setAccountCityName(parameters.getAdminContactAddressCityName());
                    account.setAccountStateCode(parameters.getAdminContactAddressStateCode());
                    account.setAccountZipCode(parameters.getAdminContactAddressZipCode());
                }
                break;
            }
        } else {
            account.setAccountStreetAddress(defaults.getAccountStreetAddress());
            account.setAccountCityName(defaults.getAccountCityName());
            account.setAccountStateCode(defaults.getAccountStateCode());
            account.setAccountZipCode(defaults.getAccountZipCode());
        }
        account.setAccountOffCampusIndicator(parameters.isOffCampusIndicator());
        account.setFinancialHigherEdFunctionCd(parameters.getHigherEdFunctionCode());
        account.setAcctIndirectCostRcvyTypeCd(parameters.getIndirectCostTypeCode());
        account.setFinancialIcrSeriesIdentifier(parameters.getIndirectCostRate());
        account.setAccountGuideline(new AccountGuideline());
        account.getAccountGuideline().setAccountExpenseGuidelineText(parameters.getExpenseGuidelineText());
        account.getAccountGuideline().setAccountIncomeGuidelineText(parameters.getIncomeGuidelineText());
        account.getAccountGuideline().setAccountPurposeText(parameters.getPurposeText());
        account.setClosed(false);
        account.setAccountTypeCode(defaults.getAccountTypeCode());
        account.setSubFundGroupCode(defaults.getSubFundGroupCode());
        account.setAccountsFringesBnftIndicator(defaults.isAccountsFringesBnftIndicator());
        account.setReportsToAccountNumber(defaults.getReportsToAccountNumber());
        account.setReportsToChartOfAccountsCode(defaults.getReportsToChartOfAccountsCode());
        account.setAccountRestrictedStatusCode("R");
        account.setAccountRestrictedStatusDate(null);
        account.setEndowmentIncomeChartOfAccounts(null);
        account.setEndowmentIncomeAccountNumber(null);
        account.setAccountFiscalOfficerSystemIdentifier(defaults.getAccountFiscalOfficerSystemIdentifier());
        account.setAccountsSupervisorySystemsIdentifier(defaults.getAccountsSupervisorySystemsIdentifier());
        account.setAccountManagerSystemIdentifier(defaults.getAccountManagerSystemIdentifier());
        account.setContinuationFinChrtOfAcctCd(defaults.getContinuationFinChrtOfAcctCd());
        account.setContinuationAccountNumber(defaults.getContinuationAccountNumber());
        account.setIncomeStreamAccountNumber(defaults.getIncomeStreamAccountNumber());
        account.setIncomeStreamChartOfAccounts(defaults.getIncomeStreamChartOfAccounts());
        account.setIncomeStreamFinancialCoaCode(defaults.getIncomeStreamFinancialCoaCode());
        account.setBudgetRecordingLevelCode(defaults.getBudgetRecordingLevelCode());
        account.setAccountSufficientFundsCode(defaults.getAccountSufficientFundsCode());
        account.setPendingAcctSufficientFundsIndicator(defaults.isPendingAcctSufficientFundsIndicator());
        account.setExtrnlFinEncumSufficntFndIndicator(defaults.isExtrnlFinEncumSufficntFndIndicator());
        account.setIntrnlFinEncumSufficntFndIndicator(defaults.isIntrnlFinEncumSufficntFndIndicator());
        account.setFinPreencumSufficientFundIndicator(defaults.isFinPreencumSufficientFundIndicator());
        account.setFinancialObjectivePrsctrlIndicator(defaults.isFinancialObjectivePrsctrlIndicator());
        account.setContractControlFinCoaCode(null);
        account.setContractControlAccountNumber(null);
        account.setContractsAndGrantsAccountResponsibilityId(defaults.getContractsAndGrantsAccountResponsibilityId());
        account.setAccountCfdaNumber(parameters.getCfdaNumber());
        for (IndirectCostRecoveryAutoDefAccount indirectCostRecoveryAutoDefAccount : defaults.getIndirectCostRecoveryAutoDefAccounts()) {
            account.getIndirectCostRecoveryAccounts().add(this.createIndirectCostRecoveryAccount(indirectCostRecoveryAutoDefAccount, account.getChartOfAccountsCode(), account.getAccountNumber()));
        }
        return account;
    }

    protected IndirectCostRecoveryAccount createIndirectCostRecoveryAccount(IndirectCostRecoveryAutoDefAccount indirectCostRecoveryAutoDefAccount, String chartCode, String acctNumber) {
        IndirectCostRecoveryAccount indirectCostRecoveryAccount = new IndirectCostRecoveryAccount();
        indirectCostRecoveryAccount.setChartOfAccountsCode(chartCode);
        indirectCostRecoveryAccount.setAccountNumber(acctNumber);
        indirectCostRecoveryAccount.setIndirectCostRecoveryAccount(indirectCostRecoveryAutoDefAccount.getIndirectCostRecoveryAccount());
        indirectCostRecoveryAccount.setIndirectCostRecoveryChartOfAccounts(indirectCostRecoveryAutoDefAccount.getIndirectCostRecoveryChartOfAccounts());
        indirectCostRecoveryAccount.setIndirectCostRecoveryAccountNumber(indirectCostRecoveryAutoDefAccount.getIndirectCostRecoveryAccountNumber());
        indirectCostRecoveryAccount.setIndirectCostRecoveryFinCoaCode(indirectCostRecoveryAutoDefAccount.getIndirectCostRecoveryFinCoaCode());
        indirectCostRecoveryAccount.setAccountLinePercent(indirectCostRecoveryAutoDefAccount.getAccountLinePercent());
        indirectCostRecoveryAccount.setActive(indirectCostRecoveryAutoDefAccount.isActive());
        return indirectCostRecoveryAccount;
    }

    protected void setFailStatus(AccountCreationStatusDTO accountCreationStatus, String message) {
        accountCreationStatus.getErrorMessages().add(message);
        accountCreationStatus.setStatus("failure");
    }

    protected void createAutomaticCGAccountMaintenanceDocument(Account account, AccountCreationStatusDTO accountCreationStatus) {
        MaintenanceDocument maintenanceAccountDocument = (MaintenanceDocument)this.createCGAccountMaintenanceDocument(accountCreationStatus);
        if (ObjectUtils.isNotNull((Object)maintenanceAccountDocument)) {
            maintenanceAccountDocument.getDocumentHeader().setDocumentDescription("Automatic CG Account Document Creation");
            maintenanceAccountDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)account);
            maintenanceAccountDocument.getNewMaintainableObject().setMaintenanceAction("New");
            this.createRouteAutomaticCGAccountDocument(maintenanceAccountDocument, accountCreationStatus);
        }
    }

    protected void createRouteAutomaticCGAccountDocument(MaintenanceDocument maintenanceAccountDocument, AccountCreationStatusDTO accountCreationStatus) {
        try {
            String accountAutoCreateRouteValue = this.getParameterService().getParameterValueAsString(Account.class, "RESEARCH_ADMIN_AUTO_CREATE_ACCOUNT_WORKFLOW_ACTION");
            if (!("Save".equalsIgnoreCase(accountAutoCreateRouteValue) || "submit".equalsIgnoreCase(accountAutoCreateRouteValue) || "BlanketApprove".equalsIgnoreCase(accountAutoCreateRouteValue))) {
                this.setFailStatus(accountCreationStatus, "The system parameter value for ACCOUNT_AUTO_CREATE_ROUTE should be either Save or Submit or BlanketApprove.");
                LOG.error("Incorrect document status::::: " + accountCreationStatus.getErrorMessages().toString());
                return;
            }
            if (accountAutoCreateRouteValue.equalsIgnoreCase("Save")) {
                boolean rulesPassed = this.kualiRuleService.applyRules((KualiDocumentEvent)new SaveDocumentEvent((Document)maintenanceAccountDocument));
                LOG.debug("global variable messages :::  " + GlobalVariables.getMessageMap().getErrorMessages().toString());
                if (rulesPassed && GlobalVariables.getMessageMap().hasNoErrors()) {
                    this.getDocumentService().saveDocument((Document)maintenanceAccountDocument);
                } else {
                    LOG.info("rule fail formatting errors messages ");
                    accountCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
                    try {
                        this.getDocumentService().saveDocument((Document)maintenanceAccountDocument);
                    }
                    catch (ValidationException validationException) {
                        // empty catch block
                    }
                    accountCreationStatus.setStatus("success");
                    LOG.error(KcUtils.getErrorMessage("error.kc.document.account.rules.exception", new String[]{maintenanceAccountDocument.getDocumentNumber()}));
                }
            } else if (accountAutoCreateRouteValue.equalsIgnoreCase("BlanketApprove")) {
                boolean rulesPassed = this.kualiRuleService.applyRules((KualiDocumentEvent)new BlanketApproveDocumentEvent((Document)maintenanceAccountDocument));
                if (rulesPassed && GlobalVariables.getMessageMap().hasNoErrors()) {
                    this.getDocumentService().blanketApproveDocument((Document)maintenanceAccountDocument, "", null);
                } else {
                    accountCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
                    try {
                        this.getDocumentService().saveDocument((Document)maintenanceAccountDocument);
                    }
                    catch (ValidationException validationException) {
                        // empty catch block
                    }
                    accountCreationStatus.setStatus("success");
                    LOG.error(KcUtils.getErrorMessage("error.kc.document.account.rules.exception", new String[]{maintenanceAccountDocument.getDocumentNumber()}));
                }
            } else if ("submit".equalsIgnoreCase(accountAutoCreateRouteValue)) {
                boolean rulesPassed = this.kualiRuleService.applyRules((KualiDocumentEvent)new RouteDocumentEvent((Document)maintenanceAccountDocument));
                if (rulesPassed && GlobalVariables.getMessageMap().hasNoErrors()) {
                    this.getDocumentService().routeDocument((Document)maintenanceAccountDocument, "", null);
                } else {
                    accountCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
                    try {
                        this.getDocumentService().saveDocument((Document)maintenanceAccountDocument);
                    }
                    catch (ValidationException validationException) {
                        // empty catch block
                    }
                    accountCreationStatus.setStatus("success");
                    LOG.error(KcUtils.getErrorMessage("error.kc.document.account.rules.exception", new String[]{maintenanceAccountDocument.getDocumentNumber()}));
                }
            }
            accountCreationStatus.setDocumentNumber(maintenanceAccountDocument.getDocumentNumber());
        }
        catch (WorkflowException wfe) {
            LOG.error(KcUtils.getErrorMessage("error.kc.document.workflowException.document.actions", null) + ": " + wfe.getMessage());
            accountCreationStatus.setStatus("failure");
            accountCreationStatus.getErrorMessages().add(KcUtils.getErrorMessage("warning.kc.document.workflowException.document.actions", null) + ": " + wfe.getMessage());
            try {
                try {
                    this.getDocumentService().saveDocument((Document)maintenanceAccountDocument);
                }
                catch (ValidationException rulesPassed) {
                    // empty catch block
                }
                accountCreationStatus.setDocumentNumber(maintenanceAccountDocument.getDocumentNumber());
                accountCreationStatus.setStatus("success");
            }
            catch (WorkflowException e) {
                LOG.error(KcUtils.getErrorMessage("warning.kc.document.workflowException.document.actions", null) + ": " + e.getMessage());
                accountCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
                accountCreationStatus.setStatus("failure");
            }
        }
        catch (Exception ex) {
            LOG.error("Unknown exception occurred: " + ex.getMessage());
            accountCreationStatus.setStatus("failure");
            accountCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
            accountCreationStatus.getErrorMessages().add(KcUtils.getErrorMessage("warning.kc.document.workflowException.document.actions", null) + ": " + ex.getMessage());
            try {
                try {
                    this.getDocumentService().saveDocument((Document)maintenanceAccountDocument);
                }
                catch (ValidationException e) {
                    // empty catch block
                }
                accountCreationStatus.setDocumentNumber(maintenanceAccountDocument.getDocumentNumber());
                accountCreationStatus.setStatus("success");
            }
            catch (WorkflowException e) {
                LOG.error(KcUtils.getErrorMessage("warning.kc.document.workflowException.document.actions", null) + ": " + e.getMessage());
                accountCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
                accountCreationStatus.setStatus("failure");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document createCGAccountMaintenanceDocument(AccountCreationStatusDTO accountCreationStatus) {
        boolean internalUserSession = false;
        try {
            if (GlobalVariables.getUserSession() == null) {
                internalUserSession = true;
                GlobalVariables.setUserSession((UserSession)new UserSession("kfs"));
                GlobalVariables.clear();
            }
            Document document = this.getDocumentService().getNewDocument(this.maintenanceDocumentDictionaryService.getDocumentTypeName(Account.class));
            return document;
        }
        catch (Exception e) {
            accountCreationStatus.setErrorMessages(GlobalVariablesExtractHelper.extractGlobalVariableErrors());
            accountCreationStatus.setStatus("failure");
            Document document = null;
            return document;
        }
        finally {
            if (internalUserSession) {
                GlobalVariables.clear();
                GlobalVariables.setUserSession(null);
            }
        }
    }

    @Override
    public boolean accountsCanCrossCharts() {
        return this.accountService.accountsCanCrossCharts();
    }

    protected boolean isValidAccount(Account account, AccountCreationStatusDTO accountCreationStatus) {
        if (account == null) {
            this.setFailStatus(accountCreationStatus, "Unable to generate KFS Account from data parameters");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)account.getChartOfAccountsCode()) || StringUtils.isBlank((CharSequence)account.getAccountNumber())) {
            this.setFailStatus(accountCreationStatus, "The chart of accounts code or account number is missing.");
            return false;
        }
        if (!this.isValidChartCode(account.getChartOfAccountsCode())) {
            this.setFailStatus(accountCreationStatus, "Chart of Accounts Code is not defined");
            return false;
        }
        if (!this.isValidAccountNumberLength(account.getAccountNumber(), accountCreationStatus)) {
            return false;
        }
        if (!this.checkUniqueAccountNumber(account.getAccountNumber())) {
            this.setFailStatus(accountCreationStatus, KcUtils.getErrorMessage("error.document.accountMaintenance.accountNumberNotUnique", new String[]{account.getAccountNumber()}));
            return false;
        }
        if (this.isValidChartAccount(account.getChartOfAccountsCode(), account.getAccountNumber())) {
            this.setFailStatus(accountCreationStatus, "Account is already defined in KFS");
            return false;
        }
        return this.checkAccountNumberPrefix(account.getAccountNumber(), accountCreationStatus);
    }

    @Override
    public boolean isValidAccount(String accountNumber) {
        Collection accounts = this.accountService.getAccountsForAccountNumber(accountNumber);
        return accounts != null && !accounts.isEmpty();
    }

    @Override
    public boolean isValidChartCode(String chartOfAccountsCode) {
        Chart chart = this.chartService.getByPrimaryId(chartOfAccountsCode);
        return chart != null;
    }

    @Override
    public boolean isValidChartAccount(String chartOfAccountsCode, String accountNumber) {
        Account account = this.accountService.getByPrimaryId(chartOfAccountsCode, accountNumber);
        return account != null;
    }

    protected boolean isValidAccountNumberLength(String accountNumber, AccountCreationStatusDTO accountCreationStatus) {
        ValidationPattern validationPattern;
        boolean isValid = false;
        int fieldSize = -1;
        BusinessObjectEntry entry = this.businessObjectDictionaryService.getBusinessObjectEntry(Account.class.getName());
        AttributeDefinition attributeDefinition = entry.getAttributeDefinition("accountNumber");
        if (ObjectUtils.isNotNull((Object)attributeDefinition) && ObjectUtils.isNotNull((Object)(validationPattern = attributeDefinition.getValidationPattern())) && validationPattern instanceof AlphaNumericValidationPattern) {
            AlphaNumericValidationPattern alphaPattern = (AlphaNumericValidationPattern)validationPattern;
            fieldSize = alphaPattern.getExactLength();
        }
        if (ObjectUtils.isNotNull((Object)accountNumber) && fieldSize == accountNumber.length()) {
            isValid = true;
        }
        if (!isValid) {
            this.setFailStatus(accountCreationStatus, KcUtils.getErrorMessage("error.format.org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern.exactLength", new String[]{"account number", String.valueOf(fieldSize)}));
        }
        return isValid;
    }

    protected boolean checkAccountNumberPrefix(String accountNumber, AccountCreationStatusDTO accountCreationStatus) {
        boolean success = true;
        if (!StringUtils.isBlank((CharSequence)accountNumber)) {
            ArrayList illegalValues = new ArrayList(this.getParameterService().getParameterValuesAsString(Account.class, "PREFIXES"));
            for (String illegalValue : illegalValues) {
                if (!accountNumber.startsWith(illegalValue)) continue;
                success = false;
                this.setFailStatus(accountCreationStatus, KcUtils.getErrorMessage("error.document.accountMaintenance.accountNumberNotAllowed", new String[]{accountNumber, illegalValue}));
            }
        }
        return success;
    }

    protected boolean checkUniqueAccountNumber(String accountNumber) {
        boolean success = true;
        if (!this.accountService.accountsCanCrossCharts() && !this.accountService.getAccountsForAccountNumber(accountNumber).isEmpty()) {
            success = false;
        }
        return success;
    }

    protected boolean isValidUser(String principalId) {
        if (principalId == null) {
            return false;
        }
        Person user = this.personService.getPerson(principalId);
        if (user == null) {
            return false;
        }
        MaintenanceDocumentAuthorizerBase documentAuthorizer = new MaintenanceDocumentAuthorizerBase();
        if (documentAuthorizer.canInitiate(this.maintenanceDocumentDictionaryService.getDocumentTypeName(Account.class), user)) {
            GlobalVariables.setUserSession((UserSession)new UserSession(user.getPrincipalName()));
            return true;
        }
        LOG.error(KcUtils.getErrorMessage("error.kc.document.invalid.user", new String[]{principalId}));
        return false;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public AccountDefaultsService getAccountDefaultsService() {
        return this.accountDefaultsService;
    }

    public void setAccountDefaultsService(AccountDefaultsService accountDefaultsService) {
        this.accountDefaultsService = accountDefaultsService;
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        return this.maintenanceDocumentDictionaryService;
    }

    public void setMaintenanceDocumentDictionaryService(MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService) {
        this.maintenanceDocumentDictionaryService = maintenanceDocumentDictionaryService;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public ChartService getChartService() {
        return this.chartService;
    }

    public void setChartService(ChartService chartService) {
        this.chartService = chartService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

