/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.AwardAccount;
import org.kuali.kfs.module.external.kc.service.ExternalizableLookupableBusinessObjectService;
import org.kuali.kfs.module.external.kc.webService.AwardAccountSoapService;
import org.kuali.kra.external.award.AwardAccountDTO;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class AwardAccountServiceImpl
implements ExternalizableLookupableBusinessObjectService {
    private static final Logger LOG = LogManager.getLogger();

    protected AwardAccountService getWebService() {
        AwardAccountService awardAccountService = (AwardAccountService)GlobalResourceLoader.getService((QName)KcConstants.AwardAccount.SERVICE);
        if (awardAccountService == null) {
            AwardAccountSoapService soapService;
            LOG.warn("Couldn't get AwardAccountService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            try {
                soapService = new AwardAccountSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error("Could not initialize AwardAccountSoapService: " + ex.getMessage());
                throw new RuntimeException("Could not initialize AwardAccountSoapService: " + ex.getMessage());
            }
            awardAccountService = soapService.getAwardAccountServicePort();
        }
        return awardAccountService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        Collection ebos = this.findMatching(primaryKeys);
        if (ebos != null && ebos.iterator().hasNext()) {
            return (ExternalizableBusinessObject)ebos.iterator().next();
        }
        return null;
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        String chartOfAccountsCode;
        String accountNumber = (String)fieldValues.get("accountNumber");
        if (StringUtils.isBlank((CharSequence)accountNumber)) {
            accountNumber = null;
        }
        if (StringUtils.isBlank((CharSequence)(chartOfAccountsCode = (String)fieldValues.get("chartOfAccountsCode")))) {
            chartOfAccountsCode = null;
        }
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        List<AwardAccountDTO> awardAccountDTOs = null;
        try {
            awardAccountDTOs = this.getWebService().getAwardAccounts(accountNumber, chartOfAccountsCode);
        }
        catch (WebServiceException ex) {
            LOG.error("Could not retrieve award accounts: " + ex.getMessage());
        }
        if (awardAccountDTOs != null && !awardAccountDTOs.isEmpty()) {
            for (AwardAccountDTO awardAccount : awardAccountDTOs) {
                if (!StringUtils.isEmpty((CharSequence)awardAccount.getErrorMessage())) continue;
                AwardAccount awardAccountInfo = new AwardAccount(awardAccount);
                awardAccounts.add(awardAccountInfo);
            }
        }
        return awardAccounts;
    }

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return (List)this.findMatching(fieldValues);
    }
}

