/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kim.impl.identity.PersonImpl;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.AccountAutoCreateDefaults;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.businessobject.Award;
import org.kuali.kfs.module.external.kc.businessobject.AwardAccount;
import org.kuali.kfs.module.external.kc.businessobject.AwardFundManager;
import org.kuali.kfs.module.external.kc.businessobject.AwardOrganization;
import org.kuali.kfs.module.external.kc.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.external.kc.businessobject.LetterOfCreditFund;
import org.kuali.kfs.module.external.kc.businessobject.Proposal;
import org.kuali.kfs.module.external.kc.service.AccountDefaultsService;
import org.kuali.kfs.module.external.kc.service.ExternalizableLookupableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.AwardWebSoapService;
import org.kuali.kra.external.award.AwardAccountDTO;
import org.kuali.kra.external.award.AwardDTO;
import org.kuali.kra.external.award.AwardFieldValuesDto;
import org.kuali.kra.external.award.AwardSearchCriteriaDto;
import org.kuali.kra.external.award.AwardWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class AwardServiceImpl
implements ExternalizableLookupableBusinessObjectService {
    private static final Logger LOG = LogManager.getLogger();
    protected AccountDefaultsService accountDefaultsService;
    protected ConfigurationService configurationService;
    protected ParameterService parameterService;
    protected PersonService personService;
    protected BusinessObjectService businessObjectService;

    protected AwardWebService getWebService() {
        AwardWebService awardWebService = (AwardWebService)GlobalResourceLoader.getService((QName)KcConstants.Award.SERVICE);
        if (awardWebService == null) {
            AwardWebSoapService ss;
            LOG.warn("Couldn't get AwardWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            try {
                ss = new AwardWebSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error("Could not initialize AwardWebSoapService: " + ex.getMessage());
                throw new RuntimeException("Could not initialize AwardWebSoapService: " + ex.getMessage());
            }
            awardWebService = ss.getAwardWebServicePort();
        }
        return awardWebService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        AwardFieldValuesDto awardFieldValuesDto = new AwardFieldValuesDto();
        awardFieldValuesDto.setAwardNumber((String)primaryKeys.get("proposalNumber"));
        List<AwardDTO> dtos = this.getWebService().getMatchingAwards(awardFieldValuesDto);
        AwardDTO dto = null;
        if (dtos.size() > 0) {
            dto = dtos.get(0);
        }
        return this.awardFromDTO(dto);
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        List<AwardDTO> result = null;
        AwardFieldValuesDto criteria = new AwardFieldValuesDto();
        criteria.setAwardId((Long)fieldValues.get("awardId"));
        criteria.setAwardNumber((String)fieldValues.get("proposalNumber"));
        criteria.setChartOfAccounts((String)fieldValues.get("chartOfAccountsCode"));
        criteria.setAccountNumber((String)fieldValues.get("accountNumber"));
        criteria.setPrincipalInvestigatorId((String)fieldValues.get("principalId"));
        criteria.setFundManagerId((String)fieldValues.get("fundManagerId"));
        try {
            result = this.getWebService().getMatchingAwards(criteria);
        }
        catch (WebServiceException ex) {
            LOG.error("Access to the web service is unreachable: ", (Throwable)ex);
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (result == null) {
            return new ArrayList();
        }
        ArrayList<Award> awards = new ArrayList<Award>();
        for (AwardDTO dto : result) {
            awards.add(this.awardFromDTO(dto));
        }
        return awards;
    }

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List<AwardDTO> result = null;
        AwardSearchCriteriaDto criteria = new AwardSearchCriteriaDto();
        criteria.setAwardNumber(fieldValues.get("proposalNumber"));
        criteria.setAwardId(fieldValues.get("awardId"));
        criteria.setChartOfAccounts(fieldValues.get("chartOfAccountsCode"));
        criteria.setAccountNumber(fieldValues.get("accountNumber"));
        criteria.setPrincipalInvestigatorId(fieldValues.get("principalId"));
        criteria.setSponsorCode(fieldValues.get("agencyNumber"));
        criteria.setStartDate(fieldValues.get("awardBeginningDate"));
        criteria.setStartDateLowerBound(fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate"));
        criteria.setEndDate(fieldValues.get("awardEndingDate"));
        criteria.setEndDateLowerBound(fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate"));
        criteria.setBillingFrequency(fieldValues.get("awardBillingFrequency"));
        criteria.setAwardTotal(fieldValues.get("awardTotal"));
        try {
            result = this.getWebService().searchAwards(criteria);
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (result == null) {
            return new ArrayList();
        }
        ArrayList<Award> awards = new ArrayList<Award>();
        for (AwardDTO dto : result) {
            awards.add(this.awardFromDTO(dto));
        }
        return awards;
    }

    protected Award awardFromDTO(AwardDTO kcAward) {
        AccountAutoCreateDefaults defaults;
        Award award = new Award();
        award.setProposalNumber(kcAward.getAwardNumber());
        award.setAwardNumber(kcAward.getAwardNumber());
        award.setAwardId(kcAward.getAwardId());
        award.setAwardBeginningDate(kcAward.getObligationStartDate() == null ? null : new Date(kcAward.getObligationStartDate().getTime()));
        award.setAwardEndingDate(kcAward.getObligationEndDate() == null ? null : new Date(kcAward.getObligationEndDate().getTime()));
        award.setAwardTotalAmount(new KualiDecimal(kcAward.getAwardTotalAmount()));
        award.setAwardDirectCostAmount(new KualiDecimal(kcAward.getAwardDirectCostAmount()));
        award.setAwardIndirectCostAmount(new KualiDecimal(kcAward.getAwardIndirectCostAmount()));
        award.setAwardDocumentNumber(kcAward.getAwardDocumentNumber());
        award.setAwardLastUpdateDate(kcAward.getAwardLastUpdateDate() == null ? null : new Timestamp(kcAward.getAwardLastUpdateDate().getTime()));
        award.setAwardCreateTimestamp(kcAward.getAwardCreateTimestamp() == null ? null : new Timestamp(kcAward.getAwardCreateTimestamp().getTime()));
        award.setProposalAwardTypeCode(kcAward.getProposalAwardTypeCode());
        award.setAwardStatusCode(kcAward.getAwardStatusCode());
        award.setActive(kcAward.isActive());
        award.setAgencyNumber(kcAward.getSponsorCode());
        award.setAwardTitle(kcAward.getTitle());
        award.setAgency(new Agency(kcAward.getSponsor()));
        if (kcAward.getProposal() != null) {
            award.setProposal(new Proposal(kcAward.getProposal()));
            award.getProposal().setAward(award);
        }
        award.setAdditionalFormsRequiredIndicator(kcAward.isAdditionalFormsRequired());
        award.setAutoApproveIndicator(kcAward.isAutoApproveInvoice());
        if (kcAward.getMinInvoiceAmount() != null) {
            award.setMinInvoiceAmount(new KualiDecimal(kcAward.getMinInvoiceAmount()));
        }
        award.setAdditionalFormsDescription(kcAward.getAdditionalFormsDescription());
        award.setStopWorkIndicator(kcAward.isStopWork());
        award.setStopWorkReason(kcAward.getStopWorkReason());
        award.setInvoicingOptionCode(kcAward.getInvoicingOption());
        award.setInvoicingOptionDescription(kcAward.getInvoicingOptionDescription());
        award.setDunningCampaign(kcAward.getDunningCampaignId());
        if (StringUtils.isNotEmpty((CharSequence)kcAward.getFundManagerId())) {
            award.setAwardPrimaryFundManager(new AwardFundManager(award.getProposalNumber(), kcAward.getFundManagerId()));
        }
        if ((defaults = this.getAccountDefaultsService().getAccountDefaults(kcAward.getUnitNumber())) != null) {
            AwardOrganization awardOrg = new AwardOrganization();
            awardOrg.setActive(true);
            awardOrg.setAwardPrimaryOrganizationIndicator(true);
            awardOrg.setChartOfAccountsCode(defaults.getChartOfAccountsCode());
            awardOrg.setChartOfAccounts(defaults.getChartOfAccounts());
            awardOrg.setOrganization(defaults.getOrganization());
            awardOrg.setOrganizationCode(defaults.getOrganizationCode());
            awardOrg.setProposalNumber(award.getProposalNumber());
            award.setPrimaryAwardOrganization(awardOrg);
        }
        if (kcAward.getMethodOfPayment() != null) {
            award.setLetterOfCreditFundCode(kcAward.getMethodOfPayment().getMethodOfPaymentCode());
            LetterOfCreditFund fund = new LetterOfCreditFund(kcAward.getMethodOfPayment().getMethodOfPaymentCode(), kcAward.getMethodOfPayment().getDescription());
            fund.setLetterOfCreditFundAmount(new KualiDecimal(kcAward.getLocFundAmount()));
            award.setLetterOfCreditFund(fund);
        }
        award.setBillingFrequencyCode(kcAward.getInvoiceBillingFrequency());
        award.setAwardPrimaryProjectDirector(this.getProjectDirector(kcAward));
        award.setExcludedFromInvoicing(kcAward.isExcludedFromInvoicing());
        award.setExcludedFromInvoicingReason(kcAward.getExcludedFromInvoicingReason());
        award.setSequenceNumber(kcAward.getSequenceNumber());
        award.setSequenceStatus(kcAward.getSequenceStatus());
        award.setAwardAccounts(this.awardAccountsFromAwardAccountDTOs(kcAward.getAwardAccounts()));
        return award;
    }

    protected List<AwardAccount> awardAccountsFromAwardAccountDTOs(List<AwardAccountDTO> awardAccountDTOs) {
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        for (AwardAccountDTO awardAccountDTO : awardAccountDTOs) {
            if (!StringUtils.isEmpty((CharSequence)awardAccountDTO.getErrorMessage())) continue;
            AwardAccount awardAccount = new AwardAccount(awardAccountDTO);
            Account account = (Account)this.businessObjectService.findByPrimaryKey(Account.class, awardAccount.getPrimaryKeys());
            awardAccount.setAccount(account);
            awardAccounts.add(awardAccount);
        }
        return awardAccounts;
    }

    protected AwardProjectDirector getProjectDirector(AwardDTO kcAward) {
        AwardProjectDirector director = new AwardProjectDirector();
        director.setPrincipalId(kcAward.getPrincipalInvestigatorId());
        director.setProjectDirector((PersonImpl)this.getPersonService().getPerson(kcAward.getPrincipalInvestigatorId()));
        director.setProposalNumber(kcAward.getAwardNumber());
        return director;
    }

    protected AccountDefaultsService getAccountDefaultsService() {
        return this.accountDefaultsService;
    }

    public void setAccountDefaultsService(AccountDefaultsService accountDefaultsService) {
        this.accountDefaultsService = accountDefaultsService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

