/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.AwardAccount;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.webService.InstitutionalUnitSoapService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kra.external.unit.service.InstitutionalUnitService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class ContractsAndGrantsModuleServiceImpl
implements ContractsAndGrantsModuleService {
    private static final Logger LOG = LogManager.getLogger();
    protected BusinessObjectService businessObjectService;
    protected ExternalizableBusinessObjectService awardAccountService;
    protected PersonService personService;
    protected ParameterService parameterService;

    protected List<AwardAccount> getAwardAccounts(String chartCode, String accountNumber) {
        HashMap<String, String> objectKeys = new HashMap<String, String>();
        if (chartCode != null && !chartCode.isEmpty()) {
            objectKeys.put("chartOfAccountsCode", chartCode);
        }
        objectKeys.put("accountNumber", accountNumber);
        return (List)this.awardAccountService.findMatching(objectKeys);
    }

    protected InstitutionalUnitService getInstitutionalUnitWebService() {
        InstitutionalUnitService institutionalUnitService = (InstitutionalUnitService)GlobalResourceLoader.getService((QName)KcConstants.Unit.SERVICE);
        if (institutionalUnitService == null) {
            InstitutionalUnitSoapService institutionalUnitSoapService;
            try {
                institutionalUnitSoapService = new InstitutionalUnitSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error("Could not initialize InstitutionalUnitSoapService: " + ex.getMessage());
                throw new RuntimeException("Could not initialize InstitutionalUnitSoapService: " + ex.getMessage());
            }
            institutionalUnitService = institutionalUnitSoapService.getInstitutionalUnitServicePort();
        }
        return institutionalUnitService;
    }

    public List<String> getParentUnits(String unitNumber) {
        return this.getInstitutionalUnitWebService().getParentUnits(unitNumber);
    }

    public Person getProjectDirectorForAccount(String chartOfAccountsCode, String accountNumber) {
        List<AwardAccount> awardAccountDTOs = this.getAwardAccounts(chartOfAccountsCode, accountNumber);
        AwardAccount awardAccount = this.determineAwardAccountForProjectDirector(awardAccountDTOs);
        if (awardAccount == null) {
            return null;
        }
        String projectDirectorId = awardAccount.getPrincipalId();
        LOG.debug("getProjectDirectorForAccount Web Service sent " + chartOfAccountsCode + "/" + accountNumber + " got " + projectDirectorId);
        if (projectDirectorId != null) {
            return this.personService.getPerson(projectDirectorId);
        }
        return null;
    }

    public Person getProjectDirectorForAccount(Account account) {
        if (account != null) {
            String chartOfAccountsCode = account.getChartOfAccountsCode();
            String accountNumber = account.getAccountNumber();
            return this.getProjectDirectorForAccount(chartOfAccountsCode, accountNumber);
        }
        return null;
    }

    protected AwardAccount determineAwardAccountForProjectDirector(List<AwardAccount> awardAccounts) {
        AwardAccount awardAccountReturn = null;
        if (ObjectUtils.isNotNull(awardAccounts)) {
            awardAccounts.sort((o1, o2) -> {
                String awardId1 = String.valueOf(o1.getAward().getProposalNumber());
                String awardId2 = String.valueOf(o2.getAward().getProposalNumber());
                return awardId2.compareTo(awardId1);
            });
        }
        if (ObjectUtils.isNotNull(awardAccounts) && !awardAccounts.isEmpty()) {
            for (AwardAccount awardAccount : awardAccounts) {
                if (!StringUtils.isNotBlank((CharSequence)awardAccount.getPrincipalId())) continue;
                awardAccountReturn = awardAccount;
                break;
            }
        }
        return awardAccountReturn;
    }

    public boolean isAwardedByFederalAgency(String chartOfAccountsCode, String accountNumber, Collection<String> federalAgencyTypeCodes) {
        boolean _isFederalSponsor_return = false;
        List<AwardAccount> awardAccounts = this.getAwardAccounts(chartOfAccountsCode, accountNumber);
        AwardAccount awardAccount = this.determineAwardAccountForFederalAgency(awardAccounts);
        if (ObjectUtils.isNotNull((Object)awardAccount)) {
            _isFederalSponsor_return = awardAccount.isFederalSponsor();
        }
        LOG.debug("isAwardedByFederalAgency" + accountNumber + " got " + _isFederalSponsor_return);
        return _isFederalSponsor_return;
    }

    protected AwardAccount determineAwardAccountForFederalAgency(List<AwardAccount> awardAccounts) {
        AwardAccount awardAccountReturn = null;
        if (ObjectUtils.isNotNull(awardAccounts)) {
            awardAccounts.sort((o1, o2) -> {
                String awardId1 = String.valueOf(o1.getProposalNumber());
                String awardId2 = String.valueOf(o2.getProposalNumber());
                return awardId2.compareTo(awardId1);
            });
        }
        if (ObjectUtils.isNotNull(awardAccounts) && !awardAccounts.isEmpty()) {
            awardAccountReturn = awardAccounts.stream().findFirst().orElse(null);
        }
        return awardAccountReturn;
    }

    public List<Integer> getAllAccountReponsiblityIds() {
        int maxResponsibilityId = this.getMaxiumAccountResponsibilityId();
        ArrayList<Integer> contractsAndGrantsResponsiblityIds = new ArrayList<Integer>();
        for (int id = 1; id <= maxResponsibilityId; ++id) {
            contractsAndGrantsResponsiblityIds.add(id);
        }
        return contractsAndGrantsResponsiblityIds;
    }

    public boolean hasValidAccountReponsiblityIdIfNotNull(Account account) {
        Integer accountResponsibilityId = account.getContractsAndGrantsAccountResponsibilityId();
        if (accountResponsibilityId == null) {
            return true;
        }
        return accountResponsibilityId >= 1 && accountResponsibilityId <= this.getMaxiumAccountResponsibilityId();
    }

    public String getProposalNumberForAccountAndProjectDirector(String chartOfAccountsCode, String accountNumber, String projectDirectorId) {
        String proposalNumber = null;
        List<AwardAccount> awardAccountDTOs = this.getAwardAccounts(chartOfAccountsCode, accountNumber);
        AwardAccount awardAccount = this.determineAwardAccountForProjectDirector(awardAccountDTOs);
        if (ObjectUtils.isNotNull((Object)awardAccount)) {
            String awardProjectDirectorId = awardAccount.getPrincipalId();
            LOG.debug("getProjectDirectorForAccount Web Service sent " + chartOfAccountsCode + "/" + accountNumber + " got " + StringUtils.trimToEmpty((String)awardProjectDirectorId));
            if (StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)awardProjectDirectorId), (CharSequence)StringUtils.trimToEmpty((String)projectDirectorId)) && ObjectUtils.isNotNull((Object)awardAccount.getAward())) {
                proposalNumber = awardAccount.getAward().getProposalNumber();
            }
        }
        return proposalNumber;
    }

    protected int getMaxiumAccountResponsibilityId() {
        String maxResponsibilityId = this.getParameterService().getParameterValueAsString(KfsParameterConstants.CHART_ALL.class, "MAXIMUM_ACCOUNT_RESPONSIBILITY_ID");
        return Integer.valueOf(maxResponsibilityId);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ExternalizableBusinessObjectService getAwardAccountService() {
        return this.awardAccountService;
    }

    public void setAwardAccountService(ExternalizableBusinessObjectService awardAccountService) {
        this.awardAccountService = awardAccountService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

