/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.external.kc.businessobject.inquiry;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.HtmlData.AnchorHtmlData;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.AccountAutoCreateDefaults;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.krad.bo.BusinessObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Inquirable class for {@link Account}
 */
public class AccountAutoCreateDefInquirable extends KualiInquirableImpl {

    @Override
    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if (KcConstants.ACCOUNT_CREATE_DEFAULT_IDENTIFIER.equals(attributeName)) {
            String baseUrl = KRADConstants.INQUIRY_ACTION;

            Map<String, String> parameters = new HashMap<>();
            parameters.put(KFSConstants.DISPATCH_REQUEST_PARAMETER, KFSConstants.START_METHOD);
            parameters.put(KFSConstants.BUSINESS_OBJECT_CLASS_ATTRIBUTE, AccountAutoCreateDefaults.class.getName());
            parameters.put(KFSConstants.DOC_FORM_KEY, "88888888");

            Map<String, String> inquiryFields = new HashMap<>();
            String acctIdentifier = ObjectUtils.getPropertyValue(businessObject, attributeName).toString();
            if (StringUtils.isBlank(acctIdentifier)) {
                return new AnchorHtmlData();
            }
            inquiryFields.put(KcConstants.ACCOUNT_CREATE_DEFAULT_IDENTIFIER, acctIdentifier);
            parameters.put(KcConstants.ACCOUNT_CREATE_DEFAULT_IDENTIFIER, acctIdentifier);

            return getHyperLink(AccountAutoCreateDefaults.class, inquiryFields, UrlFactory.parameterizeUrl(baseUrl,
                    parameters));
        }

        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

}
