/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.kns.datadictionary;

@Deprecated
public class BusinessObjectEntry extends org.kuali.kfs.krad.datadictionary.BusinessObjectEntry {

    protected InquiryDefinition inquiryDefinition;
    protected LookupDefinition lookupDefinition;
    protected BusinessObjectAdminService businessObjectAdminService;

    @Override
    public void completeValidation() {

        super.completeValidation();

        if (hasInquiryDefinition()) {
            inquiryDefinition.completeValidation(getDataObjectClass(), null);
        }

        if (hasLookupDefinition()) {
            lookupDefinition.completeValidation(getDataObjectClass(), null);
        }
    }

    /**
     * @return {@code true} if this instance has an inquiryDefinition.
     */
    public boolean hasInquiryDefinition() {
        return (inquiryDefinition != null);
    }

    /**
     * @return current inquiryDefinition for this BusinessObjectEntry, or {@code null} if there is none.
     */
    public InquiryDefinition getInquiryDefinition() {
        return inquiryDefinition;
    }

    /**
     * The inquiry element is used to specify the fields that will be displayed on the inquiry screen for this business
     * object and the order in which they will appear.
     * <p>
     * JSTL: The inquiry element is a Map which is accessed using a key of "inquiry".
     * <br>This map contains the following
     * keys:
     * <ul><li>title (String)</li>
     * </li>inquiryFields (Map)</li></ul>
     * @see InquiryDefinition
     * @see org.kuali.kfs.kns.datadictionary.exporter.InquiryMapBuilder
     */
    public void setInquiryDefinition(InquiryDefinition inquiryDefinition) {
        this.inquiryDefinition = inquiryDefinition;
    }

    /**
     * @return {@code true} if this instance has a lookupDefinition.
     */
    public boolean hasLookupDefinition() {
        return (lookupDefinition != null);
    }

    /**
     * @return current lookupDefinition for this BusinessObjectEntry, or {@code null} if there is none.
     */
    public LookupDefinition getLookupDefinition() {
        return lookupDefinition;
    }

    /**
     * The lookup element is used to specify the rules for "looking up" a business object. These specifications define
     * the following:
     * <ul><li>How to specify the search criteria used to locate a set of business objects</li>
     * <li>How to display the search results</li></ul>
     * <p>
     * JSTL: The lookup element is a Map which is accessed using a key of "lookup".
     * <br>This map contains the following keys:
     * <ul><li>lookupableID (String, optional)</li>
     * <li>title (String)</li>
     * <li>menubar (String, optional)</li>
     * <li>defaultSort (Map, optional)</li>
     * <li>lookupFields (Map)</li>
     * <li>resultFields (Map)</li>
     * <li>resultSetLimit (String, optional)</li></ul>
     * @see LookupDefinition
     * @see org.kuali.kfs.kns.datadictionary.exporter.LookupMapBuilder
     */
    public void setLookupDefinition(LookupDefinition lookupDefinition) {
        this.lookupDefinition = lookupDefinition;
    }

    /**
     * @return current BusinessObjectAdminService for this BusinessObjectEntry, or {@code null} if there is none.
     */
    public BusinessObjectAdminService getBusinessObjectAdminService() {
        return this.businessObjectAdminService;
    }

    public void setBusinessObjectAdminService(BusinessObjectAdminService businessObjectAdminService) {
        this.businessObjectAdminService = businessObjectAdminService;
    }
}
