/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.comparator;

import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class NumericValueComparator implements Comparator {
    private static List<Class<? extends Comparable>> numericClasses = Arrays.asList(
            Integer.class,
            Long.class,
            Short.class,
            Byte.class,
            Double.class,
            Float.class,
            BigDecimal.class,
            BigInteger.class,
            KualiDecimal.class,
            KualiInteger.class);

    @Override
    public int compare(Object o1, Object o2) {
        for (Class clazz:numericClasses) {
            if (o1.getClass() == clazz && o2.getClass() == clazz) {
                return ((Comparable)o1).compareTo(o2);
            }
        }
        throw new ClassCastException("Unable to cast object " + o1 + " and " + o2 + " to the same numeric class");
    }
}
