/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.datadictionary.validation;

import org.kuali.kfs.krad.datadictionary.exporter.ExportMap;
import org.kuali.rice.core.api.exception.RiceRuntimeException;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Abstraction of the regular expressions used to validate attribute values.
 * <p>
 * The validationPattern element defines the allowable character-level
 * or field-level values for an attribute.
 * <p>
 * JSTL: validationPattern is a Map which is accessed using a key
 * of "validationPattern". Each entry may contain some of the keys
 * listed below.  The keys that may be present for a given attribute
 * are dependent upon the type of validationPattern.
 * <p>
 * maxLength (String)
 * exactLength
 * type
 * allowWhitespace
 * allowUnderscore
 * allowPeriod
 * validChars
 * precision
 * scale
 * allowNegative
 * <p>
 * The allowable keys (in addition to type) for each type are:
 * ***Type****    ***Keys***
 * alphanumeric    exactLength
 * maxLength
 * allowWhitespace
 * allowUnderscore
 * allowPeriod
 * <p>
 * alpha           exactLength
 * maxLength
 * allowWhitespace
 * <p>
 * anyCharacter    exactLength
 * maxLength
 * allowWhitespace
 * <p>
 * charset         validChars
 * <p>
 * numeric         exactLength
 * maxLength
 * <p>
 * fixedPoint      allowNegative
 * precision
 * scale
 * <p>
 * floatingPoint   allowNegative
 * <p>
 * date            n/a
 * emailAddress    n/a
 * javaClass       n/a
 * month           n/a
 * phoneNumber     n/a
 * timestamp       n/a
 * year            n/a
 * zipcode         n/a
 * <p>
 * Note: maxLength and exactLength are mutually exclusive.
 * If one is entered, the other may not be entered.
 * <p>
 * Note:  See ApplicationResources.properties for
 * exact regex patterns.
 * e.g. validationPatternRegex.date for regex used in date validation.
 */
@Deprecated
abstract public class ValidationPattern implements Serializable {
// TODO: UNIT TEST: compile all patterns to test

    /**
     * @return regular expression Pattern generated by the individual ValidationPattern subclass
     */
    abstract public Pattern getRegexPattern();

    /**
     * @return String version of regular expression base, suitable for modification with length-specifiers and used internally by
     * getRegexPattern
     */
    abstract protected String getRegexString();


    /**
     * @return true if the given String matches this pattern
     */
    public boolean matches(String input) {
        Pattern p = getRegexPattern();

        Matcher m = p.matcher(input);

        return m.matches();
    }

    /**
     * @return ExportMap describing the subclass instance
     */
    abstract public ExportMap buildExportMap(String exportKey);

    abstract public String getValidationErrorMessageKey();

    public String[] getValidationErrorMessageParameters(String attributeLabel) {
        return new String[]{attributeLabel};
    }

    /**
     * This method throws an exception if it is not configured properly
     */
    public void completeValidation() throws ValidationPatternException {
    }

    /**
     * exception thrown when a ValidationPattern is in an incorrect state.
     */
    public static class ValidationPatternException extends RiceRuntimeException {

        private static final long serialVersionUID = 2012770642382150523L;

        public ValidationPatternException(String message) {
            super(message);
        }

        public ValidationPatternException() {
            super();
        }

        public ValidationPatternException(String message, Throwable cause) {
            super(message, cause);
        }

        public ValidationPatternException(Throwable cause) {
            super(cause);
        }
    }
}
