/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.service;

import javax.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Map;

public interface LookupSearchService {

    /**
     * @return {@code true} if the search results for the associated lookup should include 'action's; {@code false}
     *         otherwise.
     */
    boolean hasActions();

    /**
     * @param fieldValues {@link MultivaluedMap} containing the search parameters; in the normal expected use case,
     *                    these will be query parameters.
     * @return a List of all the results; this roughly corresponds to a row in the lookup results table.
     */
    List<Map<String, Object>> getSearchResults(MultivaluedMap<String, String> fieldValues);
}
