/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.impl.component;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.kuali.kfs.coreservice.api.component.Component;
import org.kuali.kfs.coreservice.api.namespace.NamespaceService;
import org.kuali.kfs.coreservice.framework.component.ComponentEbo;
import org.kuali.kfs.coreservice.impl.component.ComponentId;
import org.kuali.kfs.coreservice.impl.namespace.NamespaceBo;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;

@IdClass(value=ComponentId.class)
@Entity
@Table(name="KRCR_CMPNT_T")
public class ComponentBo
extends PersistableBusinessObjectBase
implements ComponentEbo {
    private static final long serialVersionUID = 1L;
    private static transient NamespaceService namespaceService;
    @Id
    @Column(name="NMSPC_CD")
    private String namespaceCode;
    @Id
    @Column(name="CMPNT_CD")
    private String code;
    @Column(name="NM")
    private String name;
    @Column(name="ACTV_IND")
    private boolean active = true;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="NMSPC_CD", insertable=false, updatable=false)
    private NamespaceBo namespace;

    @Override
    public String getComponentSetId() {
        return null;
    }

    public static Component to(ComponentBo bo) {
        if (bo == null) {
            return null;
        }
        return Component.Builder.create(bo).build();
    }

    public static ComponentBo from(Component im) {
        if (im == null) {
            return null;
        }
        ComponentBo bo = new ComponentBo();
        bo.setCode(im.getCode());
        bo.setName(im.getName());
        bo.setActive(im.isActive());
        bo.setNamespaceCode(im.getNamespaceCode());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        bo.setNamespace(NamespaceBo.from(namespaceService.getNamespace(bo.namespaceCode)));
        return bo;
    }

    public static void setNamespaceService(NamespaceService namespaceService2) {
        namespaceService = namespaceService2;
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public NamespaceBo getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceBo namespace) {
        this.namespace = namespace;
    }
}

