/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.rules;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.kuali.kfs.kns.rule.PromptBeforeValidation;
import org.kuali.kfs.kns.rule.event.PromptBeforeValidationEvent;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.document.Document;

public abstract class PromptBeforeValidationBase
implements PromptBeforeValidation {
    private static final Logger LOG = LogManager.getLogger(PromptBeforeValidationBase.class);
    protected String question;
    protected String buttonClicked;
    protected PromptBeforeValidationEvent event;
    protected KualiForm form;
    private boolean isAborting;
    ContextSession session;

    public PromptBeforeValidationEvent getEvent() {
        return this.event;
    }

    public abstract boolean doPrompts(Document var1);

    @Override
    public boolean processPrompts(ActionForm form, HttpServletRequest request, PromptBeforeValidationEvent event) {
        boolean result;
        this.question = request.getParameter("questionIndex");
        this.buttonClicked = request.getParameter("buttonClicked");
        this.event = event;
        this.form = (KualiForm)form;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Question is: " + this.question);
            LOG.debug("ButtonClicked: " + this.buttonClicked);
            LOG.debug("QuestionContext() is: " + event.getQuestionContext());
        }
        this.session = new ContextSession(request.getParameter("context"), event);
        try {
            result = this.doPrompts(event.getDocument());
        }
        catch (IsAskingException e) {
            return false;
        }
        if (this.isAborting) {
            return false;
        }
        return result;
    }

    public void abortRulesCheck() {
        this.event.setActionForwardName("basic");
        this.isAborting = true;
    }

    public boolean askOrAnalyzeYesNoQuestion(String id, String text) throws IsAskingException {
        LOG.debug("Entering askOrAnalyzeYesNoQuestion(" + id + "," + text + ")");
        String cached = this.session.getAttribute(id);
        if (cached != null) {
            LOG.debug("returning cached value: " + id + "=" + cached);
            return Boolean.valueOf(cached);
        }
        if (id.equals(this.question)) {
            this.session.setAttribute(id, Boolean.toString(!"1".equals(this.buttonClicked)));
            return !"1".equals(this.buttonClicked);
        }
        if (!this.session.hasAsked(id)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Forcing question to be asked: " + id);
            }
            this.session.askQuestion(id, text);
        }
        LOG.debug("Throwing Exception to force return to Action");
        throw new IsAskingException();
    }

    public class ContextSession {
        private static final String DELIMITER = ".";
        PromptBeforeValidationEvent event;

        public ContextSession(String context, PromptBeforeValidationEvent event) {
            this.event = event;
            this.event.setQuestionContext(context);
            if (this.event.getQuestionContext() == null) {
                this.event.setQuestionContext("");
            }
        }

        public boolean hasAsked(String id) {
            return StringUtils.contains((CharSequence)this.event.getQuestionContext(), (CharSequence)id);
        }

        public void askQuestion(String id, String text) {
            this.event.setQuestionId(id);
            this.event.setQuestionType("cf.confirmationQuestion");
            this.event.setQuestionText(text);
            this.event.setPerformQuestion(true);
        }

        public void setAttribute(String name, String value) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("setAttribute(" + name + "," + value + ")");
            }
            this.event.setQuestionContext(this.event.getQuestionContext() + DELIMITER + name + DELIMITER + value);
        }

        public String getAttribute(String name) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAttribute(" + name + ")");
            }
            String result = null;
            Iterator<String> values = Arrays.asList(this.event.getQuestionContext().split("\\.")).iterator();
            while (values.hasNext()) {
                if (!values.next().equals(name)) continue;
                try {
                    result = values.next();
                }
                catch (NoSuchElementException e) {
                    result = null;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("returning " + result);
            }
            return result;
        }
    }

    private class IsAskingException
    extends RuntimeException {
        private IsAskingException() {
        }
    }
}

