/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.BusinessObjectAdminService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.datadictionary.InquiryDefinition;
import org.kuali.kfs.kns.datadictionary.InquirySectionDefinition;
import org.kuali.kfs.kns.datadictionary.LookupDefinition;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.kns.inquiry.InquiryAuthorizer;
import org.kuali.kfs.kns.inquiry.InquiryAuthorizerBase;
import org.kuali.kfs.kns.inquiry.InquiryPresentationController;
import org.kuali.kfs.kns.inquiry.InquiryPresentationControllerBase;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.LookupAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.LookupResultAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.SortDefinition;
import org.kuali.kfs.krad.exception.IntrospectionException;
import org.kuali.kfs.krad.exception.ReferenceAttributeNotAnOjbReferenceException;
import org.kuali.kfs.krad.inquiry.Inquirable;
import org.kuali.kfs.krad.service.LookupSearchService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.valuefinder.ValueFinder;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public class BusinessObjectDictionaryService {
    private static final Logger LOG = LogManager.getLogger(BusinessObjectDictionaryService.class);
    private DataDictionaryService dataDictionaryService;
    private PersistenceStructureService persistenceStructureService;

    public <T extends BusinessObject> InquiryAuthorizer getInquiryAuthorizer(Class<T> businessObjectClass) {
        Class<? extends InquiryAuthorizer> inquiryAuthorizerClass = ((BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObjectClass.getName())).getInquiryDefinition().getAuthorizerClass();
        if (inquiryAuthorizerClass == null) {
            inquiryAuthorizerClass = InquiryAuthorizerBase.class;
        }
        try {
            return inquiryAuthorizerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate InquiryAuthorizer class: " + inquiryAuthorizerClass, e);
        }
    }

    public <T extends BusinessObject> InquiryPresentationController getInquiryPresentationController(Class<T> businessObjectClass) {
        Class<? extends InquiryPresentationController> inquiryPresentationControllerClass = ((BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObjectClass.getName())).getInquiryDefinition().getPresentationControllerClass();
        if (inquiryPresentationControllerClass == null) {
            inquiryPresentationControllerClass = InquiryPresentationControllerBase.class;
        }
        try {
            return inquiryPresentationControllerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate InquiryPresentationController class: " + inquiryPresentationControllerClass, e);
        }
    }

    @Deprecated
    public List getBusinessObjectClassnames() {
        return this.getDataDictionaryService().getDataDictionary().getBusinessObjectClassNames();
    }

    public Boolean isLookupable(Class businessObjectClass) {
        Boolean isLookupable = Boolean.FALSE;
        BusinessObjectEntry entry = this.getBusinessObjectEntry(businessObjectClass);
        if (entry != null) {
            isLookupable = entry.hasLookupDefinition();
        }
        return isLookupable;
    }

    public Boolean isInquirable(Class businessObjectClass) {
        Boolean isInquirable = Boolean.FALSE;
        BusinessObjectEntry entry = this.getBusinessObjectEntry(businessObjectClass);
        if (entry != null) {
            isInquirable = entry.hasInquiryDefinition();
        }
        return isInquirable;
    }

    public Boolean isMaintainable(Class businessObjectClass) {
        Boolean isMaintainable = Boolean.FALSE;
        BusinessObjectEntry entry = this.getBusinessObjectEntry(businessObjectClass);
        if (entry != null) {
            isMaintainable = this.getMaintenanceDocumentEntry(businessObjectClass) != null;
        }
        return isMaintainable;
    }

    public Boolean isExportable(Class businessObjectClass) {
        Boolean isExportable = Boolean.FALSE;
        BusinessObjectEntry entry = this.getBusinessObjectEntry(businessObjectClass);
        if (entry != null) {
            isExportable = entry.getExporterClass() != null;
        }
        return isExportable;
    }

    public List<String> getLookupFieldNames(Class businessObjectClass) {
        List results = null;
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null) {
            results = lookupDefinition.getLookupFieldNames();
        }
        return results;
    }

    public String getLookupTitle(Class businessObjectClass) {
        String lookupTitle = "";
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null) {
            lookupTitle = lookupDefinition.getTitle();
        }
        return lookupTitle;
    }

    public String getLookupMenuBar(Class businessObjectClass) {
        String menubar = "";
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null && lookupDefinition.hasMenubar()) {
            menubar = lookupDefinition.getMenubar();
        }
        return menubar;
    }

    public String getExtraButtonSource(Class businessObjectClass) {
        String buttonSource = "";
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null && lookupDefinition.hasExtraButtonSource()) {
            buttonSource = lookupDefinition.getExtraButtonSource();
        }
        return buttonSource;
    }

    public String getExtraButtonParams(Class businessObjectClass) {
        String buttonParams = "";
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null && lookupDefinition.hasExtraButtonParams()) {
            buttonParams = lookupDefinition.getExtraButtonParams();
        }
        return buttonParams;
    }

    public String getSearchIconOverride(Class businessObjectClass) {
        String iconUrl = "";
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null && lookupDefinition.hasSearchIconOverride()) {
            iconUrl = lookupDefinition.getSearchIconOverride();
        }
        return iconUrl;
    }

    public List<String> getLookupDefaultSortFieldNames(Class businessObjectClass) {
        List<Object> defaultSort = null;
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null && lookupDefinition.hasDefaultSort()) {
            defaultSort = lookupDefinition.getDefaultSort().getAttributeNames();
        }
        if (defaultSort == null) {
            defaultSort = new ArrayList();
        }
        return defaultSort;
    }

    public SortDefinition getLookupDefaultSortDefinition(Class businessObjectClass) {
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null && lookupDefinition.hasDefaultSort()) {
            return lookupDefinition.getDefaultSort();
        }
        return null;
    }

    public List<String> getLookupResultFieldNames(Class businessObjectClass) {
        List<String> results = null;
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null) {
            results = lookupDefinition.getResultFieldNames();
        }
        return results;
    }

    public Integer getLookupResultFieldMaxLength(Class businessObjectClass, String resultFieldName) {
        FieldDefinition field;
        Integer resultFieldMaxLength = null;
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null && (field = lookupDefinition.getResultField(resultFieldName)) != null) {
            resultFieldMaxLength = field.getMaxLength();
        }
        return resultFieldMaxLength;
    }

    public Integer getLookupResultSetLimit(Class businessObjectClass) {
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null) {
            return lookupDefinition.getResultSetLimit();
        }
        return null;
    }

    public Integer getMultipleValueLookupResultSetLimit(Class businessObjectClass) {
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null) {
            return lookupDefinition.getMultipleValuesResultSetLimit();
        }
        return null;
    }

    public Integer getLookupNumberOfColumns(Class businessObjectClass) {
        int numberOfColumns = 1;
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null && lookupDefinition.getNumOfColumns() > 1) {
            numberOfColumns = lookupDefinition.getNumOfColumns();
        }
        return numberOfColumns;
    }

    public Boolean getLookupAttributeRequired(Class businessObjectClass, String attributeName) {
        Boolean isRequired = null;
        FieldDefinition definition = this.getLookupFieldDefinition(businessObjectClass, attributeName);
        if (definition != null) {
            isRequired = definition.isRequired();
        }
        return isRequired;
    }

    public Boolean getLookupAttributeReadOnly(Class businessObjectClass, String attributeName) {
        Boolean readOnly = null;
        FieldDefinition definition = this.getLookupFieldDefinition(businessObjectClass, attributeName);
        if (definition != null) {
            readOnly = definition.isReadOnly();
        }
        return readOnly;
    }

    public List getInquiryFieldNames(Class businessObjectClass, String sectionTitle) {
        List<String> results = null;
        InquirySectionDefinition inquirySection = this.getInquiryDefinition(businessObjectClass).getInquirySection(sectionTitle);
        if (inquirySection != null) {
            results = inquirySection.getInquiryFieldNames();
        }
        return results;
    }

    public List<InquirySectionDefinition> getInquirySections(Class businessObjectClass) {
        List<InquirySectionDefinition> results = null;
        results = this.getInquiryDefinition(businessObjectClass).getInquirySections();
        return results;
    }

    public String getInquiryTitle(Class businessObjectClass) {
        String title = "";
        InquiryDefinition inquiryDefinition = this.getInquiryDefinition(businessObjectClass);
        if (inquiryDefinition != null) {
            title = inquiryDefinition.getTitle();
        }
        return title;
    }

    public Class getInquirableClass(Class businessObjectClass) {
        Class<? extends Inquirable> clazz = null;
        InquiryDefinition inquiryDefinition = this.getInquiryDefinition(businessObjectClass);
        if (inquiryDefinition != null) {
            clazz = inquiryDefinition.getInquirableClass();
        }
        return clazz;
    }

    public String getMaintainableLabel(Class businessObjectClass) {
        String label = "";
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(businessObjectClass);
        if (entry != null) {
            label = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(entry.getDocumentTypeName()).getLabel();
        }
        return label;
    }

    public String getLookupableID(Class businessObjectClass) {
        String lookupableID = null;
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null) {
            lookupableID = lookupDefinition.getLookupableID();
        }
        return lookupableID;
    }

    public void performForceUppercase(BusinessObject bo) {
        this.performForceUppercaseCycleSafe(bo, new HashSet<BusinessObject>());
    }

    protected void performForceUppercaseCycleSafe(BusinessObject bo, Set<BusinessObject> visited) {
        if (visited.contains(bo)) {
            return;
        }
        visited.add(bo);
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors((Object)bo);
        for (int i = 0; i < descriptors.length; ++i) {
            try {
                if (descriptors[i] instanceof IndexedPropertyDescriptor) continue;
                Object nestedObject = ObjectUtils.getPropertyValue(bo, descriptors[i].getName());
                if (ObjectUtils.isNotNull(nestedObject) && nestedObject instanceof BusinessObject) {
                    if (!this.persistenceStructureService.isPersistable(nestedObject.getClass())) continue;
                    try {
                        if (!this.persistenceStructureService.hasReference(bo.getClass(), descriptors[i].getName()) || !this.persistenceStructureService.isReferenceUpdatable(bo.getClass(), descriptors[i].getName()) || !this.persistenceStructureService.getForeignKeyFieldsPopulationState((PersistableBusinessObject)bo, descriptors[i].getName()).isAllFieldsPopulated()) continue;
                        this.performForceUppercaseCycleSafe((BusinessObject)nestedObject, visited);
                    }
                    catch (ReferenceAttributeNotAnOjbReferenceException ranaore) {
                        LOG.debug("Propery " + descriptors[i].getName() + " is not a foreign key reference.");
                    }
                    continue;
                }
                if (nestedObject instanceof String) {
                    if (!this.dataDictionaryService.isAttributeDefined(bo.getClass(), descriptors[i].getName()).booleanValue() || !this.dataDictionaryService.getAttributeForceUppercase(bo.getClass(), descriptors[i].getName()).booleanValue()) continue;
                    String curValue = (String)nestedObject;
                    PropertyUtils.setProperty((Object)bo, (String)descriptors[i].getName(), (Object)curValue.toUpperCase());
                    continue;
                }
                if (!ObjectUtils.isNotNull(nestedObject) || !(nestedObject instanceof Collection) || !this.persistenceStructureService.hasCollection(bo.getClass(), descriptors[i].getName()) || !this.persistenceStructureService.isCollectionUpdatable(bo.getClass(), descriptors[i].getName())) continue;
                for (Object collElem : (Collection)nestedObject) {
                    if (!(collElem instanceof BusinessObject) || !this.persistenceStructureService.isPersistable(collElem.getClass())) continue;
                    this.performForceUppercaseCycleSafe((BusinessObject)collElem, visited);
                }
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IntrospectionException("unable to performForceUppercase", e);
            }
            catch (InvocationTargetException e) {
                throw new IntrospectionException("unable to performForceUppercase", e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    private BusinessObjectEntry getBusinessObjectEntry(Class businessObjectClass) {
        this.validateBusinessObjectClass(businessObjectClass);
        BusinessObjectEntry entry = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObjectClass.getName());
        return entry;
    }

    private MaintenanceDocumentEntry getMaintenanceDocumentEntry(Class businessObjectClass) {
        this.validateBusinessObjectClass(businessObjectClass);
        MaintenanceDocumentEntry entry = (MaintenanceDocumentEntry)this.getDataDictionaryService().getDataDictionary().getMaintenanceDocumentEntryForBusinessObjectClass(businessObjectClass);
        return entry;
    }

    private LookupDefinition getLookupDefinition(Class businessObjectClass) {
        LookupDefinition lookupDefinition = null;
        BusinessObjectEntry entry = this.getBusinessObjectEntry(businessObjectClass);
        if (entry != null && entry.hasLookupDefinition()) {
            lookupDefinition = entry.getLookupDefinition();
        }
        return lookupDefinition;
    }

    private FieldDefinition getLookupFieldDefinition(Class businessObjectClass, String lookupFieldName) {
        if (StringUtils.isBlank((CharSequence)lookupFieldName)) {
            throw new IllegalArgumentException("invalid (blank) lookupFieldName");
        }
        FieldDefinition fieldDefinition = null;
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null) {
            fieldDefinition = lookupDefinition.getLookupField(lookupFieldName);
        }
        return fieldDefinition;
    }

    private FieldDefinition getLookupResultFieldDefinition(Class businessObjectClass, String lookupFieldName) {
        if (StringUtils.isBlank((CharSequence)lookupFieldName)) {
            throw new IllegalArgumentException("invalid (blank) lookupFieldName");
        }
        FieldDefinition fieldDefinition = null;
        LookupDefinition lookupDefinition = this.getLookupDefinition(businessObjectClass);
        if (lookupDefinition != null) {
            fieldDefinition = lookupDefinition.getResultField(lookupFieldName);
        }
        return fieldDefinition;
    }

    private InquiryDefinition getInquiryDefinition(Class businessObjectClass) {
        InquiryDefinition inquiryDefinition = null;
        BusinessObjectEntry entry = this.getBusinessObjectEntry(businessObjectClass);
        if (entry != null && entry.hasInquiryDefinition()) {
            inquiryDefinition = entry.getInquiryDefinition();
        }
        return inquiryDefinition;
    }

    public String getTitleAttribute(Class businessObjectClass) {
        String titleAttribute = null;
        BusinessObjectEntry entry = this.getBusinessObjectEntry(businessObjectClass);
        if (entry != null) {
            titleAttribute = entry.getTitleAttribute();
        }
        return titleAttribute;
    }

    private FieldDefinition getInquiryFieldDefinition(Class businessObjectClass, String fieldName) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("invalid (blank) fieldName");
        }
        FieldDefinition fieldDefinition = null;
        InquiryDefinition inquiryDefinition = this.getInquiryDefinition(businessObjectClass);
        if (inquiryDefinition != null) {
            fieldDefinition = inquiryDefinition.getFieldDefinition(fieldName);
        }
        return fieldDefinition;
    }

    private void validateBusinessObjectClass(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        if (!BusinessObject.class.isAssignableFrom(businessObjectClass)) {
            throw new IllegalArgumentException("class '" + businessObjectClass.getName() + "' is not a descendant of BusinessObject");
        }
    }

    public Boolean forceLookupResultFieldInquiry(Class businessObjectClass, String attributeName) {
        Boolean forceLookup = null;
        if (this.getLookupResultFieldDefinition(businessObjectClass, attributeName) != null) {
            forceLookup = this.getLookupResultFieldDefinition(businessObjectClass, attributeName).isForceInquiry();
        }
        return forceLookup;
    }

    public Boolean noLookupResultFieldInquiry(Class businessObjectClass, String attributeName) {
        Boolean noLookup = null;
        if (this.getLookupResultFieldDefinition(businessObjectClass, attributeName) != null) {
            noLookup = this.getLookupResultFieldDefinition(businessObjectClass, attributeName).isNoInquiry();
        }
        return noLookup;
    }

    @Deprecated
    public Boolean forceLookupFieldLookup(Class businessObjectClass, String attributeName) {
        Boolean forceLookup = null;
        if (this.getLookupFieldDefinition(businessObjectClass, attributeName) != null) {
            forceLookup = this.getLookupFieldDefinition(businessObjectClass, attributeName).isForceLookup();
        }
        return forceLookup;
    }

    @Deprecated
    public Boolean forceInquiryFieldLookup(Class businessObjectClass, String attributeName) {
        Boolean forceInquiry = null;
        if (this.getLookupFieldDefinition(businessObjectClass, attributeName) != null) {
            forceInquiry = this.getLookupFieldDefinition(businessObjectClass, attributeName).isForceInquiry();
        }
        return forceInquiry;
    }

    public boolean noLookupFieldLookup(Class businessObjectClass, String attributeName) {
        boolean noLookup = false;
        if (this.getLookupFieldDefinition(businessObjectClass, attributeName) != null) {
            noLookup = this.getLookupFieldDefinition(businessObjectClass, attributeName).isNoLookup();
        }
        return noLookup;
    }

    public Boolean noDirectInquiryFieldLookup(Class businessObjectClass, String attributeName) {
        Boolean noDirectInquiry = null;
        if (this.getLookupFieldDefinition(businessObjectClass, attributeName) != null) {
            noDirectInquiry = this.getLookupFieldDefinition(businessObjectClass, attributeName).isNoDirectInquiry();
        }
        return noDirectInquiry;
    }

    public Boolean getLookupResultFieldUseShortLabel(Class businessObjectClass, String attributeName) {
        Boolean useShortLabel = null;
        if (this.getLookupResultFieldDefinition(businessObjectClass, attributeName) != null) {
            useShortLabel = this.getLookupResultFieldDefinition(businessObjectClass, attributeName).isUseShortLabel();
        }
        return useShortLabel;
    }

    public Boolean getLookupResultFieldTotal(Class businessObjectClass, String attributeName) {
        Boolean total = false;
        if (this.getLookupResultFieldDefinition(businessObjectClass, attributeName) != null) {
            total = this.getLookupResultFieldDefinition(businessObjectClass, attributeName).isTotal();
        }
        return total;
    }

    @Deprecated
    public Boolean forceInquiryFieldInquiry(Class businessObjectClass, String attributeName) {
        Boolean forceInquiry = null;
        if (this.getInquiryFieldDefinition(businessObjectClass, attributeName) != null) {
            forceInquiry = this.getInquiryFieldDefinition(businessObjectClass, attributeName).isForceInquiry();
        }
        return forceInquiry;
    }

    public Boolean noInquiryFieldInquiry(Class businessObjectClass, String attributeName) {
        Boolean noInquiry = null;
        if (this.getInquiryFieldDefinition(businessObjectClass, attributeName) != null) {
            noInquiry = this.getInquiryFieldDefinition(businessObjectClass, attributeName).isNoInquiry();
        }
        return noInquiry;
    }

    public String getLookupFieldDefaultValue(Class businessObjectClass, String attributeName) {
        return this.getLookupFieldDefinition(businessObjectClass, attributeName).getDefaultValue();
    }

    public Class<? extends ValueFinder> getLookupFieldDefaultValueFinderClass(Class businessObjectClass, String attributeName) {
        return this.getLookupFieldDefinition(businessObjectClass, attributeName).getDefaultValueFinderClass();
    }

    public String getLookupFieldQuickfinderParameterString(Class businessObjectClass, String attributeName) {
        return this.getLookupFieldDefinition(businessObjectClass, attributeName).getQuickfinderParameterString();
    }

    public Class<? extends ValueFinder> getLookupFieldQuickfinderParameterStringBuilderClass(Class businessObjectClass, String attributeName) {
        return this.getLookupFieldDefinition(businessObjectClass, attributeName).getQuickfinderParameterStringBuilderClass();
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public boolean isLookupFieldTreatWildcardsAndOperatorsAsLiteral(Class businessObjectClass, String attributeName) {
        FieldDefinition lookupFieldDefinition = this.getLookupFieldDefinition(businessObjectClass, attributeName);
        return lookupFieldDefinition != null && lookupFieldDefinition.isTreatWildcardsAndOperatorsAsLiteral();
    }

    public String getInquiryFieldAdditionalDisplayAttributeName(Class businessObjectClass, String attributeName) {
        String additionalDisplayAttributeName = null;
        if (this.getInquiryFieldDefinition(businessObjectClass, attributeName) != null) {
            additionalDisplayAttributeName = this.getInquiryFieldDefinition(businessObjectClass, attributeName).getAdditionalDisplayAttributeName();
        }
        return additionalDisplayAttributeName;
    }

    public String getInquiryFieldAlternateDisplayAttributeName(Class businessObjectClass, String attributeName) {
        String alternateDisplayAttributeName = null;
        if (this.getInquiryFieldDefinition(businessObjectClass, attributeName) != null) {
            alternateDisplayAttributeName = this.getInquiryFieldDefinition(businessObjectClass, attributeName).getAlternateDisplayAttributeName();
        }
        return alternateDisplayAttributeName;
    }

    public String getLookupFieldAdditionalDisplayAttributeName(Class businessObjectClass, String attributeName) {
        String additionalDisplayAttributeName = null;
        if (this.getLookupResultFieldDefinition(businessObjectClass, attributeName) != null) {
            additionalDisplayAttributeName = this.getLookupResultFieldDefinition(businessObjectClass, attributeName).getAdditionalDisplayAttributeName();
        }
        return additionalDisplayAttributeName;
    }

    public String getLookupFieldAlternateDisplayAttributeName(Class businessObjectClass, String attributeName) {
        String alternateDisplayAttributeName = null;
        if (this.getLookupResultFieldDefinition(businessObjectClass, attributeName) != null) {
            alternateDisplayAttributeName = this.getLookupResultFieldDefinition(businessObjectClass, attributeName).getAlternateDisplayAttributeName();
        }
        return alternateDisplayAttributeName;
    }

    public Boolean tranlateCodesInLookup(Class businessObjectClass) {
        boolean translateCodes = false;
        if (this.getLookupDefinition(businessObjectClass) != null) {
            translateCodes = this.getLookupDefinition(businessObjectClass).isTranslateCodes();
        }
        return translateCodes;
    }

    public Boolean tranlateCodesInInquiry(Class businessObjectClass) {
        boolean translateCodes = false;
        if (this.getInquiryDefinition(businessObjectClass) != null) {
            translateCodes = this.getInquiryDefinition(businessObjectClass).isTranslateCodes();
        }
        return translateCodes;
    }

    public boolean isLookupFieldTriggerOnChange(Class businessObjectClass, String attributeName) {
        boolean triggerOnChange = false;
        if (this.getLookupFieldDefinition(businessObjectClass, attributeName) != null) {
            triggerOnChange = this.getLookupFieldDefinition(businessObjectClass, attributeName).isTriggerOnChange();
        }
        return triggerOnChange;
    }

    public boolean disableSearchButtonsInLookup(Class businessObjectClass) {
        boolean disableSearchButtons = false;
        if (this.getLookupDefinition(businessObjectClass) != null) {
            disableSearchButtons = this.getLookupDefinition(businessObjectClass).isDisableSearchButtons();
        }
        return disableSearchButtons;
    }

    public LookupSearchService getLookupSearchServiceForLookup(Class businessObjectClass) {
        return this.getLookupDefinition(businessObjectClass).getLookupSearchService();
    }

    public List<LookupAttributeDefinition> getLookupAttributeDefinitions(Class businessObjectClass) {
        LookupDefinition definition = this.getLookupDefinition(businessObjectClass);
        if (definition != null) {
            return definition.getLookupAttributeDefinitions();
        }
        return Collections.emptyList();
    }

    public LookupAttributeDefinition getLookupAttributeDefinition(Class businessObjectClass, String attributeName) {
        LookupDefinition definition = this.getLookupDefinition(businessObjectClass);
        LookupAttributeDefinition attributeDefinition = null;
        if (definition != null) {
            attributeDefinition = definition.getLookupAttributeDefinition(attributeName);
        }
        return attributeDefinition;
    }

    public List<LookupResultAttributeDefinition> getLookupResultAttributeDefinitions(Class businessObjectClass) {
        return this.getLookupDefinition(businessObjectClass).getLookupResultAttributeDefinitions();
    }

    public LookupResultAttributeDefinition getLookupResultAttributeDefinition(Class businessObjectClass, String resultAttributeName) {
        return this.getLookupDefinition(businessObjectClass).getLookupResultAttributeDefinition(resultAttributeName);
    }

    public BusinessObjectAdminService getBusinessObjectAdminService(Class businessObjectClass) {
        return this.getBusinessObjectEntry(businessObjectClass).getBusinessObjectAdminService();
    }
}

