/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.kns.web.struts.form.BackdoorForm;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class BackdoorAction
extends KualiAction {
    private static final Logger LOG = LogManager.getLogger(BackdoorAction.class);
    private List<Permission> perms;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initForm(request, form);
        return super.execute(mapping, form, request, response);
    }

    public ActionForward menu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("menu");
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.portal(mapping, form, request, response);
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("start");
        return this.portal(mapping, form, request, response);
    }

    public ActionForward portal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("portal started");
        return mapping.findForward("viewPortal");
    }

    public ActionForward administration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("administration");
        return mapping.findForward("administration");
    }

    public ActionForward logout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("logout");
        String forward = "viewPortal";
        UserSession uSession = BackdoorAction.getUserSession(request);
        if (uSession.isBackdoorInUse()) {
            uSession.clearBackdoorUser();
            this.setFormGroupPermission((BackdoorForm)form, request);
            UserSession KnsUserSession = GlobalVariables.getUserSession();
            KnsUserSession.clearBackdoorUser();
        } else {
            forward = "logout";
        }
        return mapping.findForward(forward);
    }

    public ActionForward login(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("login");
        UserSession uSession = BackdoorAction.getUserSession(request);
        BackdoorForm backdoorForm = (BackdoorForm)form;
        uSession.clearObjectMap();
        if (!this.isBackdoorAuthorized(uSession, request)) {
            request.setAttribute("backdoorRestriction", (Object)("User " + uSession.getActualPerson().getPrincipalName() + " not permitted to use backdoor functionality inside application: " + ConfigContext.getCurrentContextConfig().getProperty("app.code") + "."));
            return this.logout(mapping, form, request, response);
        }
        if (uSession.isBackdoorInUse() && (StringUtils.isEmpty((CharSequence)backdoorForm.getBackdoorId()) || uSession.getLoggedInUserPrincipalName().equals(backdoorForm.getBackdoorId()))) {
            return this.logout(mapping, form, request, response);
        }
        try {
            uSession.setBackdoorUser(backdoorForm.getBackdoorId());
        }
        catch (RiceRuntimeException e) {
            LOG.warn("invalid backdoor id " + backdoorForm.getBackdoorId(), (Throwable)e);
            return mapping.findForward("invalid_backdoor_portal");
        }
        this.setFormGroupPermission(backdoorForm, request);
        return mapping.findForward("portal");
    }

    private void setFormGroupPermission(BackdoorForm backdoorForm, HttpServletRequest request) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", "KR-WKFLW");
        permissionDetails.put("actionClass", "org.kuali.rice.kew.web.backdoor.AdministrationAction");
        boolean isAdmin = KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(BackdoorAction.getUserSession(request).getPrincipalId(), "KR-NS", "Use Screen", permissionDetails, new HashMap());
        backdoorForm.setIsAdmin(isAdmin);
    }

    public void initForm(HttpServletRequest request, ActionForm form) throws Exception {
        BackdoorForm backdoorForm = (BackdoorForm)form;
        Boolean showBackdoorLogin = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "Backdoor", "SHOW_BACK_DOOR_LOGIN_IND");
        backdoorForm.setShowBackdoorLogin(showBackdoorLogin);
        this.setFormGroupPermission(backdoorForm, request);
        if (backdoorForm.getGraphic() != null) {
            request.getSession().setAttribute("showGraphic", (Object)backdoorForm.getGraphic());
        }
    }

    public static UserSession getUserSession(HttpServletRequest request) {
        return GlobalVariables.getUserSession();
    }

    public boolean isBackdoorAuthorized(UserSession uSession, HttpServletRequest request) {
        boolean isAuthorized = true;
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        String requestAppCode = ConfigContext.getCurrentContextConfig().getProperty("app.code");
        permissionDetails.put("appCode", requestAppCode);
        List perms = KimApiServiceLocator.getPermissionService().findPermissionsByTemplate("KR-SYS", "Backdoor Restriction");
        for (Permission kpi : perms) {
            if (!kpi.getAttributes().values().contains(requestAppCode)) continue;
            isAuthorized = KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(uSession.getActualPerson().getPrincipalId(), "KR-SYS", "Backdoor Restriction", permissionDetails, Collections.emptyMap());
        }
        if (!isAuthorized) {
            LOG.warn("Attempt to backdoor was made by user: " + uSession.getPerson().getPrincipalId() + " into application with app code: " + requestAppCode + " but they do not have appropriate permissions. Backdoor processing aborted.");
        }
        return isAuthorized;
    }
}

