/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.action;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.RequestUtils;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.SessionDocumentService;
import org.kuali.kfs.kns.util.ErrorContainer;
import org.kuali.kfs.kns.util.InfoContainer;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.WarningContainer;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.EditablePropertiesHistoryHolder;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.kns.web.struts.form.pojo.PojoForm;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.CsrfService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorInternal;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.util.LegacyUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springmodules.orm.ojb.OjbOperationException;

public class KualiRequestProcessor
extends RequestProcessor {
    private static final String MDC_DOC_ID = "docId";
    private static final String PREVIOUS_REQUEST_EDITABLE_PROPERTIES_GUID_PARAMETER_NAME = "actionEditablePropertiesGuid";
    private static Logger LOG = LogManager.getLogger(KualiRequestProcessor.class);
    private SessionDocumentService sessionDocumentService;
    private PlatformTransactionManager transactionManager;
    private CsrfService csrfService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LegacyUtils.beginLegacyContext();
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((CharSequence)new StringBuffer("Started processing request: '").append(request.getRequestURI()).append("' w/ query string: '").append(request.getQueryString()).append("'"));
            }
            this.strutsProcess(request, response);
            KNSGlobalVariables.setKualiForm(null);
            try {
                String docId;
                ActionForm form = WebUtils.getKualiForm(request);
                if (form != null && form instanceof KualiDocumentFormBase && (docId = ((KualiDocumentFormBase)form).getDocId()) != null) {
                    ThreadContext.put((String)MDC_DOC_ID, (String)docId);
                }
                String refreshCaller = request.getParameter("refreshCaller");
                if (form != null && KualiDocumentFormBase.class.isAssignableFrom(form.getClass()) && !"QuestionRefresh".equalsIgnoreCase(refreshCaller)) {
                    Boolean exitingDocument;
                    KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
                    Document document = docForm.getDocument();
                    String docFormKey = docForm.getFormKey();
                    UserSession userSession = (UserSession)request.getSession().getAttribute("cf.UserSession");
                    if (WebUtils.isDocumentSession(document, docForm)) {
                        this.getSessionDocumentService().setDocumentForm(docForm, userSession, request.getRemoteAddr());
                    }
                    if ((exitingDocument = (Boolean)request.getAttribute("exitingDocument")) != null && exitingDocument.booleanValue()) {
                        this.getSessionDocumentService().purgeDocumentForm(docForm.getDocument().getDocumentNumber(), docFormKey, userSession, request.getRemoteAddr());
                    }
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((CharSequence)new StringBuffer("Finished processing request: '").append(request.getRequestURI()).append("' w/ query string: '").append(request.getQueryString()).append("'"));
                }
            }
            finally {
                ThreadContext.remove((String)MDC_DOC_ID);
            }
        }
        finally {
            LegacyUtils.endLegacyContext();
        }
    }

    protected boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
        UserSession session = KRADUtils.getUserSessionFromRequest(request);
        if (session == null) {
            throw new IllegalStateException("the user session has not been established");
        }
        GlobalVariables.setUserSession(session);
        KNSGlobalVariables.clear();
        KNSGlobalVariables.setRemoteIpAddress(request.getRemoteAddr());
        return true;
    }

    public void strutsProcess(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = this.processPath(request = this.processMultipart(request), response);
        if (path == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing a '" + request.getMethod() + "' for path '" + path + "'"));
        }
        this.processLocale(request, response);
        this.processContent(request, response);
        this.processNoCache(request, response);
        if (!this.processPreprocess(request, response)) {
            return;
        }
        this.processCachedMessages(request, response);
        ActionMapping mapping = this.processMapping(request, response, path);
        if (mapping == null) {
            return;
        }
        if (!this.processRoles(request, response, mapping)) {
            return;
        }
        this.processFormActionAndForward(request, response, mapping);
    }

    public void processFormActionAndForward(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws ServletException, IOException {
        ActionForward forward;
        ActionForm form = this.processActionForm(request, response, mapping);
        this.processPopulate(request, response, form, mapping);
        LOG.debug("context path = " + request.getRequestURI());
        if (!this.getCsrfService().validateCsrfIfNecessary(request, response)) {
            LOG.error("Did not pass CSRF validation");
            return;
        }
        Action action = this.processActionCreate(request, response, mapping);
        if (action != null && (forward = this.processActionPerform(request, response, action, form, mapping)) != null) {
            if (forward.getRedirect() && forward.getName() != null && forward.getName().equals("InitiatedDocumentView")) {
                LOG.info("Attempt to open a document with a status of \"Initiated\" detected");
                return;
            }
            this.processForwardConfig(request, response, (ForwardConfig)forward);
        }
    }

    private String getDocumentNumber(HttpServletRequest request) {
        String documentNumber = request.getParameter("document.documentNumber");
        if (documentNumber == null) {
            documentNumber = request.getParameter("docNum");
        }
        if (documentNumber == null) {
            documentNumber = request.getParameter("documentId");
        }
        if (documentNumber == null) {
            documentNumber = request.getParameter(MDC_DOC_ID);
        }
        return documentNumber;
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        if (form instanceof KualiForm) {
            KNSGlobalVariables.setKualiForm((KualiForm)form);
        }
        if (!(form instanceof PojoForm)) {
            super.processPopulate(request, response, form, mapping);
            return;
        }
        String previousRequestGuid = request.getParameter(PREVIOUS_REQUEST_EDITABLE_PROPERTIES_GUID_PARAMETER_NAME);
        ((PojoForm)form).clearEditablePropertyInformation();
        ((PojoForm)form).registerStrutsActionMappingScope(mapping.getScope());
        String multipart = mapping.getMultipartClass();
        if (multipart != null) {
            request.setAttribute("org.apache.struts.action.mapping.multipartclass", (Object)multipart);
        }
        form.setServlet(this.servlet);
        form.reset(mapping, request);
        ((PojoForm)form).setPopulateEditablePropertiesGuid(previousRequestGuid);
        ((PojoForm)form).populate(request);
        request.setAttribute("UnconvertedValues", ((PojoForm)form).getUnconvertedValues().keySet());
        request.setAttribute("UnconvertedHash", (Object)((PojoForm)form).getUnconvertedValues());
    }

    protected boolean processValidate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws IOException, ServletException, InvalidCancelException {
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            if (form == null) {
                return true;
            }
            if (request.getAttribute("org.apache.struts.action.CANCEL") != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" Cancelled transaction, skipping validation");
                }
                return true;
            }
            if (!mapping.getValidate()) {
                return true;
            }
            super.processValidate(request, response, form, mapping);
        }
        this.publishMessages(request);
        if (!GlobalVariables.getMessageMap().hasNoErrors()) {
            String input;
            if (form.getMultipartRequestHandler() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Rolling back multipart request");
                }
                form.getMultipartRequestHandler().rollback();
            }
            if (form instanceof PojoForm) {
                ((PojoForm)form).processValidationFail();
            }
            if ((input = mapping.getInput()) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Validation failed but no input form available");
                }
                response.sendError(500, this.getInternal().getMessage("noInput", (Object)mapping.getPath()));
                return false;
            }
            if (this.moduleConfig.getControllerConfig().getInputForward()) {
                ActionForward forward = mapping.findForward(input);
                this.processForwardConfig(request, response, (ForwardConfig)forward);
            } else {
                this.internalModuleRelativeForward(input, request, response);
            }
            return false;
        }
        return true;
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        String method;
        String contentType;
        ActionForm form;
        String documentNumber = this.getDocumentNumber(request);
        if (documentNumber != null) {
            ThreadContext.put((String)MDC_DOC_ID, (String)documentNumber);
        }
        UserSession userSession = (UserSession)request.getSession().getAttribute("cf.UserSession");
        String docFormKey = request.getParameter("docFormKey");
        String methodToCall = request.getParameter("methodToCall");
        String refreshCaller = request.getParameter("refreshCaller");
        String documentWebScope = request.getParameter("documentWebScope");
        if (mapping.getPath().startsWith("/Refresh") || "refresh".equalsIgnoreCase(methodToCall) || "QuestionRefresh".equalsIgnoreCase(refreshCaller) || "TextAreaRefresh".equalsIgnoreCase(refreshCaller) || "session".equalsIgnoreCase(documentWebScope)) {
            form = null;
            GlobalVariables.getUserSession().removeObjectsByPrefix("searchResults");
            if (userSession.retrieveObject(docFormKey) != null) {
                LOG.debug("getDecomentForm KualiDocumentFormBase from session");
                form = (ActionForm)userSession.retrieveObject(docFormKey);
            } else if (StringUtils.isNotBlank((CharSequence)documentNumber)) {
                form = this.getSessionDocumentService().getDocumentForm(documentNumber, docFormKey, userSession, request.getRemoteAddr());
            }
            request.setAttribute(mapping.getAttribute(), (Object)form);
            if (!"session".equalsIgnoreCase(documentWebScope)) {
                userSession.removeObject(docFormKey);
            }
            contentType = request.getContentType();
            method = request.getMethod();
            if ("POST".equalsIgnoreCase(method) && contentType != null && contentType.startsWith("multipart/form-data")) {
                WebUtils.getMultipartParameters(request, null, form, mapping);
            }
            if (form != null) {
                return form;
            }
        }
        form = super.processActionForm(request, response, mapping);
        contentType = request.getContentType();
        method = request.getMethod();
        if ("GET".equalsIgnoreCase(method) && StringUtils.isNotBlank((CharSequence)methodToCall) && form instanceof PojoForm && ((PojoForm)form).getMethodToCallsToBypassSessionRetrievalForGETRequests().contains(methodToCall)) {
            return this.createNewActionForm(mapping, request);
        }
        if ("POST".equalsIgnoreCase(method) && contentType != null && contentType.startsWith("multipart/form-data")) {
            WebUtils.getMultipartParameters(request, null, form, mapping);
            docFormKey = request.getParameter("docFormKey");
            documentWebScope = request.getParameter("documentWebScope");
            documentNumber = this.getDocumentNumber(request);
            if ("session".equalsIgnoreCase(documentWebScope) || form instanceof KualiDocumentFormBase && WebUtils.isDocumentSession(((KualiDocumentFormBase)form).getDocument(), (KualiDocumentFormBase)form)) {
                Object userSessionObject = userSession.retrieveObject(docFormKey);
                if (userSessionObject != null && userSessionObject instanceof ActionForm) {
                    LOG.debug("getDocumentForm KualiDocumentFormBase from session");
                    form = (ActionForm)userSessionObject;
                } else {
                    KualiDocumentFormBase tempForm = this.getSessionDocumentService().getDocumentForm(documentNumber, docFormKey, userSession, request.getRemoteAddr());
                    if (tempForm != null) {
                        form = tempForm;
                    }
                }
                request.setAttribute(mapping.getAttribute(), (Object)form);
                if (form != null) {
                    return form;
                }
            }
        }
        return form;
    }

    protected ActionForward processActionPerform(final HttpServletRequest request, final HttpServletResponse response, final Action action, final ActionForm form, final ActionMapping mapping) throws IOException, ServletException {
        try {
            TransactionTemplate template = new TransactionTemplate(this.getTransactionManager());
            ActionForward forward = null;
            try {
                forward = (ActionForward)template.execute(new TransactionCallback(){

                    public Object doInTransaction(TransactionStatus status) {
                        ActionForward actionForward = null;
                        try {
                            actionForward = action.execute(mapping, form, request, response);
                            if (GlobalVariables.getMessageMap().containsMessageKey("error.document.optimisticLockException")) {
                                status.setRollbackOnly();
                            }
                        }
                        catch (Exception e) {
                            if (e.getMessage() != null && e.getMessage().equals("InitiatedDocumentView")) {
                                ConfigurationService kualiConfigurationService = KRADServiceLocator.getKualiConfigurationService();
                                StringBuffer sb = new StringBuffer();
                                sb.append(kualiConfigurationService.getPropertyValueAsString("krad.url"));
                                sb.append(kualiConfigurationService.getPropertyValueAsString("initiated.document.url"));
                                return new ActionForward("InitiatedDocumentView", sb.toString(), true);
                            }
                            throw new WrappedRuntimeException(e);
                        }
                        if (status.isRollbackOnly()) {
                            throw new WrappedActionForwardRuntimeException(actionForward);
                        }
                        return actionForward;
                    }
                });
            }
            catch (WrappedActionForwardRuntimeException e) {
                forward = e.getActionForward();
            }
            this.publishMessages(request);
            this.saveMessages(request);
            this.saveAuditErrors(request);
            if (form instanceof PojoForm && (((PojoForm)form).getEditableProperties() == null || ((PojoForm)form).getEditableProperties().isEmpty())) {
                EditablePropertiesHistoryHolder holder = (EditablePropertiesHistoryHolder)GlobalVariables.getUserSession().getObjectMap().get("EditablePropertiesHistoryHolder");
                if (holder == null) {
                    holder = new EditablePropertiesHistoryHolder();
                }
                String guid = holder.addEditablePropertiesToHistory(((PojoForm)form).getEditableProperties());
                ((PojoForm)form).setActionEditablePropertiesGuid(guid);
                GlobalVariables.getUserSession().addObject("EditablePropertiesHistoryHolder", holder);
            }
            return forward;
        }
        catch (Exception e) {
            if (e instanceof WrappedRuntimeException) {
                e = (Exception)e.getCause();
            }
            if (e instanceof ValidationException) {
                if (GlobalVariables.getMessageMap().hasNoErrors()) {
                    GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.custom", e.getMessage());
                }
                if (form instanceof PojoForm && (((PojoForm)form).getEditableProperties() == null || ((PojoForm)form).getEditableProperties().isEmpty())) {
                    EditablePropertiesHistoryHolder holder = (EditablePropertiesHistoryHolder)GlobalVariables.getUserSession().getObjectMap().get("EditablePropertiesHistoryHolder");
                    if (holder == null) {
                        holder = new EditablePropertiesHistoryHolder();
                    }
                    String guid = holder.addEditablePropertiesToHistory(((PojoForm)form).getEditableProperties());
                    ((PojoForm)form).setActionEditablePropertiesGuid(guid);
                    GlobalVariables.getUserSession().addObject("EditablePropertiesHistoryHolder", holder);
                }
                this.publishMessages(request);
                return mapping.findForward("basic");
            }
            this.publishMessages(request);
            return this.processException(request, response, e, form, mapping);
        }
    }

    protected ActionForward processException(HttpServletRequest request, HttpServletResponse response, Exception exception, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        ActionForward actionForward = null;
        try {
            actionForward = super.processException(request, response, exception, form, mapping);
        }
        catch (IOException e) {
            this.logException(e);
            throw e;
        }
        catch (ServletException e) {
            OjbOperationException ooe;
            Throwable subcause;
            Throwable rootCause = e.getRootCause();
            if (rootCause instanceof OjbOperationException && (subcause = (ooe = (OjbOperationException)rootCause).getCause()) instanceof OptimisticLockException) {
                OptimisticLockException ole = (OptimisticLockException)subcause;
                StringBuffer message = new StringBuffer(e.getMessage());
                Object sourceObject = ole.getSourceObject();
                if (sourceObject != null) {
                    message.append(" (sourceObject is ");
                    message.append(sourceObject.getClass().getName());
                    message.append(")");
                }
                e = new ServletException(message.toString(), rootCause);
            }
            this.logException((Exception)((Object)e));
            throw e;
        }
        return actionForward;
    }

    private void logException(Exception e) {
        LOG.error("unhandled exception thrown by KualiRequestProcessor.processActionPerform", (Throwable)e);
    }

    private void publishMessages(HttpServletRequest request) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!errorMap.hasNoErrors()) {
            ErrorContainer errorContainer = new ErrorContainer(errorMap);
            request.setAttribute("ErrorContainer", (Object)errorContainer);
            request.setAttribute("org.apache.struts.action.ERROR", (Object)errorContainer.getRequestErrors());
            request.setAttribute("ErrorPropertyList", (Object)errorContainer.getErrorPropertyList());
        }
        if (errorMap.hasWarnings()) {
            WarningContainer warningsContainer = new WarningContainer(errorMap);
            request.setAttribute("WarningContainer", (Object)warningsContainer);
            request.setAttribute("WarningActionMessages", (Object)warningsContainer.getRequestMessages());
            request.setAttribute("WarningPropertyList", warningsContainer.getMessagePropertyList());
        }
        if (errorMap.hasInfo()) {
            InfoContainer infoContainer = new InfoContainer(errorMap);
            request.setAttribute("InfoContainer", (Object)infoContainer);
            request.setAttribute("InfoActionMessages", (Object)infoContainer.getRequestMessages());
            request.setAttribute("InfoPropertyList", infoContainer.getMessagePropertyList());
        }
    }

    private void saveMessages(HttpServletRequest request) {
        if (!KNSGlobalVariables.getMessageList().isEmpty()) {
            request.setAttribute("GlobalMessages", (Object)KNSGlobalVariables.getMessageList().toActionMessages());
        }
    }

    private void saveAuditErrors(HttpServletRequest request) {
        if (!KNSGlobalVariables.getAuditErrorMap().isEmpty()) {
            request.setAttribute("AuditErrors", KNSGlobalVariables.getAuditErrorMap());
        }
    }

    public SessionDocumentService getSessionDocumentService() {
        if (this.sessionDocumentService == null) {
            this.sessionDocumentService = KNSServiceLocator.getSessionDocumentService();
        }
        return this.sessionDocumentService;
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = KRADServiceLocatorInternal.getTransactionManager();
        }
        return this.transactionManager;
    }

    public CsrfService getCsrfService() {
        if (this.csrfService == null) {
            this.csrfService = KRADServiceLocatorWeb.getCsrfService();
        }
        return this.csrfService;
    }

    private ActionForm createNewActionForm(ActionMapping mapping, HttpServletRequest request) {
        String name = mapping.getName();
        FormBeanConfig config = this.moduleConfig.findFormBeanConfig(name);
        if (config == null) {
            log.warn((Object)("No FormBeanConfig found under '" + name + "'"));
            return null;
        }
        ActionForm instance = RequestUtils.createActionForm((FormBeanConfig)config, (ActionServlet)this.servlet);
        if ("request".equals(mapping.getScope())) {
            request.setAttribute(mapping.getAttribute(), (Object)instance);
        } else {
            HttpSession session = request.getSession();
            session.setAttribute(mapping.getAttribute(), (Object)instance);
        }
        return instance;
    }

    private static class WrappedRuntimeException
    extends RuntimeException {
        public WrappedRuntimeException(Exception e) {
            super(e);
        }
    }

    private static class WrappedActionForwardRuntimeException
    extends RuntimeException {
        private final ActionForward actionForward;

        public WrappedActionForwardRuntimeException(ActionForward actionForward) {
            this.actionForward = actionForward;
        }

        public ActionForward getActionForward() {
            return this.actionForward;
        }
    }
}

