/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.kns.datadictionary.HeaderNavigation;
import org.kuali.kfs.kns.datadictionary.KNSDocumentEntry;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.derivedvaluesetter.DerivedValuesSetter;
import org.kuali.kfs.kns.web.struts.form.BlankFormFile;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.UserSessionUtils;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteWorkgroup;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.web.format.NoOpStringFormatter;
import org.kuali.rice.core.web.format.TimestampAMPMFormatter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.util.AutoPopulatingList;

public abstract class KualiDocumentFormBase
extends KualiForm
implements Serializable {
    private static final long serialVersionUID = 916061016201941821L;
    private static final Logger LOG = LogManager.getLogger(KualiDocumentFormBase.class);
    private Document document;
    private String annotation = "";
    private String command;
    private String docId;
    private String docTypeName;
    private List<String> additionalScriptFiles;
    private AdHocRoutePerson newAdHocRoutePerson;
    private AdHocRouteWorkgroup newAdHocRouteWorkgroup;
    private Note newNote;
    private List boNotes;
    protected FormFile attachmentFile = new BlankFormFile();
    protected Map editingMode;
    protected Map documentActions;
    protected boolean suppressAllButtons;
    protected Map adHocActionRequestCodes;
    private boolean returnToActionList;
    private String formKey;
    private String docNum;
    private List<ActionRequest> actionRequests;
    private List<String> selectedActionRequests;
    private String superUserAnnotation;
    private String lastActionTaken;
    private MessageMap errorMapFromPreviousRequest;
    private DocumentType documentType;
    private boolean superuserForDocumentType;
    private String documentStatus;
    private List<RouteNodeInstance> routeNodeInstances;
    private boolean superUserFieldsInitialized;

    public KualiDocumentFormBase() {
        this.instantiateDocument();
        this.newNote = new Note();
        this.editingMode = new HashMap();
        this.additionalScriptFiles = new AutoPopulatingList(String.class);
        this.newAdHocRoutePerson = new AdHocRoutePerson();
        this.newAdHocRouteWorkgroup = new AdHocRouteWorkgroup();
        this.setFormatterType("document.documentHeader.note.finDocNotePostedDttmStamp", TimestampAMPMFormatter.class);
        this.setFormatterType("document.documentHeader.note.attachment.finDocNotePostedDttmStamp", TimestampAMPMFormatter.class);
        this.setFormatterType("document.documentHeader.boNote.notePostedTimestamp", TimestampAMPMFormatter.class);
        this.setFormatterType("document.documentBusinessObject.boNote.notePostedTimestamp", TimestampAMPMFormatter.class);
        this.setFormatterType("editingMode", NoOpStringFormatter.class);
        this.setFormatterType("editableAccounts", NoOpStringFormatter.class);
        this.setDocumentActions(new HashMap());
        this.suppressAllButtons = false;
        this.initializeHeaderNavigationTabs();
    }

    @Override
    public void addRequiredNonEditableProperties() {
        super.addRequiredNonEditableProperties();
        this.registerRequiredNonEditableProperty("docTypeName");
        this.registerRequiredNonEditableProperty("formKey");
        this.registerRequiredNonEditableProperty("newNote.noteTypeCode");
    }

    public String getDocNum() {
        return this.docNum;
    }

    public void setDocNum(String docNum) {
        this.docNum = docNum;
    }

    @Override
    public void populate(HttpServletRequest request) {
        super.populate(request);
        this.clearFieldsForSuperUserChecks();
        WorkflowDocument workflowDocument = null;
        if (this.hasDocumentId()) {
            try {
                workflowDocument = UserSessionUtils.getWorkflowDocument(GlobalVariables.getUserSession(), this.getDocument().getDocumentNumber());
                if (workflowDocument == null) {
                    Person person = GlobalVariables.getUserSession().getPerson();
                    if (ObjectUtils.isNull(person)) {
                        person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("kr");
                    }
                    workflowDocument = KRADServiceLocatorWeb.getWorkflowDocumentService().loadWorkflowDocument(this.getDocument().getDocumentNumber(), person);
                    UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), workflowDocument);
                    if (workflowDocument == null) {
                        throw new WorkflowException("Unable to retrieve workflow document # " + this.getDocument().getDocumentNumber() + " from workflow document service createWorkflowDocument");
                    }
                    LOG.debug("Retrieved workflow Document ID: " + workflowDocument.getDocumentId());
                }
                this.getDocument().getDocumentHeader().setWorkflowDocument(workflowDocument);
            }
            catch (WorkflowException e) {
                LOG.warn("Error while instantiating workflowDoc", (Throwable)e);
                throw new RuntimeException("error populating documentHeader.workflowDocument", e);
            }
        }
        if (workflowDocument != null) {
            this.populateHeaderFields(workflowDocument);
        }
    }

    protected String getPersonInquiryUrlLink(Person user, String linkBody) {
        StringBuffer urlBuffer = new StringBuffer();
        if (user != null && StringUtils.isNotEmpty((CharSequence)linkBody)) {
            ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(Person.class);
            HashMap<String, String[]> parameters = new HashMap<String, String[]>();
            parameters.put("principalId", new String[]{user.getPrincipalId()});
            String inquiryUrl = moduleService.getExternalizableBusinessObjectInquiryUrl(Person.class, parameters);
            if (!StringUtils.equals((CharSequence)"SYSTEM", (CharSequence)user.getEntityTypeCode())) {
                urlBuffer.append("<a href='");
                urlBuffer.append(inquiryUrl);
                urlBuffer.append("' ");
                urlBuffer.append("target='_blank'");
                urlBuffer.append(" ");
                urlBuffer.append("title='Person Inquiry'>");
                urlBuffer.append(linkBody);
                urlBuffer.append("</a>");
            } else {
                urlBuffer.append(linkBody);
            }
        }
        return urlBuffer.toString();
    }

    protected String getDocumentHandlerUrl(String documentId) {
        Properties parameters = new Properties();
        parameters.put("docId", documentId);
        parameters.put("command", "displayDocSearchView");
        return UrlFactory.parameterizeUrl(KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("workflow.url") + "/" + "DocHandler.do", parameters);
    }

    protected String buildHtmlLink(String url, String linkBody) {
        StringBuffer urlBuffer = new StringBuffer();
        if (StringUtils.isNotEmpty((CharSequence)url) && StringUtils.isNotEmpty((CharSequence)linkBody)) {
            urlBuffer.append("<a href='").append(url).append("'>").append(linkBody).append("</a>");
        }
        return urlBuffer.toString();
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        this.getDocInfo().clear();
        this.getDocInfo().addAll(this.getStandardHeaderFields(workflowDocument));
    }

    protected List<HeaderField> getStandardHeaderFields(WorkflowDocument workflowDocument) {
        ArrayList<HeaderField> headerFields = new ArrayList<HeaderField>();
        this.setNumColumns(2);
        HeaderField docTemplateNumber = null;
        if (ObjectUtils.isNotNull(this.getDocument()) && ObjectUtils.isNotNull(this.getDocument().getDocumentHeader()) && StringUtils.isNotBlank((CharSequence)this.getDocument().getDocumentHeader().getDocumentTemplateNumber())) {
            String templateDocumentNumber = this.getDocument().getDocumentHeader().getDocumentTemplateNumber();
            docTemplateNumber = new HeaderField("documentTemplateNumber", "DataDictionary.DocumentHeader.attributes.documentTemplateNumber", templateDocumentNumber, this.buildHtmlLink(this.getDocumentHandlerUrl(templateDocumentNumber), templateDocumentNumber));
        }
        HeaderField docNumber = new HeaderField("DataDictionary.DocumentHeader.attributes.documentNumber", workflowDocument != null ? this.getDocument().getDocumentNumber() : null);
        docNumber.setId("documentNumber");
        HeaderField docStatus = new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.workflowDocumentStatus", workflowDocument != null ? workflowDocument.getStatus().getLabel() : null);
        docStatus.setId("documentStatus");
        String initiatorNetworkId = null;
        Person user = null;
        if (workflowDocument != null) {
            if (this.getInitiator() == null) {
                LOG.warn("User Not Found while attempting to build inquiry link for document header fields");
            } else {
                user = this.getInitiator();
                initiatorNetworkId = this.getInitiator().getPrincipalName();
            }
        }
        String inquiryUrl = this.getPersonInquiryUrlLink(user, workflowDocument != null ? initiatorNetworkId : null);
        HeaderField docInitiator = new HeaderField("documentInitiator", "DataDictionary.AttributeReferenceDummy.attributes.initiatorNetworkId", workflowDocument != null ? initiatorNetworkId : null, workflowDocument != null ? inquiryUrl : null);
        String createDateStr = null;
        if (workflowDocument != null && workflowDocument.getDateCreated() != null) {
            createDateStr = CoreApiServiceLocator.getDateTimeService().toString(workflowDocument.getDateCreated().toDate(), "hh:mm a MM/dd/yyyy");
        }
        HeaderField docCreateDate = new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.createDate", createDateStr);
        docCreateDate.setId("documentCreateDate");
        if (ObjectUtils.isNotNull(docTemplateNumber)) {
            this.setNumColumns(3);
        }
        headerFields.add(docNumber);
        headerFields.add(docStatus);
        if (ObjectUtils.isNotNull(docTemplateNumber)) {
            headerFields.add(docTemplateNumber);
        }
        headerFields.add(docInitiator);
        headerFields.add(docCreateDate);
        if (ObjectUtils.isNotNull(docTemplateNumber)) {
            headerFields.add(HeaderField.EMPTY_FIELD);
        }
        return headerFields;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        this.setAnnotation(StringUtils.stripToNull((String)this.getAnnotation()));
        int diff = StringUtils.defaultString((String)this.getAnnotation()).length() - 2000;
        if (diff > 0) {
            GlobalVariables.getMessageMap().putError("annotation", "error.document.annotation.maxLength.exceeded", Integer.toString(2000), Integer.toString(diff));
        }
        return super.validate(mapping, request);
    }

    public final boolean isFormDocumentInitialized() {
        boolean initialized = false;
        if (this.document != null && this.document.getDocumentHeader() != null) {
            initialized = this.document.getDocumentHeader().hasWorkflowDocument();
        }
        return initialized;
    }

    public Map getEditingMode() {
        return this.editingMode;
    }

    public void setEditingMode(Map editingMode) {
        this.editingMode = editingMode;
    }

    public Map getDocumentActions() {
        return this.documentActions;
    }

    public void setDocumentActions(Map documentActions) {
        this.documentActions = documentActions;
    }

    public void setAdHocActionRequestCodes(Map adHocActionRequestCodes) {
        this.adHocActionRequestCodes = adHocActionRequestCodes;
    }

    public Map getAdHocActionRequestCodes() {
        return this.adHocActionRequestCodes;
    }

    public List<AdHocRoutePerson> getAdHocRoutePersons() {
        return this.document.getAdHocRoutePersons();
    }

    public FormFile getAttachmentFile() {
        return this.attachmentFile;
    }

    public void setAttachmentFile(FormFile attachmentFile) {
        this.attachmentFile = attachmentFile;
    }

    public void setAdHocRoutePersons(List<AdHocRoutePerson> adHocRouteRecipients) {
        this.document.setAdHocRoutePersons(adHocRouteRecipients);
    }

    public List<AdHocRouteWorkgroup> getAdHocRouteWorkgroups() {
        return this.document.getAdHocRouteWorkgroups();
    }

    public void setAdHocRouteWorkgroups(List<AdHocRouteWorkgroup> adHocRouteWorkgroups) {
        this.document.setAdHocRouteWorkgroups(adHocRouteWorkgroups);
    }

    public AdHocRoutePerson getAdHocRoutePerson(int index) {
        while (this.getAdHocRoutePersons().size() <= index) {
            this.getAdHocRoutePersons().add(new AdHocRoutePerson());
        }
        return this.getAdHocRoutePersons().get(index);
    }

    public AdHocRouteWorkgroup getAdHocRouteWorkgroup(int index) {
        while (this.getAdHocRouteWorkgroups().size() <= index) {
            this.getAdHocRouteWorkgroups().add(new AdHocRouteWorkgroup());
        }
        return this.getAdHocRouteWorkgroups().get(index);
    }

    public AdHocRoutePerson getNewAdHocRoutePerson() {
        return this.newAdHocRoutePerson;
    }

    public void setNewAdHocRoutePerson(AdHocRoutePerson newAdHocRoutePerson) {
        this.newAdHocRoutePerson = newAdHocRoutePerson;
    }

    public AdHocRouteWorkgroup getNewAdHocRouteWorkgroup() {
        return this.newAdHocRouteWorkgroup;
    }

    public void setNewAdHocRouteWorkgroup(AdHocRouteWorkgroup newAdHocRouteWorkgroup) {
        this.newAdHocRouteWorkgroup = newAdHocRouteWorkgroup;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
        if (document != null && StringUtils.isNotEmpty((CharSequence)document.getDocumentNumber())) {
            this.populateHeaderFields(document.getDocumentHeader().getWorkflowDocument());
        }
    }

    public WorkflowDocument getWorkflowDocument() {
        return this.getDocument().getDocumentHeader().getWorkflowDocument();
    }

    public boolean isHasWorkflowDocument() {
        if (this.getDocument() == null || this.getDocument().getDocumentHeader() == null) {
            return false;
        }
        return this.getDocument().getDocumentHeader().hasWorkflowDocument();
    }

    public boolean isUserDocumentInitiator() {
        if (this.getWorkflowDocument() != null) {
            return this.getWorkflowDocument().getInitiatorPrincipalId().equalsIgnoreCase(GlobalVariables.getUserSession().getPrincipalId());
        }
        return false;
    }

    public Person getInitiator() {
        String initiatorPrincipalId = this.getWorkflowDocument().getInitiatorPrincipalId();
        return KimApiServiceLocator.getPersonService().getPerson(initiatorPrincipalId);
    }

    public boolean isDocumentEnRoute() {
        return this.getWorkflowDocument().isEnroute();
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    public void setDocTypeName(String docTypeName) {
        this.docTypeName = docTypeName;
    }

    public String getInitiatorNetworkId() {
        return this.getWorkflowDocument().getInitiatorPrincipalId();
    }

    public final boolean isSuppressAllButtons() {
        return this.suppressAllButtons;
    }

    public final void setSuppressAllButtons(boolean suppressAllButtons) {
        this.suppressAllButtons = suppressAllButtons;
    }

    public boolean hasDocumentId() {
        boolean hasDocId = false;
        Document d = this.getDocument();
        if (d != null) {
            String docHeaderId = d.getDocumentNumber();
            hasDocId = StringUtils.isNotBlank((CharSequence)docHeaderId);
        }
        return hasDocId;
    }

    public void setReturnToActionList(boolean returnToActionList) {
        this.returnToActionList = returnToActionList;
    }

    public boolean isReturnToActionList() {
        return this.returnToActionList;
    }

    public List<String> getAdditionalScriptFiles() {
        return this.additionalScriptFiles;
    }

    public void setAdditionalScriptFiles(List<String> additionalScriptFiles) {
        this.additionalScriptFiles = additionalScriptFiles;
    }

    public void setAdditionalScriptFile(int index, String scriptFile) {
        this.additionalScriptFiles.set(index, scriptFile);
    }

    public String getAdditionalScriptFile(int index) {
        return this.additionalScriptFiles.get(index);
    }

    public Note getNewNote() {
        return this.newNote;
    }

    public void setNewNote(Note newNote) {
        this.newNote = newNote;
    }

    public List getBoNotes() {
        return this.boNotes;
    }

    public void setBoNotes(List boNotes) {
        this.boNotes = boNotes;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.setMethodToCall(null);
        this.setRefreshCaller(null);
        this.setAnchor(null);
        this.setCurrentTabIndex(0);
        this.setSelectedActionRequests(new ArrayList<String>());
    }

    @Override
    protected void customInitMaxUploadSizes() {
        super.customInitMaxUploadSizes();
        String attachmentSize = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-NS", "Document", "MAX_FILE_SIZE_ATTACHMENT");
        if (StringUtils.isNotBlank((CharSequence)attachmentSize)) {
            this.addMaxUploadSize(attachmentSize);
        }
    }

    @Override
    public boolean shouldPropertyBePopulatedInForm(String requestParameterName, HttpServletRequest request) {
        for (String prefix : KRADConstants.ALWAYS_VALID_PARAMETER_PREFIXES) {
            if (!requestParameterName.startsWith(prefix)) continue;
            return true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getMethodToCall(), (CharSequence)"docHandler")) {
            return true;
        }
        if (WebUtils.isDocumentSession(this.getDocument(), this)) {
            return this.isPropertyEditable(requestParameterName) || this.isPropertyNonEditableButRequired(requestParameterName);
        }
        return true;
    }

    @Override
    public boolean shouldMethodToCallParameterBeUsed(String methodToCallParameterName, String methodToCallParameterValue, HttpServletRequest request) {
        if (StringUtils.equals((CharSequence)methodToCallParameterName, (CharSequence)"methodToCall") && StringUtils.equals((CharSequence)methodToCallParameterValue, (CharSequence)"docHandler")) {
            return true;
        }
        return super.shouldMethodToCallParameterBeUsed(methodToCallParameterName, methodToCallParameterValue, request);
    }

    public MessageMap getMessageMapFromPreviousRequest() {
        return this.errorMapFromPreviousRequest;
    }

    public void setMessageMapFromPreviousRequest(MessageMap errorMapFromPreviousRequest) {
        this.errorMapFromPreviousRequest = errorMapFromPreviousRequest;
    }

    @Override
    public void setDerivedValuesOnForm(HttpServletRequest request) {
        super.setDerivedValuesOnForm(request);
        String docTypeName = this.getDocTypeName();
        if (StringUtils.isNotBlank((CharSequence)docTypeName)) {
            DataDictionary dataDictionary = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary();
            Class<? extends DerivedValuesSetter> derivedValuesSetterClass = null;
            KNSDocumentEntry documentEntry = (KNSDocumentEntry)((Object)dataDictionary.getDocumentEntry(docTypeName));
            derivedValuesSetterClass = documentEntry.getDerivedValuesSetterClass();
            if (derivedValuesSetterClass != null) {
                DerivedValuesSetter derivedValuesSetter = null;
                try {
                    derivedValuesSetter = derivedValuesSetterClass.newInstance();
                }
                catch (Exception e) {
                    LOG.error("Unable to instantiate class " + derivedValuesSetterClass.getName(), (Throwable)e);
                    throw new RuntimeException("Unable to instantiate class " + derivedValuesSetterClass.getName(), e);
                }
                derivedValuesSetter.setDerivedValues(this, request);
            }
        }
    }

    protected String getDefaultDocumentTypeName() {
        return "";
    }

    protected void instantiateDocument() {
        if (this.document == null && StringUtils.isNotBlank((CharSequence)this.getDefaultDocumentTypeName())) {
            Class<? extends Document> documentClass = this.getDocumentClass();
            try {
                Document document = documentClass.newInstance();
                this.setDocument(document);
            }
            catch (Exception e) {
                LOG.error("Unable to instantiate document class " + documentClass.getName() + " document type " + this.getDefaultDocumentTypeName());
                throw new RuntimeException(e);
            }
        }
    }

    private Class<? extends Document> getDocumentClass() {
        return KRADServiceLocatorWeb.getDataDictionaryService().getDocumentClassByTypeName(this.getDefaultDocumentTypeName());
    }

    protected void initializeHeaderNavigationTabs() {
        if (StringUtils.isNotBlank((CharSequence)this.getDefaultDocumentTypeName())) {
            KNSDocumentEntry docEntry = (KNSDocumentEntry)((Object)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(this.getDocumentClass().getName()));
            List<HeaderNavigation> navList = docEntry.getHeaderNavigationList();
            HeaderNavigation[] list = new HeaderNavigation[navList.size()];
            super.setHeaderNavigationTabs(navList.toArray(list));
        }
    }

    public List<ActionRequest> getActionRequests() {
        return this.actionRequests;
    }

    public void setActionRequests(List<ActionRequest> actionRequests) {
        this.actionRequests = actionRequests;
    }

    public List<String> getSelectedActionRequests() {
        return this.selectedActionRequests;
    }

    public void setSelectedActionRequests(List<String> selectedActionRequests) {
        this.selectedActionRequests = selectedActionRequests;
    }

    public List<ActionRequest> getActionRequestsRequiringApproval() {
        List<ActionRequest> actionRequests = this.getActionRequests();
        ArrayList<ActionRequest> actionRequestsApprove = new ArrayList<ActionRequest>();
        for (ActionRequest actionRequest : actionRequests) {
            if (!StringUtils.equals((CharSequence)actionRequest.getActionRequested().getCode(), (CharSequence)ActionRequestType.APPROVE.getCode()) && !StringUtils.equals((CharSequence)actionRequest.getActionRequested().getCode(), (CharSequence)ActionRequestType.COMPLETE.getCode())) continue;
            actionRequestsApprove.add(actionRequest);
        }
        return actionRequestsApprove;
    }

    public String getSuperUserAnnotation() {
        return this.superUserAnnotation;
    }

    public void setSuperUserAnnotation(String superUserAnnotation) {
        this.superUserAnnotation = superUserAnnotation;
    }

    public boolean isSuperUserActionAvaliable() {
        List<ActionRequest> actionRequests = this.getActionRequestsRequiringApproval();
        boolean hasSingleActionToTake = false;
        boolean canSuperUserApprove = false;
        boolean canSuperUserDisapprove = false;
        boolean bl = hasSingleActionToTake = this.isSuperUserApproveSingleActionRequestAuthorized() && this.isStateAllowsApproveSingleActionRequest() && !actionRequests.isEmpty();
        if (!hasSingleActionToTake) {
            boolean bl2 = canSuperUserApprove = this.isSuperUserApproveDocumentAuthorized() && this.isStateAllowsApproveOrDisapprove();
        }
        if (!canSuperUserApprove) {
            canSuperUserDisapprove = this.isSuperUserDisapproveDocumentAuthorized() && this.isStateAllowsApproveOrDisapprove();
        }
        return hasSingleActionToTake || canSuperUserApprove || canSuperUserDisapprove;
    }

    private void initializeFieldsForSuperUserChecks() {
        if (!this.superUserFieldsInitialized) {
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            String docId = this.getDocId();
            this.documentType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(this.docTypeName);
            String docTypeId = null;
            if (this.documentType != null) {
                docTypeId = null;
                docTypeId = this.documentType.getId();
            }
            this.routeNodeInstances = KewApiServiceLocator.getWorkflowDocumentService().getCurrentRouteNodeInstances(docId);
            this.documentStatus = this.getDocument().getDocumentHeader().getWorkflowDocument().getStatus().getCode();
            this.superuserForDocumentType = KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, docTypeId);
            this.superUserFieldsInitialized = true;
        }
    }

    private void clearFieldsForSuperUserChecks() {
        this.documentType = null;
        this.routeNodeInstances = null;
        this.documentStatus = null;
        this.superuserForDocumentType = false;
        this.superUserFieldsInitialized = false;
    }

    public boolean isSuperUserApproveSingleActionRequestAuthorized() {
        this.initializeFieldsForSuperUserChecks();
        if (this.superuserForDocumentType) {
            return true;
        }
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveSingleActionRequest(principalId, this.getDocTypeName(), this.routeNodeInstances, this.documentStatus);
    }

    public boolean isSuperUserApproveDocumentAuthorized() {
        this.initializeFieldsForSuperUserChecks();
        if (this.superuserForDocumentType) {
            return true;
        }
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveDocument(principalId, this.getDocTypeName(), this.routeNodeInstances, this.documentStatus);
    }

    public boolean isSuperUserDisapproveDocumentAuthorized() {
        this.initializeFieldsForSuperUserChecks();
        if (this.superuserForDocumentType) {
            return true;
        }
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserDisapproveDocument(principalId, this.getDocTypeName(), this.routeNodeInstances, this.documentStatus);
    }

    public boolean isSuperUserAuthorized() {
        this.initializeFieldsForSuperUserChecks();
        if (this.superuserForDocumentType) {
            return true;
        }
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveSingleActionRequest(principalId, this.getDocTypeName(), this.routeNodeInstances, this.documentStatus) || KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveDocument(principalId, this.getDocTypeName(), this.routeNodeInstances, this.documentStatus) || KewApiServiceLocator.getDocumentTypeService().canSuperUserDisapproveDocument(principalId, this.getDocTypeName(), this.routeNodeInstances, this.documentStatus);
    }

    public boolean isStateAllowsApproveOrDisapprove() {
        if (this.getDocument().getDocumentHeader().hasWorkflowDocument()) {
            DocumentStatus status = this.getDocument().getDocumentHeader().getWorkflowDocument().getStatus();
            return !this.isStateProcessedOrDisapproved(status) && !this.isStateInitiatedFinalCancelled(status) && !StringUtils.equals((CharSequence)status.getCode(), (CharSequence)DocumentStatus.SAVED.getCode());
        }
        return false;
    }

    public boolean isStateAllowsApproveSingleActionRequest() {
        if (this.getDocument().getDocumentHeader().hasWorkflowDocument()) {
            DocumentStatus status = this.getDocument().getDocumentHeader().getWorkflowDocument().getStatus();
            return !this.isStateInitiatedFinalCancelled(status);
        }
        return false;
    }

    public boolean isStateProcessedOrDisapproved(DocumentStatus status) {
        return StringUtils.equals((CharSequence)status.getCode(), (CharSequence)DocumentStatus.PROCESSED.getCode()) || StringUtils.equals((CharSequence)status.getCode(), (CharSequence)DocumentStatus.DISAPPROVED.getCode());
    }

    public boolean isStateInitiatedFinalCancelled(DocumentStatus status) {
        return StringUtils.equals((CharSequence)status.getCode(), (CharSequence)DocumentStatus.INITIATED.getCode()) || StringUtils.equals((CharSequence)status.getCode(), (CharSequence)DocumentStatus.FINAL.getCode()) || StringUtils.equals((CharSequence)status.getCode(), (CharSequence)DocumentStatus.CANCELED.getCode());
    }

    public String getLastActionTaken() {
        return this.lastActionTaken;
    }

    public void setLastActionTaken(String lastActionTaken) {
        this.lastActionTaken = lastActionTaken;
    }
}

