/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.app.persistence.jpa;

import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.app.persistence.jpa.KRADPersistableBusinessObjectClassExposer;
import org.kuali.kfs.krad.app.persistence.jpa.PersistableBusinessObjectClassExposer;
import org.kuali.kfs.krad.app.persistence.jpa.RiceToNervousSystemBusinessObjectClassExposer;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;

public class RicePersistenceUnitPostProcessor
implements PersistenceUnitPostProcessor {
    private static final Logger LOG = LogManager.getLogger(RicePersistenceUnitPostProcessor.class);
    public static final String KRAD_APPLICATION_PERSISTENCE_UNIT_NAME = "krad-application-unit";
    public static final String KRAD_SERVER_PERSISTENCE_UNIT_NAME = "krad-server-unit";
    private DataSource jtaDataSource;

    public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo mutablePersistenceUnitInfo) {
        mutablePersistenceUnitInfo.setJtaDataSource(this.getJtaDataSource());
        this.addKRADManagedClassNames(mutablePersistenceUnitInfo);
        if (mutablePersistenceUnitInfo.getPersistenceUnitName().equals(KRAD_APPLICATION_PERSISTENCE_UNIT_NAME) || mutablePersistenceUnitInfo.getPersistenceUnitName().equals(KRAD_SERVER_PERSISTENCE_UNIT_NAME)) {
            this.addRiceManagedClassNamesToKRADPersistenceUnit(mutablePersistenceUnitInfo);
        }
    }

    public void addKRADManagedClassNames(MutablePersistenceUnitInfo mutablePersistenceUnitInfo) {
        this.addManagedClassNames(mutablePersistenceUnitInfo, new KRADPersistableBusinessObjectClassExposer());
    }

    public void addManagedClassNames(MutablePersistenceUnitInfo mutablePersistenceUnitInfo, PersistableBusinessObjectClassExposer exposer) {
        for (String exposedClassName : exposer.exposePersistableBusinessObjectClassNames()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JPA will now be managing class: " + exposedClassName);
            }
            mutablePersistenceUnitInfo.addManagedClassName(exposedClassName);
        }
    }

    public void addRiceManagedClassNamesToKRADPersistenceUnit(MutablePersistenceUnitInfo mutablePersistenceUnitInfo) {
        this.addManagedClassNames(mutablePersistenceUnitInfo, new RiceToNervousSystemBusinessObjectClassExposer());
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }
}

