/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.util.Comparator;
import org.kuali.kfs.krad.comparator.BooleanValueComparator;
import org.kuali.kfs.krad.comparator.DateValueComparator;
import org.kuali.kfs.krad.comparator.NumericValueComparator;
import org.kuali.kfs.krad.comparator.StringValueComparator;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;

public class LookupResultAttributeDefinition
extends AttributeDefinition {
    private Comparator comparator;
    private boolean disableInquiry = false;

    public Comparator getComparator() {
        if (this.comparator != null) {
            return this.comparator;
        }
        return this.estimateComparator();
    }

    private Comparator estimateComparator() {
        AttributeDefinition.Type type = this.getType();
        switch (type) {
            case BOOLEAN: {
                return BooleanValueComparator.getInstance();
            }
            case CURRENCY: 
            case DECIMAL: 
            case INTEGER: 
            case LONG: {
                return new NumericValueComparator();
            }
            case DATE_RANGE: 
            case DATE_TIME: {
                return DateValueComparator.getInstance();
            }
        }
        return StringValueComparator.getInstance();
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public boolean isDisableInquiry() {
        return this.disableInquiry;
    }

    public void setDisableInquiry(boolean disableInquiry) {
        this.disableInquiry = disableInquiry;
    }
}

