/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.document;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentPresentationController;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.rice.kew.api.WorkflowDocument;

public class DocumentPresentationControllerBase
implements DocumentPresentationController,
Serializable {
    private static final long serialVersionUID = -9181864754090276024L;
    private static transient ParameterService parameterService;

    @Override
    public boolean canInitiate(String documentTypeName) {
        return true;
    }

    @Override
    public boolean canEdit(Document document) {
        boolean canEdit = false;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isInitiated() || workflowDocument.isSaved() || workflowDocument.isEnroute() || workflowDocument.isException()) {
            canEdit = true;
        }
        return canEdit;
    }

    @Override
    public boolean canAnnotate(Document document) {
        return this.canEdit(document);
    }

    @Override
    public boolean canReload(Document document) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return this.canEdit(document) && !workflowDocument.isInitiated();
    }

    @Override
    public boolean canClose(Document document) {
        return true;
    }

    @Override
    public boolean canSave(Document document) {
        return this.canEdit(document);
    }

    @Override
    public boolean canRoute(Document document) {
        boolean canRoute = false;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isInitiated() || workflowDocument.isSaved()) {
            canRoute = true;
        }
        return canRoute;
    }

    @Override
    public boolean canCancel(Document document) {
        return this.canEdit(document);
    }

    @Override
    public boolean canRecall(Document document) {
        return document.getDocumentHeader().getWorkflowDocument().isEnroute();
    }

    @Override
    public boolean canCopy(Document document) {
        boolean canCopy = false;
        if (document.getAllowsCopy()) {
            canCopy = true;
        }
        return canCopy;
    }

    @Override
    public boolean canPerformRouteReport(Document document) {
        return this.getParameterService().getParameterValueAsBoolean("KR-NS", "Document", "DEFAULT_CAN_PERFORM_ROUTE_REPORT_IND");
    }

    @Override
    public boolean canAddAdhocRequests(Document document) {
        return true;
    }

    @Override
    public boolean canBlanketApprove(Document document) {
        Boolean allowBlanketApproveNoRequest = this.getParameterService().getParameterValueAsBoolean("KR-NS", "Document", "ALLOW_ENROUTE_BLANKET_APPROVE_WITHOUT_APPROVAL_REQUEST_IND");
        if (allowBlanketApproveNoRequest != null && allowBlanketApproveNoRequest.booleanValue()) {
            return this.canEdit(document);
        }
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (this.canRoute(document) && StringUtils.equals((CharSequence)workflowDocument.getInitiatorPrincipalId(), (CharSequence)GlobalVariables.getUserSession().getPrincipalId())) {
            return true;
        }
        return workflowDocument.isApprovalRequested();
    }

    @Override
    public boolean canApprove(Document document) {
        return !this.canComplete(document);
    }

    @Override
    public boolean canDisapprove(Document document) {
        return this.canApprove(document);
    }

    @Override
    public boolean canSendAdhocRequests(Document document) {
        WorkflowDocument kualiWorkflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return !kualiWorkflowDocument.isInitiated() && !kualiWorkflowDocument.isSaved();
    }

    @Override
    public boolean canSendNoteFyi(Document document) {
        return true;
    }

    @Override
    public boolean canEditDocumentOverview(Document document) {
        WorkflowDocument kualiWorkflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return kualiWorkflowDocument.isInitiated() || kualiWorkflowDocument.isSaved();
    }

    @Override
    public boolean canFyi(Document document) {
        return true;
    }

    @Override
    public boolean canAcknowledge(Document document) {
        return true;
    }

    @Override
    public boolean canComplete(Document document) {
        boolean docInInit = document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved();
        boolean completionRequested = document.getDocumentHeader().getWorkflowDocument().isCompletionRequested();
        return completionRequested && !docInInit;
    }

    protected ParameterService getParameterService() {
        if (parameterService == null) {
            parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return parameterService;
    }
}

