/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.document.authorization.FieldRestriction;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.datadictionary.LookupResultAttributeDefinition;
import org.kuali.rice.kim.api.identity.Person;

public abstract class LookupSearchService {
    protected static String KRAD_URL_PREFIX = "kr/";
    private static final Log LOG = LogFactory.getLog(LookupSearchService.class);
    private BusinessObjectAuthorizationService businessObjectAuthorizationService;
    private BusinessObjectDictionaryService businessObjectDictionaryService;

    public abstract List<BusinessObjectBase> getSearchResults(Class<? extends BusinessObjectBase> var1, MultivaluedMap<String, String> var2);

    public abstract List<Map<String, Object>> getActionLinks(BusinessObjectBase var1, Person var2);

    public List<LookupResultAttributeDefinition> getSearchResultsAttributes(Class classForType) {
        return this.getLookupResultAttributeDefinitionsForClass(classForType);
    }

    public boolean shouldMaskSomeValues(List<BusinessObjectBase> businessObjects, Person user) {
        BusinessObjectBase businessObject = businessObjects.get(0);
        BusinessObjectRestrictions businessObjectRestrictions = this.businessObjectAuthorizationService.getLookupResultRestrictions(businessObject, user);
        if (businessObjectRestrictions == null) {
            return false;
        }
        return this.getSearchResultsAttributes(businessObject.getClass()).stream().map(resultsAttribute -> businessObjectRestrictions.getFieldRestriction(resultsAttribute.getName())).anyMatch(FieldRestriction::hasAnyMasking);
    }

    public Map<String, Object> maskFieldsAppropriately(List<BusinessObjectBase> businessObjects, Map<String, Object> serializedBusinessObject, Person user) {
        BusinessObjectRestrictions businessObjectRestrictions = this.businessObjectAuthorizationService.getLookupResultRestrictions(businessObjects.get(0), user);
        if (businessObjectRestrictions == null) {
            return serializedBusinessObject;
        }
        for (String attribute : serializedBusinessObject.keySet()) {
            FieldRestriction fieldRestriction = businessObjectRestrictions.getFieldRestriction(attribute);
            if (!fieldRestriction.hasAnyMasking()) continue;
            if (serializedBusinessObject.get(attribute) instanceof Map) {
                Map serializedValue = (Map)serializedBusinessObject.get(attribute);
                String maskedValue = fieldRestriction.getMaskFormatter().maskValue(serializedValue.get("value"));
                serializedValue.put("value", maskedValue);
                continue;
            }
            String maskedValue = fieldRestriction.getMaskFormatter().maskValue(serializedBusinessObject.get(attribute));
            serializedBusinessObject.put(attribute, maskedValue);
        }
        return serializedBusinessObject;
    }

    public boolean hasInquiry(BusinessObjectBase businessObject, LookupResultAttributeDefinition resultAttributeDefinition) {
        String url = this.inquiryUrl(businessObject, resultAttributeDefinition.getName());
        url = url.replace(KRAD_URL_PREFIX, "");
        return !resultAttributeDefinition.isDisableInquiry() && !StringUtils.isEmpty((CharSequence)url);
    }

    public String inquiryUrl(BusinessObjectBase businessObject, String propertyName) {
        Inquirable inquirable;
        Class<?> businessObjectClass = businessObject.getClass();
        Class inquirableClass = this.businessObjectDictionaryService.getInquirableClass(businessObjectClass);
        if (inquirableClass != null) {
            try {
                inquirable = (Inquirable)inquirableClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                LOG.warn((Object)("Could not instantiate inquirable for class" + inquirableClass.getSimpleName()));
                return "";
            }
        } else {
            inquirable = KNSServiceLocator.getKualiInquirable();
        }
        Boolean forceLookupResultFieldInquiry = this.businessObjectDictionaryService.forceLookupResultFieldInquiry(businessObjectClass, propertyName);
        forceLookupResultFieldInquiry = Boolean.TRUE.equals(forceLookupResultFieldInquiry);
        HtmlData.AnchorHtmlData inquiryData = (HtmlData.AnchorHtmlData)inquirable.getInquiryUrl(businessObject, propertyName, forceLookupResultFieldInquiry);
        return KRAD_URL_PREFIX + inquiryData.getHref();
    }

    protected List<LookupResultAttributeDefinition> getLookupResultAttributeDefinitionsForClass(Class classForType) {
        return this.businessObjectDictionaryService.getLookupResultAttributeDefinitions(classForType);
    }

    public BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        return this.businessObjectAuthorizationService;
    }

    public void setBusinessObjectAuthorizationService(BusinessObjectAuthorizationService businessObjectAuthorizationService) {
        this.businessObjectAuthorizationService = businessObjectAuthorizationService;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        return this.businessObjectDictionaryService;
    }
}

