/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.dao.AttachmentDao;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AttachmentServiceImpl
implements AttachmentService {
    private static final int MAX_DIR_LEVELS = 6;
    private static Logger LOG = LogManager.getLogger(AttachmentServiceImpl.class);
    private ConfigurationService kualiConfigurationService;
    private AttachmentDao attachmentDao;

    @Override
    public Attachment getAttachmentByNoteId(Long noteId) {
        return this.attachmentDao.getAttachmentByNoteId(noteId);
    }

    @Override
    public Attachment createAttachment(GloballyUnique parent, String uploadedFileName, String mimeType, int fileSize, InputStream fileContents, String attachmentTypeCode) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting to create attachment for document: " + parent.getObjectId());
        }
        if (parent == null) {
            throw new IllegalArgumentException("invalid (null or uninitialized) document");
        }
        if (StringUtils.isBlank((CharSequence)uploadedFileName)) {
            throw new IllegalArgumentException("invalid (blank) fileName");
        }
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            throw new IllegalArgumentException("invalid (blank) mimeType");
        }
        if (fileSize <= 0) {
            throw new IllegalArgumentException("invalid (non-positive) fileSize");
        }
        if (fileContents == null) {
            throw new IllegalArgumentException("invalid (null) inputStream");
        }
        String uniqueFileNameGuid = UUID.randomUUID().toString();
        String fullPathUniqueFileName = this.getDocumentDirectory(parent.getObjectId()) + File.separator + uniqueFileNameGuid;
        this.writeInputStreamToFileStorage(fileContents, fullPathUniqueFileName);
        Attachment attachment = new Attachment();
        attachment.setAttachmentIdentifier(uniqueFileNameGuid);
        attachment.setAttachmentFileName(uploadedFileName);
        attachment.setAttachmentFileSize(new Long(fileSize));
        attachment.setAttachmentMimeTypeCode(mimeType);
        attachment.setAttachmentTypeCode(attachmentTypeCode);
        LOG.debug("finished creating attachment for document: " + parent.getObjectId());
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInputStreamToFileStorage(InputStream fileContents, String fullPathUniqueFileName) throws IOException {
        File fileOut = new File(fullPathUniqueFileName);
        FileOutputStream streamOut = null;
        FilterOutputStream bufferedStreamOut = null;
        try {
            int c;
            streamOut = new FileOutputStream(fileOut);
            bufferedStreamOut = new BufferedOutputStream(streamOut);
            while ((c = fileContents.read()) != -1) {
                ((BufferedOutputStream)bufferedStreamOut).write(c);
            }
        }
        finally {
            bufferedStreamOut.close();
            streamOut.close();
        }
    }

    @Override
    public void moveAttachmentWherePending(Note note) {
        if (note == null) {
            throw new IllegalArgumentException("Note must be non-null");
        }
        if (StringUtils.isBlank((CharSequence)note.getObjectId())) {
            throw new IllegalArgumentException("Note does not have a valid object id, object id was null or empty");
        }
        Attachment attachment = note.getAttachment();
        if (attachment != null) {
            try {
                this.moveAttachmentFromPending(attachment, note.getRemoteObjectIdentifier());
            }
            catch (IOException e) {
                throw new RuntimeException("Problem moving pending attachment to final directory");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveAttachmentFromPending(Attachment attachment, String objectId) throws IOException {
        String fullPendingFileName = this.getPendingDirectory() + File.separator + attachment.getAttachmentIdentifier();
        File pendingFile = new File(fullPendingFileName);
        if (pendingFile.exists()) {
            BufferedInputStream bufferedStream = null;
            FileInputStream oldFileStream = null;
            String fullPathNewFile = this.getDocumentDirectory(objectId) + File.separator + attachment.getAttachmentIdentifier();
            try {
                oldFileStream = new FileInputStream(pendingFile);
                bufferedStream = new BufferedInputStream(oldFileStream);
                this.writeInputStreamToFileStorage(bufferedStream, fullPathNewFile);
            }
            finally {
                bufferedStream.close();
                oldFileStream.close();
                pendingFile.delete();
            }
        }
    }

    @Override
    public void deleteAttachmentContents(Attachment attachment) {
        if (attachment.getNote() == null) {
            throw new RuntimeException("Attachment.note must be set in order to delete the attachment");
        }
        String fullPathUniqueFileName = this.getDocumentDirectory(attachment.getNote().getRemoteObjectIdentifier()) + File.separator + attachment.getAttachmentIdentifier();
        File attachmentFile = new File(fullPathUniqueFileName);
        attachmentFile.delete();
    }

    private String getPendingDirectory() {
        return this.getDocumentDirectory("");
    }

    protected String getDocumentDirectory(String objectId) {
        boolean success;
        File documentDirectory = new File(this.getDocumentFileStorageLocation(objectId));
        if (!documentDirectory.exists() && !(success = documentDirectory.mkdirs())) {
            throw new RuntimeException("Could not generate directory for File at: " + documentDirectory.getAbsolutePath());
        }
        return documentDirectory.getAbsolutePath();
    }

    @Override
    public InputStream retrieveAttachmentContents(Attachment attachment) throws IOException {
        if (attachment.getNoteIdentifier() != null) {
            attachment.refreshNonUpdateableReferences();
        }
        String parentDirectory = "";
        if (attachment.getNote() != null && attachment.getNote().getRemoteObjectIdentifier() != null) {
            parentDirectory = attachment.getNote().getRemoteObjectIdentifier();
        }
        return new BufferedInputStream(new FileInputStream(this.getDocumentDirectory(parentDirectory) + File.separator + attachment.getAttachmentIdentifier()));
    }

    private String getDocumentFileStorageLocation(String objectId) {
        String location = null;
        if (StringUtils.isEmpty((CharSequence)objectId)) {
            location = this.kualiConfigurationService.getPropertyValueAsString("attachments.pending.directory");
        } else {
            char[] chars = objectId.toUpperCase().replace(" ", "").toCharArray();
            int count = chars.length < 6 ? chars.length : 6;
            StringBuffer prefix = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                prefix.append(File.separator + chars[i]);
            }
            location = this.kualiConfigurationService.getPropertyValueAsString("attachments.directory") + prefix + File.separator + objectId;
        }
        return location;
    }

    @Override
    public void deletePendingAttachmentsModifiedBefore(long modificationTime) {
        File[] files;
        String pendingAttachmentDirName = this.getPendingDirectory();
        if (StringUtils.isBlank((CharSequence)pendingAttachmentDirName)) {
            throw new RuntimeException("Blank pending attachment directory name");
        }
        File pendingAttachmentDir = new File(pendingAttachmentDirName);
        if (!pendingAttachmentDir.exists()) {
            throw new RuntimeException("Pending attachment directory does not exist");
        }
        if (!pendingAttachmentDir.isDirectory()) {
            throw new RuntimeException("Pending attachment directory is not a directory! " + pendingAttachmentDir.getAbsolutePath());
        }
        for (File file : files = pendingAttachmentDir.listFiles()) {
            if (file.getName().equals("placeholder.txt") || file.lastModified() >= modificationTime) continue;
            file.delete();
        }
    }

    public void setAttachmentDao(AttachmentDao d) {
        this.attachmentDao = d;
    }

    public AttachmentDao getAttachmentDao() {
        return this.attachmentDao;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setKualiConfigurationService(ConfigurationService configService) {
        this.kualiConfigurationService = configService;
    }
}

