/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.exception.ExceptionIncident;
import org.kuali.kfs.krad.exception.KualiExceptionIncident;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KualiExceptionIncidentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.mail.Mailer;
import org.kuali.rice.kim.api.identity.Person;

public class KualiExceptionIncidentServiceImpl
implements KualiExceptionIncidentService {
    private Logger LOG = LogManager.getLogger(KualiExceptionIncidentServiceImpl.class);
    public static final String REPORT_MAIL_LIST = String.format("%s.REPORT_MAIL_LIST", KualiExceptionIncidentServiceImpl.class.getSimpleName());
    private Mailer mailer;
    private MailMessage messageTemplate;

    @Override
    public void emailReport(String subject, String message) throws Exception {
        this.LOG.debug("emailReport() started");
        if (this.mailer == null) {
            String errorMessage = "mailer property of KualiExceptionIncidentServiceImpl is null";
            this.LOG.fatal(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        MailMessage msg = this.createMailMessage(subject, message);
        this.mailer.sendEmail(msg);
    }

    protected MailMessage createMailMessage(String subject, String message) throws Exception {
        this.LOG.debug("createMailMessage() started");
        MailMessage messageTemplate = this.getMessageTemplate();
        if (messageTemplate == null) {
            throw new IllegalStateException(String.format("%s.templateMessage is null or not set", this.getClass().getName()));
        }
        MailMessage msg = new MailMessage();
        msg.setFromAddress(this.getFromAddress());
        msg.setToAddresses(this.getToAddresses());
        msg.setBccAddresses(this.getBccAddresses());
        msg.setCcAddresses(this.getCcAddresses());
        msg.setSubject(subject == null ? "" : subject);
        msg.setMessage(message == null ? "" : message);
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", msg == null ? "null" : msg.toString());
            this.LOG.trace(lm);
        }
        return msg;
    }

    protected String getFromAddress() {
        Person actualUser = GlobalVariables.getUserSession().getActualPerson();
        String fromEmail = actualUser.getEmailAddress();
        if (StringUtils.isNotBlank((CharSequence)fromEmail)) {
            return fromEmail;
        }
        return this.getMessageTemplate().getFromAddress();
    }

    protected Set<String> getToAddresses() {
        Set emails = this.getMessageTemplate().getToAddresses();
        if (emails == null || emails.isEmpty()) {
            String mailingList = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(this.getToAddressesPropertyName());
            if (StringUtils.isBlank((CharSequence)mailingList)) {
                String em = REPORT_MAIL_LIST + " is not set or messageTemplate does not have ToAddresses already set.";
                this.LOG.error(em);
                throw new IllegalStateException(em);
            }
            return new HashSet<String>(Arrays.asList(StringUtils.split((String)mailingList, (String)",")));
        }
        return emails;
    }

    protected Set<String> getCcAddresses() {
        return this.getMessageTemplate().getCcAddresses();
    }

    protected Set<String> getBccAddresses() {
        return this.getMessageTemplate().getBccAddresses();
    }

    public final void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    public final Mailer getMailer() {
        return this.mailer;
    }

    public MailMessage getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(MailMessage messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    protected String getToAddressesPropertyName() {
        return REPORT_MAIL_LIST;
    }

    @Override
    public void report(KualiExceptionIncident exceptionIncident) throws Exception {
        String lm;
        if (this.LOG.isTraceEnabled()) {
            lm = String.format("ENTRY %s", exceptionIncident == null ? "null" : exceptionIncident.toString());
            this.LOG.trace(lm);
        }
        this.emailReport(exceptionIncident.getProperty("exceptionReportSubject"), exceptionIncident.getProperty("exceptionReportMessage"));
        if (this.LOG.isTraceEnabled()) {
            lm = String.format("EXIT", new Object[0]);
            this.LOG.trace(lm);
        }
    }

    public List<String> split(String s, String token) {
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s;%s", s, token);
            this.LOG.trace(lm);
        }
        String[] sarray = s.split(token);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < sarray.length && sarray[i].length() > 0; ++i) {
            list.add(sarray[i]);
        }
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", ((Object)list).toString());
            this.LOG.trace(lm);
        }
        return list;
    }

    @Override
    public KualiExceptionIncident getExceptionIncident(Exception exception, Map<String, String> properties) {
        if (exception == null) {
            return this.getExceptionIncident(properties);
        }
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s;%s", exception.getMessage(), properties.toString());
            this.LOG.trace(lm);
        }
        ExceptionIncident ei = new ExceptionIncident(exception, properties);
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", ei.toProperties().toString());
            this.LOG.trace(lm);
        }
        return ei;
    }

    @Override
    public KualiExceptionIncident getExceptionIncident(Map<String, String> properties) {
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s", properties.toString());
            this.LOG.trace(lm);
        }
        ExceptionIncident ei = new ExceptionIncident(properties);
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", ei.toProperties().toString());
            this.LOG.trace(lm);
        }
        return ei;
    }

    public void setIncidentMailingList(String incidentMailingList) {
    }
}

