/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.OptimisticLockException;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.PostProcessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.AfterProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.BeforeProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.DeleteEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentLockingEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PostProcessorServiceImpl
implements PostProcessorService {
    private static Logger LOG = LogManager.getLogger(PostProcessorServiceImpl.class);
    private DocumentService documentService;

    public ProcessDocReport doRouteStatusChange(final DocumentRouteStatusChange statusChangeEvent) throws Exception {
        return GlobalVariables.doInNewGlobalVariables(this.establishPostProcessorUserSession(), new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isInfoEnabled()) {
                        LOG.info((CharSequence)new StringBuffer("started handling route status change from ").append(statusChangeEvent.getOldRouteStatus()).append(" to ").append(statusChangeEvent.getNewRouteStatus()).append(" for document ").append(statusChangeEvent.getDocumentId()));
                    }
                    if ((document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(statusChangeEvent.getDocumentId())) == null) {
                        if (!"X".equals(statusChangeEvent.getNewRouteStatus())) {
                            throw new RuntimeException("unable to load document " + statusChangeEvent.getDocumentId());
                        }
                    } else {
                        document.doRouteStatusChange(statusChangeEvent);
                        if (!document.getDocumentHeader().getWorkflowDocument().isSaved()) {
                            PostProcessorServiceImpl.this.documentService.updateDocument(document);
                        }
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((CharSequence)new StringBuffer("finished handling route status change from ").append(statusChangeEvent.getOldRouteStatus()).append(" to ").append(statusChangeEvent.getNewRouteStatus()).append(" for document ").append(statusChangeEvent.getDocumentId()));
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("route status", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport doRouteLevelChange(final DocumentRouteLevelChange levelChangeEvent) throws Exception {
        return GlobalVariables.doInNewGlobalVariables(this.establishPostProcessorUserSession(), new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuffer("started handling route level change from ").append(levelChangeEvent.getOldNodeName()).append(" to ").append(levelChangeEvent.getNewNodeName()).append(" for document ").append(levelChangeEvent.getDocumentId()));
                    }
                    if ((document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(levelChangeEvent.getDocumentId())) == null) {
                        throw new RuntimeException("unable to load document " + levelChangeEvent.getDocumentId());
                    }
                    document.populateDocumentForRouting();
                    document.doRouteLevelChange(levelChangeEvent);
                    document.getDocumentHeader().getWorkflowDocument().saveDocumentData();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuffer("finished handling route level change from ").append(levelChangeEvent.getOldNodeName()).append(" to ").append(levelChangeEvent.getNewNodeName()).append(" for document ").append(levelChangeEvent.getDocumentId()));
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("route level", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport doDeleteRouteHeader(DeleteEvent event) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doActionTaken(final ActionTakenEvent event) throws Exception {
        return GlobalVariables.doInNewGlobalVariables(this.establishPostProcessorUserSession(), new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuffer("started doing action taken for action taken code").append(event.getActionTaken().getActionTaken()).append(" for document ").append(event.getDocumentId()));
                    }
                    if (ObjectUtils.isNull(document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId()))) {
                        if (!"CANCELED".equals(event.getActionTaken())) {
                            LOG.warn("doActionTaken() Unable to load document with id " + event.getDocumentId() + " using action taken code '" + (String)KewApiConstants.ACTION_TAKEN_CD.get(event.getActionTaken().getActionTaken()));
                        }
                    } else {
                        document.doActionTaken(event);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuffer("finished doing action taken for action taken code").append(event.getActionTaken().getActionTaken()).append(" for document ").append(event.getDocumentId()));
                        }
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("do action taken", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport afterActionTaken(final ActionType performed, final ActionTakenEvent event) throws Exception {
        return GlobalVariables.doInNewGlobalVariables(this.establishPostProcessorUserSession(), new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuffer("started doing after action taken for action performed code " + performed.getCode() + " and action taken code ").append(event.getActionTaken().getActionTaken()).append(" for document ").append(event.getDocumentId()));
                    }
                    if (ObjectUtils.isNull(document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId()))) {
                        if (!"CANCELED".equals(event.getActionTaken())) {
                            LOG.warn("afterActionTaken() Unable to load document with id " + event.getDocumentId() + " using action taken code '" + (String)KewApiConstants.ACTION_TAKEN_CD.get(event.getActionTaken().getActionTaken()));
                        }
                    } else {
                        document.afterActionTaken(performed, event);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuffer("finished doing after action taken for action taken code").append(event.getActionTaken().getActionTaken()).append(" for document ").append(event.getDocumentId()));
                        }
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("do action taken", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport afterProcess(final AfterProcessEvent event) throws Exception {
        return GlobalVariables.doInNewGlobalVariables(this.establishPostProcessorUserSession(), new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuffer("started after process method for document ").append(event.getDocumentId()));
                    }
                    if (ObjectUtils.isNull(document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId()))) {
                        LOG.warn("afterProcess() Unable to load document with id " + event.getDocumentId() + "... ignoring post processing");
                    } else {
                        document.afterWorkflowEngineProcess(event.isSuccessfullyProcessed());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuffer("finished after process method for document ").append(event.getDocumentId()));
                        }
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("after process", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport beforeProcess(final BeforeProcessEvent event) throws Exception {
        return GlobalVariables.doInNewGlobalVariables(this.establishPostProcessorUserSession(), new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuffer("started before process method for document ").append(event.getDocumentId()));
                    }
                    if (ObjectUtils.isNull(document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId()))) {
                        LOG.warn("beforeProcess() Unable to load document with id " + event.getDocumentId() + "... ignoring post processing");
                    } else {
                        document.beforeWorkflowEngineProcess();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuffer("finished before process method for document ").append(event.getDocumentId()));
                        }
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("before process", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public List<String> getDocumentIdsToLock(final DocumentLockingEvent event) throws Exception {
        return GlobalVariables.doInNewGlobalVariables(this.establishPostProcessorUserSession(), new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuffer("started get document ids to lock method for document ").append(event.getDocumentId()));
                    }
                    if (!ObjectUtils.isNull(document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId()))) {
                        List<String> documentIdsToLock = document.getWorkflowEngineDocumentIdsToLock();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuffer("finished get document ids to lock method for document ").append(event.getDocumentId()));
                        }
                        if (documentIdsToLock == null) {
                            return null;
                        }
                        return documentIdsToLock;
                    }
                    LOG.warn("getDocumentIdsToLock() Unable to load document with id " + event.getDocumentId() + "... ignoring post processing");
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("before process", e);
                }
                return null;
            }
        });
    }

    private void logAndRethrow(String changeType, Exception e) throws RuntimeException {
        LOG.error("caught exception while handling " + changeType + " change", (Throwable)e);
        this.logOptimisticDetails(5, e);
        throw new RuntimeException("post processor caught exception while handling " + changeType + " change: " + e.getMessage(), e);
    }

    private void logOptimisticDetails(int depth, Throwable t) {
        if (depth > 0 && t != null) {
            if (t instanceof OptimisticLockException) {
                OptimisticLockException o = (OptimisticLockException)t;
                LOG.error("source of OptimisticLockException = " + o.getSourceObject().getClass().getName() + " ::= " + o.getSourceObject());
            } else {
                Throwable cause = t.getCause();
                if (cause != t) {
                    this.logOptimisticDetails(--depth, cause);
                }
            }
        }
    }

    public final void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected UserSession establishPostProcessorUserSession() throws WorkflowException {
        if (GlobalVariables.getUserSession() == null) {
            return new UserSession("kfs");
        }
        return GlobalVariables.getUserSession();
    }
}

