/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.ComponentSecurity;
import org.kuali.kfs.krad.uif.component.ConfigurableBase;
import org.kuali.kfs.krad.uif.component.KeepExpression;
import org.kuali.kfs.krad.uif.component.PropertyReplacer;
import org.kuali.kfs.krad.uif.component.ReferenceCopy;
import org.kuali.kfs.krad.uif.control.ControlBase;
import org.kuali.kfs.krad.uif.modifier.ComponentModifier;
import org.kuali.kfs.krad.uif.util.ExpressionUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.util.ObjectUtils;

public abstract class ComponentBase
extends ConfigurableBase
implements Component {
    private static final long serialVersionUID = -4449335748129894350L;
    private String id;
    private String factoryId;
    private String template;
    private String title;
    private boolean render = true;
    private boolean refresh;
    @KeepExpression
    private String progressiveRender;
    private boolean progressiveRenderViaAJAX = false;
    private boolean progressiveRenderAndRefresh = false;
    private List<String> progressiveDisclosureControlNames;
    private String progressiveDisclosureConditionJs;
    @KeepExpression
    private String conditionalRefresh;
    private String conditionalRefreshConditionJs;
    private List<String> conditionalRefreshControlNames;
    private String refreshWhenChanged;
    private List<String> refreshWhenChangedControlNames;
    private boolean refreshedByAction = false;
    private boolean resetDataOnRefresh = false;
    private String refreshDiscloseMethodToCall;
    private boolean hidden;
    private boolean readOnly;
    private Boolean required;
    private String align;
    private String valign;
    private String width;
    private int colSpan = 1;
    private int rowSpan = 1;
    private String style;
    private List<String> styleClasses;
    private int order = 0;
    private boolean skipInTabOrder;
    private String finalizeMethodToCall;
    private List<Object> finalizeMethodAdditionalArguments;
    private boolean selfRendered = false;
    private String renderOutput;
    private boolean persistInSession = false;
    private ComponentSecurity componentSecurity = ObjectUtils.newInstance(this.getComponentSecurityClass());
    private String onLoadScript;
    private String onUnloadScript;
    private String onCloseScript;
    private String onBlurScript;
    private String onChangeScript;
    private String onClickScript;
    private String onDblClickScript;
    private String onFocusScript;
    private String onSubmitScript;
    private String onKeyPressScript;
    private String onKeyUpScript;
    private String onKeyDownScript;
    private String onMouseOverScript;
    private String onMouseOutScript;
    private String onMouseUpScript;
    private String onMouseDownScript;
    private String onMouseMoveScript;
    private String onDocumentReadyScript;
    private List<ComponentModifier> componentModifiers;
    private Map<String, String> componentOptions;
    private String componentOptionsJSString;
    @ReferenceCopy(newCollectionInstance=true)
    private transient Map<String, Object> context;
    private List<PropertyReplacer> propertyReplacers;

    public ComponentBase() {
        this.finalizeMethodAdditionalArguments = new ArrayList<Object>();
        this.styleClasses = new ArrayList<String>();
        this.componentModifiers = new ArrayList<ComponentModifier>();
        this.componentOptions = new HashMap<String, String>();
        this.context = new HashMap<String, Object>();
        this.propertyReplacers = new ArrayList<PropertyReplacer>();
    }

    @Override
    public void performInitialization(View view, Object model) {
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        if (StringUtils.isNotEmpty((CharSequence)this.progressiveRender)) {
            Boolean progRenderEval = (Boolean)KRADServiceLocatorWeb.getExpressionEvaluatorService().evaluateExpression(model, this.context, this.progressiveRender);
            this.setRender(progRenderEval != false && this.render);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        if (StringUtils.isNotEmpty((CharSequence)this.progressiveRender)) {
            this.progressiveRender = ExpressionUtils.replaceBindingPrefixes(view, this, this.progressiveRender);
            this.progressiveDisclosureControlNames = new ArrayList<String>();
            this.progressiveDisclosureConditionJs = ExpressionUtils.parseExpression(this.progressiveRender, this.progressiveDisclosureControlNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.conditionalRefresh)) {
            this.conditionalRefresh = ExpressionUtils.replaceBindingPrefixes(view, this, this.conditionalRefresh);
            this.conditionalRefreshControlNames = new ArrayList<String>();
            this.conditionalRefreshConditionJs = ExpressionUtils.parseExpression(this.conditionalRefresh, this.conditionalRefreshControlNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.refreshWhenChanged)) {
            String[] names;
            this.refreshWhenChanged = ExpressionUtils.replaceBindingPrefixes(view, this, this.refreshWhenChanged);
            this.refreshWhenChangedControlNames = new ArrayList<String>();
            for (String name : names = StringUtils.split((String)this.refreshWhenChanged, (String)",")) {
                this.refreshWhenChangedControlNames.add(name.trim());
            }
        }
        if (!"F".equals(view.getViewStatus())) {
            if (StringUtils.isNotBlank((CharSequence)this.getAlign()) && !StringUtils.contains((CharSequence)this.getStyle(), (CharSequence)"text-align: ")) {
                this.appendToStyle("text-align: " + this.getAlign() + ";");
            }
            if (StringUtils.isNotBlank((CharSequence)this.getValign()) && !StringUtils.contains((CharSequence)this.getStyle(), (CharSequence)"vertical-align: ")) {
                this.appendToStyle("vertical-align: " + this.getValign() + ";");
            }
            if (StringUtils.isNotBlank((CharSequence)this.getWidth()) && !StringUtils.contains((CharSequence)this.getStyle(), (CharSequence)"width: ")) {
                this.appendToStyle("width: " + this.getWidth() + ";");
            }
        }
        for (Component component : this.getComponentsForLifecycle()) {
            if (component == null || !(component instanceof ComponentBase) || !this.skipInTabOrder) continue;
            ((ComponentBase)component).setSkipInTabOrder(this.skipInTabOrder);
            if (!(component instanceof ControlBase)) continue;
            ((ControlBase)component).setTabIndex(-1);
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        ArrayList<Component> components = new ArrayList<Component>();
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (ComponentModifier modifier : this.componentModifiers) {
            components.addAll(modifier.getComponentPrototypes());
        }
        components.addAll(this.getPropertyReplacerComponents());
        return components;
    }

    @Override
    public List<Component> getPropertyReplacerComponents() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (PropertyReplacer replacer : this.propertyReplacers) {
            components.addAll(replacer.getNestedComponents());
        }
        return components;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getFactoryId() {
        return this.factoryId;
    }

    @Override
    public void setFactoryId(String factoryId) {
        this.factoryId = factoryId;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Override
    public boolean isRender() {
        return this.render;
    }

    @Override
    public void setRender(boolean render) {
        this.render = render;
    }

    @Override
    public int getColSpan() {
        return this.colSpan;
    }

    @Override
    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    @Override
    public int getRowSpan() {
        return this.rowSpan;
    }

    @Override
    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getValign() {
        return this.valign;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public List<String> getStyleClasses() {
        return this.styleClasses;
    }

    @Override
    public void setStyleClasses(List<String> styleClasses) {
        this.styleClasses = styleClasses;
    }

    public String getStyleClassesAsString() {
        if (this.styleClasses != null) {
            return StringUtils.join(this.styleClasses, (String)" ");
        }
        return "";
    }

    @Override
    public void addStyleClass(String styleClass) {
        if (!this.styleClasses.contains(styleClass)) {
            this.styleClasses.add(styleClass);
        }
    }

    @Override
    public void appendToStyle(String styleRules) {
        if (this.style == null) {
            this.style = "";
        }
        this.style = this.style + styleRules;
    }

    @Override
    public String getFinalizeMethodToCall() {
        return this.finalizeMethodToCall;
    }

    public void setFinalizeMethodToCall(String finalizeMethodToCall) {
        this.finalizeMethodToCall = finalizeMethodToCall;
    }

    @Override
    public List<Object> getFinalizeMethodAdditionalArguments() {
        return this.finalizeMethodAdditionalArguments;
    }

    public void setFinalizeMethodAdditionalArguments(List<Object> finalizeMethodAdditionalArguments) {
        this.finalizeMethodAdditionalArguments = finalizeMethodAdditionalArguments;
    }

    @Override
    public boolean isSelfRendered() {
        return this.selfRendered;
    }

    @Override
    public void setSelfRendered(boolean selfRendered) {
        this.selfRendered = selfRendered;
    }

    @Override
    public String getRenderOutput() {
        return this.renderOutput;
    }

    @Override
    public void setRenderOutput(String renderOutput) {
        this.renderOutput = renderOutput;
    }

    @Override
    public boolean isPersistInSession() {
        return this.persistInSession;
    }

    @Override
    public void setPersistInSession(boolean persistInSession) {
        this.persistInSession = persistInSession;
    }

    @Override
    public ComponentSecurity getComponentSecurity() {
        return this.componentSecurity;
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        this.componentSecurity = componentSecurity;
    }

    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return ComponentSecurity.class;
    }

    @Override
    public List<ComponentModifier> getComponentModifiers() {
        return this.componentModifiers;
    }

    @Override
    public void setComponentModifiers(List<ComponentModifier> componentModifiers) {
        this.componentModifiers = componentModifiers;
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public void pushObjectToContext(String objectName, Object object) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        this.pushToPropertyReplacerContext(objectName, object);
        this.context.put(objectName, object);
    }

    protected void pushToPropertyReplacerContext(String objectName, Object object) {
        for (Component replacerComponent : this.getPropertyReplacerComponents()) {
            replacerComponent.pushObjectToContext(objectName, object);
        }
    }

    @Override
    public void pushAllToContext(Map<String, Object> objects) {
        if (objects != null) {
            for (Map.Entry<String, Object> objectEntry : objects.entrySet()) {
                this.pushObjectToContext(objectEntry.getKey(), objectEntry.getValue());
            }
        }
    }

    @Override
    public List<PropertyReplacer> getPropertyReplacers() {
        return this.propertyReplacers;
    }

    @Override
    public void setPropertyReplacers(List<PropertyReplacer> propertyReplacers) {
        this.propertyReplacers = propertyReplacers;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public boolean getSupportsOnLoad() {
        return false;
    }

    @Override
    public String getOnLoadScript() {
        return this.onLoadScript;
    }

    @Override
    public void setOnLoadScript(String onLoadScript) {
        this.onLoadScript = onLoadScript;
    }

    @Override
    public boolean getSupportsOnDocumentReady() {
        return true;
    }

    @Override
    public String getOnDocumentReadyScript() {
        return this.onDocumentReadyScript;
    }

    @Override
    public void setOnDocumentReadyScript(String onDocumentReadyScript) {
        this.onDocumentReadyScript = onDocumentReadyScript;
    }

    @Override
    public boolean getSupportsOnUnload() {
        return false;
    }

    @Override
    public String getOnUnloadScript() {
        return this.onUnloadScript;
    }

    public void setOnUnloadScript(String onUnloadScript) {
        this.onUnloadScript = onUnloadScript;
    }

    @Override
    public boolean getSupportsOnClose() {
        return false;
    }

    @Override
    public String getOnCloseScript() {
        return this.onCloseScript;
    }

    public void setOnCloseScript(String onCloseScript) {
        this.onCloseScript = onCloseScript;
    }

    @Override
    public boolean getSupportsOnBlur() {
        return false;
    }

    @Override
    public String getOnBlurScript() {
        return this.onBlurScript;
    }

    @Override
    public void setOnBlurScript(String onBlurScript) {
        this.onBlurScript = onBlurScript;
    }

    @Override
    public boolean getSupportsOnChange() {
        return false;
    }

    @Override
    public String getOnChangeScript() {
        return this.onChangeScript;
    }

    public void setOnChangeScript(String onChangeScript) {
        this.onChangeScript = onChangeScript;
    }

    @Override
    public boolean getSupportsOnClick() {
        return false;
    }

    @Override
    public String getOnClickScript() {
        return this.onClickScript;
    }

    public void setOnClickScript(String onClickScript) {
        this.onClickScript = onClickScript;
    }

    @Override
    public boolean getSupportsOnDblClick() {
        return false;
    }

    @Override
    public String getOnDblClickScript() {
        return this.onDblClickScript;
    }

    public void setOnDblClickScript(String onDblClickScript) {
        this.onDblClickScript = onDblClickScript;
    }

    @Override
    public boolean getSupportsOnFocus() {
        return false;
    }

    @Override
    public String getOnFocusScript() {
        return this.onFocusScript;
    }

    public void setOnFocusScript(String onFocusScript) {
        this.onFocusScript = onFocusScript;
    }

    @Override
    public boolean getSupportsOnSubmit() {
        return false;
    }

    @Override
    public String getOnSubmitScript() {
        return this.onSubmitScript;
    }

    public void setOnSubmitScript(String onSubmitScript) {
        this.onSubmitScript = onSubmitScript;
    }

    @Override
    public boolean getSupportsOnKeyPress() {
        return false;
    }

    @Override
    public String getOnKeyPressScript() {
        return this.onKeyPressScript;
    }

    public void setOnKeyPressScript(String onKeyPressScript) {
        this.onKeyPressScript = onKeyPressScript;
    }

    @Override
    public boolean getSupportsOnKeyUp() {
        return false;
    }

    @Override
    public String getOnKeyUpScript() {
        return this.onKeyUpScript;
    }

    public void setOnKeyUpScript(String onKeyUpScript) {
        this.onKeyUpScript = onKeyUpScript;
    }

    @Override
    public boolean getSupportsOnKeyDown() {
        return false;
    }

    @Override
    public String getOnKeyDownScript() {
        return this.onKeyDownScript;
    }

    public void setOnKeyDownScript(String onKeyDownScript) {
        this.onKeyDownScript = onKeyDownScript;
    }

    @Override
    public boolean getSupportsOnMouseOver() {
        return false;
    }

    @Override
    public String getOnMouseOverScript() {
        return this.onMouseOverScript;
    }

    public void setOnMouseOverScript(String onMouseOverScript) {
        this.onMouseOverScript = onMouseOverScript;
    }

    @Override
    public boolean getSupportsOnMouseOut() {
        return false;
    }

    @Override
    public String getOnMouseOutScript() {
        return this.onMouseOutScript;
    }

    public void setOnMouseOutScript(String onMouseOutScript) {
        this.onMouseOutScript = onMouseOutScript;
    }

    @Override
    public boolean getSupportsOnMouseUp() {
        return false;
    }

    @Override
    public String getOnMouseUpScript() {
        return this.onMouseUpScript;
    }

    public void setOnMouseUpScript(String onMouseUpScript) {
        this.onMouseUpScript = onMouseUpScript;
    }

    @Override
    public boolean getSupportsOnMouseDown() {
        return false;
    }

    @Override
    public String getOnMouseDownScript() {
        return this.onMouseDownScript;
    }

    public void setOnMouseDownScript(String onMouseDownScript) {
        this.onMouseDownScript = onMouseDownScript;
    }

    @Override
    public boolean getSupportsOnMouseMove() {
        return false;
    }

    @Override
    public String getOnMouseMoveScript() {
        return this.onMouseMoveScript;
    }

    public void setOnMouseMoveScript(String onMouseMoveScript) {
        this.onMouseMoveScript = onMouseMoveScript;
    }

    @Override
    public Map<String, String> getComponentOptions() {
        if (this.componentOptions == null) {
            this.componentOptions = new HashMap<String, String>();
        }
        return this.componentOptions;
    }

    @Override
    public void setComponentOptions(Map<String, String> componentOptions) {
        this.componentOptions = componentOptions;
    }

    @Override
    public String getComponentOptionsJSString() {
        if (this.componentOptionsJSString != null) {
            return this.componentOptionsJSString;
        }
        if (this.componentOptions == null) {
            this.componentOptions = new HashMap<String, String>();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (String optionKey : this.componentOptions.keySet()) {
            String optionValue = this.componentOptions.get(optionKey);
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(optionKey);
            sb.append(":");
            boolean isNumber = false;
            if (StringUtils.isNotBlank((CharSequence)optionValue) && (StringUtils.isNumeric((CharSequence)optionValue.trim().substring(0, 1)) || optionValue.trim().substring(0, 1).equals("-"))) {
                try {
                    Double.parseDouble(optionValue.trim());
                    isNumber = true;
                }
                catch (NumberFormatException e) {
                    isNumber = false;
                }
            }
            if (StringUtils.startsWith((CharSequence)optionValue, (CharSequence)"{") || StringUtils.startsWith((CharSequence)optionValue, (CharSequence)"[")) {
                sb.append(optionValue);
                continue;
            }
            if ("false".equalsIgnoreCase(optionValue) || "true".equalsIgnoreCase(optionValue)) {
                sb.append(optionValue);
                continue;
            }
            if (StringUtils.startsWith((CharSequence)optionValue, (CharSequence)"function") && StringUtils.endsWith((CharSequence)optionValue, (CharSequence)"}")) {
                sb.append(optionValue);
                continue;
            }
            if (isNumber) {
                sb.append(optionValue);
                continue;
            }
            sb.append("\"" + optionValue + "\"");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setComponentOptionsJSString(String componentOptionsJSString) {
        this.componentOptionsJSString = componentOptionsJSString;
    }

    public String getEventCode() {
        String eventCode = "";
        return eventCode;
    }

    @Override
    public String getProgressiveRender() {
        return this.progressiveRender;
    }

    @Override
    public void setProgressiveRender(String progressiveRender) {
        this.progressiveRender = progressiveRender;
    }

    @Override
    public String getConditionalRefresh() {
        return this.conditionalRefresh;
    }

    @Override
    public void setConditionalRefresh(String conditionalRefresh) {
        this.conditionalRefresh = conditionalRefresh;
    }

    @Override
    public List<String> getProgressiveDisclosureControlNames() {
        return this.progressiveDisclosureControlNames;
    }

    @Override
    public String getProgressiveDisclosureConditionJs() {
        return this.progressiveDisclosureConditionJs;
    }

    @Override
    public String getConditionalRefreshConditionJs() {
        return this.conditionalRefreshConditionJs;
    }

    @Override
    public List<String> getConditionalRefreshControlNames() {
        return this.conditionalRefreshControlNames;
    }

    @Override
    public boolean isProgressiveRenderViaAJAX() {
        return this.progressiveRenderViaAJAX;
    }

    @Override
    public void setProgressiveRenderViaAJAX(boolean progressiveRenderViaAJAX) {
        this.progressiveRenderViaAJAX = progressiveRenderViaAJAX;
    }

    @Override
    public boolean isProgressiveRenderAndRefresh() {
        return this.progressiveRenderAndRefresh;
    }

    @Override
    public void setProgressiveRenderAndRefresh(boolean progressiveRenderAndRefresh) {
        this.progressiveRenderAndRefresh = progressiveRenderAndRefresh;
    }

    @Override
    public String getRefreshWhenChanged() {
        return this.refreshWhenChanged;
    }

    @Override
    public void setRefreshWhenChanged(String refreshWhenChanged) {
        this.refreshWhenChanged = refreshWhenChanged;
    }

    @Override
    public List<String> getRefreshWhenChangedControlNames() {
        return this.refreshWhenChangedControlNames;
    }

    @Override
    public boolean isRefreshedByAction() {
        return this.refreshedByAction;
    }

    @Override
    public void setRefreshedByAction(boolean refreshedByAction) {
        this.refreshedByAction = refreshedByAction;
    }

    @Override
    public boolean isResetDataOnRefresh() {
        return this.resetDataOnRefresh;
    }

    @Override
    public void setResetDataOnRefresh(boolean resetDataOnRefresh) {
        this.resetDataOnRefresh = resetDataOnRefresh;
    }

    @Override
    public boolean isRefresh() {
        return this.refresh;
    }

    @Override
    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public String getRefreshDiscloseMethodToCall() {
        return this.refreshDiscloseMethodToCall;
    }

    public void setRefreshDiscloseMethodToCall(String refreshDiscloseMethodToCall) {
        this.refreshDiscloseMethodToCall = refreshDiscloseMethodToCall;
    }

    public void setSkipInTabOrder(boolean skipInTabOrder) {
        this.skipInTabOrder = skipInTabOrder;
    }

    public boolean isSkipInTabOrder() {
        return this.skipInTabOrder;
    }
}

