/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.service.impl;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.inquiry.Inquirable;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.component.BindingInfo;
import org.kuali.kfs.krad.uif.component.ClientSideState;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.ComponentSecurity;
import org.kuali.kfs.krad.uif.component.DataBinding;
import org.kuali.kfs.krad.uif.component.PropertyReplacer;
import org.kuali.kfs.krad.uif.component.RequestParameter;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.container.Container;
import org.kuali.kfs.krad.uif.container.Group;
import org.kuali.kfs.krad.uif.control.TextControl;
import org.kuali.kfs.krad.uif.field.ActionField;
import org.kuali.kfs.krad.uif.field.DataField;
import org.kuali.kfs.krad.uif.field.Field;
import org.kuali.kfs.krad.uif.field.FieldGroup;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.field.RemoteFieldsHolder;
import org.kuali.kfs.krad.uif.layout.LayoutManager;
import org.kuali.kfs.krad.uif.modifier.ComponentModifier;
import org.kuali.kfs.krad.uif.service.ExpressionEvaluatorService;
import org.kuali.kfs.krad.uif.service.ViewDictionaryService;
import org.kuali.kfs.krad.uif.service.ViewHelperService;
import org.kuali.kfs.krad.uif.util.BooleanMap;
import org.kuali.kfs.krad.uif.util.CloneUtils;
import org.kuali.kfs.krad.uif.util.ComponentFactory;
import org.kuali.kfs.krad.uif.util.ComponentUtils;
import org.kuali.kfs.krad.uif.util.ExpressionUtils;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.util.ScriptUtils;
import org.kuali.kfs.krad.uif.util.ViewCleaner;
import org.kuali.kfs.krad.uif.util.ViewModelUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.view.ViewAuthorizer;
import org.kuali.kfs.krad.uif.view.ViewModel;
import org.kuali.kfs.krad.uif.view.ViewPresentationController;
import org.kuali.kfs.krad.uif.widget.Inquiry;
import org.kuali.kfs.krad.uif.widget.Widget;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.valuefinder.ValueFinder;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public class ViewHelperServiceImpl
implements ViewHelperService,
Serializable {
    private static final Logger LOG = LogManager.getLogger(ViewHelperServiceImpl.class);
    private transient DataDictionaryService dataDictionaryService;
    private transient ExpressionEvaluatorService expressionEvaluatorService;
    private transient ViewDictionaryService viewDictionaryService;

    @Override
    public void populateViewFromRequestParameters(View view, Map<String, String> parameters) {
        HashMap viewPropertyReplacers = new HashMap();
        for (PropertyReplacer replacer : view.getPropertyReplacers()) {
            Set<PropertyReplacer> propertyReplacers = new HashSet<PropertyReplacer>();
            if (viewPropertyReplacers.containsKey(replacer.getPropertyName())) {
                propertyReplacers = (Set)viewPropertyReplacers.get(replacer.getPropertyName());
            }
            propertyReplacers.add(replacer);
            viewPropertyReplacers.put(replacer.getPropertyName(), propertyReplacers);
        }
        Map<String, Annotation> annotatedFields = CloneUtils.getFieldsWithAnnotation(view.getClass(), RequestParameter.class);
        HashMap<String, String> viewRequestParameters = new HashMap<String, String>();
        for (String fieldToPopulate : annotatedFields.keySet()) {
            String fieldValue;
            RequestParameter requestParameter = (RequestParameter)annotatedFields.get(fieldToPopulate);
            String requestParameterName = requestParameter.parameterName();
            if (StringUtils.isBlank((CharSequence)requestParameterName)) {
                requestParameterName = fieldToPopulate;
            }
            if (!parameters.containsKey(requestParameterName) || !StringUtils.isNotBlank((CharSequence)(fieldValue = parameters.get(requestParameterName)))) continue;
            viewRequestParameters.put(requestParameterName, fieldValue);
            ObjectPropertyUtils.setPropertyValue(view, fieldToPopulate, fieldValue);
            if (view.getPropertyExpressions().containsKey(fieldToPopulate)) {
                view.getPropertyExpressions().remove(fieldToPopulate);
            }
            if (!viewPropertyReplacers.containsKey(fieldToPopulate)) continue;
            Set propertyReplacers = (Set)viewPropertyReplacers.get(fieldToPopulate);
            for (PropertyReplacer replacer : propertyReplacers) {
                view.getPropertyReplacers().remove(replacer);
            }
        }
        view.setViewRequestParameters(viewRequestParameters);
    }

    @Override
    public void performInitialization(View view, Object model) {
        view.assignComponentIds(view);
        this.performComponentInitialization(view, model, view);
    }

    @Override
    public void performComponentLifecycle(View view, Object model, Component component, String origId) {
        Component origComponent = view.getViewIndex().getComponentById(origId);
        Integer currentSequenceVal = view.getIdSequence();
        Integer startingSequenceVal = view.getViewIndex().getIdSequenceSnapshot().get(component.getId());
        view.setIdSequence(startingSequenceVal);
        view.assignComponentIds(component);
        view.setIdSequence(currentSequenceVal);
        Component parent = (Component)origComponent.getContext().get("parent");
        component.pushAllToContext(origComponent.getContext());
        String suffix = StringUtils.replaceOnce((String)origComponent.getId(), (String)origComponent.getFactoryId(), (String)"");
        if (suffix.endsWith("_attribute")) {
            suffix = StringUtils.removeEnd((String)suffix, (String)"_attribute");
        }
        ComponentUtils.updateIdWithSuffix(component, suffix);
        if (component instanceof DataBinding) {
            ((DataBinding)((Object)component)).setBindingInfo(((DataBinding)((Object)origComponent)).getBindingInfo());
            ((DataBinding)((Object)component)).getBindingInfo().setBindingPath(((DataBinding)((Object)origComponent)).getBindingInfo().getBindingPath());
        }
        if (component instanceof Field) {
            ((Field)component).setLabelFieldRendered(((Field)origComponent).isLabelFieldRendered());
        } else if (component instanceof CollectionGroup) {
            ((CollectionGroup)component).setSubCollectionSuffix(((CollectionGroup)origComponent).getSubCollectionSuffix());
        }
        if (origComponent.isRefreshedByAction()) {
            component.setRefreshedByAction(true);
        }
        if (component.isResetDataOnRefresh() && component instanceof DataField) {
            ObjectPropertyUtils.initializeProperty(model, ((DataField)component).getBindingInfo().getBindingPath());
        }
        this.performComponentInitialization(view, model, component);
        view.getViewIndex().indexComponent(component);
        this.performComponentApplyModel(view, component, model);
        view.getViewIndex().indexComponent(component);
        if (component instanceof Group || component instanceof FieldGroup) {
            List<Component> nestedComponents = ComponentUtils.getAllNestedComponents(component);
            for (Component nestedComponent : nestedComponents) {
                Component origNestedComponent = null;
                origNestedComponent = nestedComponent instanceof DataField ? view.getViewIndex().getComponentById(nestedComponent.getId() + suffix + "_attribute") : view.getViewIndex().getComponentById(nestedComponent.getId() + suffix);
                if (origNestedComponent == null) continue;
                if (nestedComponent instanceof DataBinding) {
                    ((DataBinding)((Object)nestedComponent)).setBindingInfo(((DataBinding)((Object)origNestedComponent)).getBindingInfo());
                    ((DataBinding)((Object)nestedComponent)).getBindingInfo().setBindingPath(((DataBinding)((Object)origNestedComponent)).getBindingInfo().getBindingPath());
                }
                if (nestedComponent instanceof Field) {
                    ((Field)nestedComponent).setLabelFieldRendered(((Field)origNestedComponent).isLabelFieldRendered());
                }
                if (origNestedComponent.isRefreshedByAction()) {
                    nestedComponent.setRefreshedByAction(true);
                }
                ComponentUtils.updateIdWithSuffix(nestedComponent, suffix);
            }
        }
        HashMap<String, Object> clientState = new HashMap<String, Object>();
        this.performComponentFinalize(view, component, model, parent, clientState);
        String clientStateScript = this.buildClientSideStateScript(view, clientState, true);
        String onLoadScript = component.getOnLoadScript();
        if (StringUtils.isNotBlank((CharSequence)onLoadScript)) {
            clientStateScript = onLoadScript + clientStateScript;
        }
        component.setOnLoadScript(clientStateScript);
        view.getViewIndex().indexComponent(component);
    }

    @Override
    public void performComponentInitialization(View view, Object model, Component component) {
        if (component == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)component.getId())) {
            throw new RiceRuntimeException("Id is not set, this should not happen unless a component is misconfigured");
        }
        LOG.debug("Initializing component: " + component.getId() + " with type: " + component.getClass());
        if (!(component instanceof View)) {
            view.getViewIndex().addInitialComponentStateIfNeeded(component);
        }
        component.performInitialization(view, model);
        if (component instanceof DataField) {
            this.initializeDataFieldFromDataDictionary(view, (DataField)component);
        }
        if (component instanceof Container) {
            LayoutManager layoutManager = ((Container)component).getLayoutManager();
            this.addCustomContainerComponents(view, model, (Container)component);
            if (!(component instanceof CollectionGroup)) {
                this.processAnyRemoteFieldsHolder(view, model, (Container)component);
            }
        }
        this.runComponentModifiers(view, component, null, "INITIALIZE");
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            this.performComponentInitialization(view, model, nestedComponent);
        }
        for (PropertyReplacer replacer : component.getPropertyReplacers()) {
            for (Component replacerComponent : replacer.getNestedComponents()) {
                this.performComponentInitialization(view, model, replacerComponent);
            }
        }
        this.performCustomInitialization(view, component);
    }

    protected void processAnyRemoteFieldsHolder(View view, Object model, Container container) {
        ArrayList<Component> processedItems = new ArrayList<Component>();
        for (Component component : container.getItems()) {
            if (component instanceof RemoteFieldsHolder) {
                List<InputField> translatedFields = ((RemoteFieldsHolder)component).fetchAndTranslateRemoteFields(view, model, container);
                processedItems.addAll(translatedFields);
                continue;
            }
            processedItems.add(component);
        }
        container.setItems(processedItems);
    }

    protected void initializeDataFieldFromDataDictionary(View view, DataField field) {
        InputField inputField;
        AttributeDefinition attributeDefinition = null;
        String dictionaryAttributeName = field.getDictionaryAttributeName();
        String dictionaryObjectEntry = field.getDictionaryObjectEntry();
        if (StringUtils.isNotBlank((CharSequence)dictionaryObjectEntry) && StringUtils.isBlank((CharSequence)dictionaryAttributeName)) {
            dictionaryAttributeName = field.getPropertyName();
        }
        if (StringUtils.isNotBlank((CharSequence)dictionaryAttributeName) && StringUtils.isNotBlank((CharSequence)dictionaryObjectEntry)) {
            attributeDefinition = this.getDataDictionaryService().getAttributeDefinition(dictionaryObjectEntry, dictionaryAttributeName);
        }
        if (attributeDefinition == null) {
            String propertyPath = field.getBindingInfo().getBindingPath();
            if (StringUtils.isNotBlank((CharSequence)field.getBindingInfo().getCollectionPath())) {
                propertyPath = field.getBindingInfo().getCollectionPath();
                if (StringUtils.isNotBlank((CharSequence)field.getBindingInfo().getBindByNamePrefix())) {
                    propertyPath = propertyPath + "." + field.getBindingInfo().getBindByNamePrefix();
                }
                propertyPath = propertyPath + "." + field.getBindingInfo().getBindingName();
            }
            attributeDefinition = this.findNestedDictionaryAttribute(view, field, null, propertyPath);
        }
        if (attributeDefinition != null) {
            field.copyFromAttributeDefinition(view, attributeDefinition);
        }
        if (field instanceof InputField && (inputField = (InputField)field).getControl() == null) {
            TextControl control = ComponentFactory.getTextControl();
            control.setId(view.getNextId());
            control.setFactoryId(control.getId());
            inputField.setControl(control);
        }
    }

    protected AttributeDefinition findNestedDictionaryAttribute(View view, DataField field, String parentPath, String propertyPath) {
        Class<?> dictionaryModelClass;
        AttributeDefinition attributeDefinition = null;
        String dictionaryAttributeName = propertyPath;
        String dictionaryObjectEntry = null;
        if (field.getBindingInfo().isBindToMap()) {
            parentPath = "";
            if (!field.getBindingInfo().isBindToForm() && StringUtils.isNotBlank((CharSequence)field.getBindingInfo().getBindingObjectPath())) {
                parentPath = field.getBindingInfo().getBindingObjectPath();
            }
            if (StringUtils.isNotBlank((CharSequence)field.getBindingInfo().getBindByNamePrefix())) {
                parentPath = StringUtils.isNotBlank((CharSequence)parentPath) ? parentPath + "." + field.getBindingInfo().getBindByNamePrefix() : field.getBindingInfo().getBindByNamePrefix();
            }
            dictionaryAttributeName = field.getBindingInfo().getBindingName();
        }
        if (StringUtils.isNotBlank((CharSequence)parentPath) && (dictionaryModelClass = ViewModelUtils.getPropertyTypeByClassAndView(view, parentPath)) != null) {
            dictionaryObjectEntry = dictionaryModelClass.getName();
            attributeDefinition = this.getDataDictionaryService().getAttributeDefinition(dictionaryObjectEntry, dictionaryAttributeName);
        }
        if (attributeDefinition == null && StringUtils.contains((CharSequence)propertyPath, (CharSequence)".")) {
            String nextParentPath = StringUtils.substringBefore((String)propertyPath, (String)".");
            if (StringUtils.isNotBlank((CharSequence)parentPath)) {
                nextParentPath = parentPath + "." + nextParentPath;
            }
            String nextPropertyPath = StringUtils.substringAfter((String)propertyPath, (String)".");
            return this.findNestedDictionaryAttribute(view, field, nextParentPath, nextPropertyPath);
        }
        if (attributeDefinition != null) {
            field.setDictionaryAttributeName(dictionaryAttributeName);
            field.setDictionaryObjectEntry(dictionaryObjectEntry);
        }
        return attributeDefinition;
    }

    @Override
    public void performApplyModel(View view, Object model) {
        this.retrieveEditModesAndActionFlags(view, (UifFormBase)model);
        this.setViewContext(view, model);
        this.performComponentApplyModel(view, view, model);
    }

    protected void retrieveEditModesAndActionFlags(View view, UifFormBase model) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        Set<String> actionFlags = presentationController.getActionFlags(view, model);
        actionFlags = authorizer.getActionFlags(view, model, user, actionFlags);
        view.setActionFlags(new BooleanMap(actionFlags));
        Set<String> editModes = presentationController.getEditModes(view, model);
        editModes = authorizer.getEditModes(view, model, user, editModes);
        view.setEditModes(new BooleanMap(editModes));
    }

    protected void setViewContext(View view, Object model) {
        view.pushAllToContext(this.getPreModelContext(view));
        for (Map.Entry<String, String> variableExpression : view.getExpressionVariables().entrySet()) {
            String variableName = variableExpression.getKey();
            Object value = this.getExpressionEvaluatorService().evaluateExpression(model, view.getContext(), variableExpression.getValue());
            view.pushObjectToContext(variableName, value);
        }
    }

    protected Map<String, Object> getPreModelContext(View view) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("view", view);
        context.put("ViewHelper", this);
        Map properties = KRADServiceLocator.getKualiConfigurationService().getAllProperties();
        context.put("ConfigProperties", properties);
        context.put("Constants", KRADConstants.class);
        context.put("UifConstants", UifConstants.class);
        return context;
    }

    protected void performComponentApplyModel(View view, Component component, Object model) {
        LayoutManager layoutManager;
        if (component == null) {
            return;
        }
        component.pushAllToContext(this.getCommonContext(view, component));
        ExpressionUtils.adjustPropertyExpressions(view, component);
        this.getExpressionEvaluatorService().evaluateObjectExpressions(component, model, component.getContext());
        ComponentSecurity componentSecurity = component.getComponentSecurity();
        ExpressionUtils.adjustPropertyExpressions(view, componentSecurity);
        this.getExpressionEvaluatorService().evaluateObjectExpressions(componentSecurity, model, component.getContext());
        if (component instanceof DataBinding) {
            BindingInfo bindingInfo = ((DataBinding)((Object)component)).getBindingInfo();
            ExpressionUtils.adjustPropertyExpressions(view, bindingInfo);
            this.getExpressionEvaluatorService().evaluateObjectExpressions(bindingInfo, model, component.getContext());
        }
        if (component instanceof Container && (layoutManager = ((Container)component).getLayoutManager()) != null) {
            layoutManager.getContext().putAll(this.getCommonContext(view, component));
            layoutManager.pushObjectToContext("parent", component);
            layoutManager.pushObjectToContext("manager", layoutManager);
            ExpressionUtils.adjustPropertyExpressions(view, layoutManager);
            this.getExpressionEvaluatorService().evaluateObjectExpressions(layoutManager, model, layoutManager.getContext());
        }
        this.syncClientSideStateForComponent(component, ((ViewModel)model).getClientStateForSyncing());
        this.applyAuthorizationAndPresentationLogic(view, component, (ViewModel)model);
        Component parent = (Component)component.getContext().get("parent");
        component.performApplyModel(view, model, parent);
        this.performCustomApplyModel(view, component, model);
        this.runComponentModifiers(view, component, model, "APPLY_MODEL");
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            if (nestedComponent != null) {
                nestedComponent.pushObjectToContext("parent", component);
            }
            this.performComponentApplyModel(view, nestedComponent, model);
        }
    }

    protected void applyAuthorizationAndPresentationLogic(View view, Component component, ViewModel model) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        if (!component.isRender()) {
            return;
        }
        if (component instanceof View) {
            if (!view.isReadOnly()) {
                boolean canEditView = authorizer.canEditView(view, model, user);
                if (canEditView) {
                    canEditView = presentationController.canEditView(view, model);
                }
                view.setReadOnly(!canEditView);
            }
        } else if (component instanceof Group) {
            Group group = (Group)component;
            if (!group.isHidden()) {
                boolean canViewGroup = authorizer.canViewGroup(view, model, group, group.getId(), user);
                if (canViewGroup) {
                    canViewGroup = presentationController.canViewGroup(view, model, group, group.getId());
                }
                group.setHidden(!canViewGroup);
                group.setRender(canViewGroup);
            }
            if (!group.isReadOnly()) {
                boolean canEditGroup = authorizer.canEditGroup(view, model, group, group.getId(), user);
                if (canEditGroup) {
                    canEditGroup = presentationController.canEditGroup(view, model, group, group.getId());
                }
                group.setReadOnly(!canEditGroup);
            }
        } else if (component instanceof Field) {
            boolean canEditField;
            Field field = (Field)component;
            String propertyName = null;
            if (field instanceof DataBinding) {
                propertyName = ((DataBinding)((Object)field)).getPropertyName();
            }
            if (!field.isHidden()) {
                boolean canViewField = authorizer.canViewField(view, model, field, propertyName, user);
                if (canViewField) {
                    canViewField = presentationController.canViewField(view, model, field, propertyName);
                }
                field.setHidden(!canViewField);
                field.setRender(canViewField);
            }
            if (!field.isReadOnly()) {
                canEditField = authorizer.canEditField(view, model, field, propertyName, user);
                if (canEditField) {
                    canEditField = presentationController.canEditField(view, model, field, propertyName);
                }
                field.setReadOnly(!canEditField);
            }
            if (field.getRequired() == null || !field.getRequired().booleanValue()) {
                canEditField = presentationController.fieldIsRequired(view, model, field, propertyName);
            }
            if (field instanceof DataField) {
                DataField dataField = (DataField)field;
                boolean canUnmaskValue = authorizer.canUnmaskField(view, model, dataField, dataField.getPropertyName(), user);
                if (!canUnmaskValue) {
                    dataField.setApplyValueMask(true);
                    dataField.setMaskFormatter(dataField.getDataFieldSecurity().getAttributeSecurity().getMaskFormatter());
                } else {
                    boolean canPartiallyUnmaskValue = authorizer.canPartialUnmaskField(view, model, dataField, dataField.getPropertyName(), user);
                    if (!canPartiallyUnmaskValue) {
                        dataField.setApplyValueMask(true);
                        dataField.setMaskFormatter(dataField.getDataFieldSecurity().getAttributeSecurity().getPartialMaskFormatter());
                    }
                }
            }
            if (field instanceof ActionField) {
                ActionField actionField = (ActionField)field;
                boolean canTakeAction = authorizer.canPerformAction(view, model, actionField, actionField.getActionEvent(), actionField.getId(), user);
                if (canTakeAction) {
                    canTakeAction = presentationController.canPerformAction(view, model, actionField, actionField.getActionEvent(), actionField.getId());
                }
                actionField.setRender(canTakeAction);
            }
        } else if (component instanceof Widget) {
            Widget widget = (Widget)component;
            if (!widget.isHidden()) {
                boolean canViewWidget = authorizer.canViewWidget(view, model, widget, widget.getId(), user);
                if (canViewWidget) {
                    canViewWidget = presentationController.canViewWidget(view, model, widget, widget.getId());
                }
                widget.setHidden(!canViewWidget);
                widget.setRender(canViewWidget);
            }
            if (!widget.isReadOnly()) {
                boolean canEditWidget = authorizer.canEditWidget(view, model, widget, widget.getId(), user);
                if (canEditWidget) {
                    canEditWidget = presentationController.canEditWidget(view, model, widget, widget.getId());
                }
                widget.setReadOnly(!canEditWidget);
            }
        }
    }

    protected void runComponentModifiers(View view, Component component, Object model, String runPhase) {
        for (ComponentModifier modifier : component.getComponentModifiers()) {
            if (StringUtils.equals((CharSequence)runPhase, (CharSequence)"INITIALIZE")) {
                modifier.performInitialization(view, model, component);
            }
            if (!StringUtils.equals((CharSequence)modifier.getRunPhase(), (CharSequence)runPhase)) continue;
            boolean runModifier = true;
            if (StringUtils.isNotBlank((CharSequence)modifier.getRunCondition())) {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("component", component);
                context.put("view", view);
                String conditionEvaluation = this.getExpressionEvaluatorService().evaluateExpressionTemplate(model, context, modifier.getRunCondition());
                runModifier = Boolean.parseBoolean(conditionEvaluation);
            }
            if (!runModifier) continue;
            modifier.performModification(view, model, component);
        }
    }

    protected Map<String, Object> getCommonContext(View view, Component component) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.putAll(view.getContext());
        context.put("component", component);
        return context;
    }

    @Override
    public void performFinalize(View view, Object model) {
        HashMap<String, Object> clientState = new HashMap<String, Object>();
        this.performComponentFinalize(view, view, model, null, clientState);
        String clientStateScript = this.buildClientSideStateScript(view, clientState, false);
        String viewPreLoadScript = view.getPreLoadScript();
        if (StringUtils.isNotBlank((CharSequence)viewPreLoadScript)) {
            clientStateScript = viewPreLoadScript + clientStateScript;
        }
        view.setPreLoadScript(clientStateScript);
        if (!((ViewModel)model).isDefaultsApplied()) {
            this.applyDefaultValues(view, view, model);
            ((ViewModel)model).setDefaultsApplied(true);
        }
    }

    protected String buildClientSideStateScript(View view, Map<String, Object> clientSideState, boolean updateOnly) {
        for (Map.Entry<String, Object> additionalState : view.getClientSideState().entrySet()) {
            if (!clientSideState.containsKey(additionalState.getKey())) {
                clientSideState.put(additionalState.getKey(), additionalState.getValue());
                continue;
            }
            Object object = clientSideState.get(additionalState.getKey());
            Object mergeState = additionalState.getValue();
            if (object instanceof Map && mergeState instanceof Map) {
                ((Map)object).putAll((Map)mergeState);
                continue;
            }
            clientSideState.put((String)additionalState.getKey(), additionalState.getValue());
        }
        String clientStateScript = "";
        if (!clientSideState.isEmpty()) {
            clientStateScript = updateOnly ? "updateViewState({" : "initializeViewState({";
            for (Map.Entry entry : clientSideState.entrySet()) {
                clientStateScript = clientStateScript + "'" + (String)entry.getKey() + "':";
                clientStateScript = clientStateScript + ScriptUtils.translateValue(entry.getValue());
                clientStateScript = clientStateScript + ",";
            }
            clientStateScript = StringUtils.removeEnd((String)clientStateScript, (String)",");
            clientStateScript = clientStateScript + "});";
        }
        if (!updateOnly) {
            String kradImageLocation = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.externalizable.images.url");
            clientStateScript = clientStateScript + "setConfigParam('kradImageLocation','" + kradImageLocation + "');";
            String string = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.url");
            clientStateScript = clientStateScript + "setConfigParam('kradUrl','" + string + "');";
        }
        return clientStateScript;
    }

    protected void performComponentFinalize(View view, Component component, Object model, Component parent, Map<String, Object> clientSideState) {
        if (component == null) {
            return;
        }
        ViewModel viewModel = (ViewModel)model;
        if (component instanceof DataBinding && view.isSupportsReadOnlyFieldsOverride() && !viewModel.getReadOnlyFieldsList().isEmpty()) {
            String propertyName = ((DataBinding)((Object)component)).getPropertyName();
            if (viewModel.getReadOnlyFieldsList().contains(propertyName)) {
                component.setReadOnly(true);
            }
        }
        this.invokeMethodFinalizer(view, component, model);
        component.performFinalize(view, model, parent);
        this.addClientSideStateForComponent(component, clientSideState);
        this.performCustomFinalize(view, component, model, parent);
        this.runComponentModifiers(view, component, model, "FINALIZE");
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            this.performComponentFinalize(view, nestedComponent, model, component, clientSideState);
        }
    }

    protected void addClientSideStateForComponent(Component component, Map<String, Object> clientSideState) {
        Map<String, Annotation> annotatedFields = CloneUtils.getFieldsWithAnnotation(component.getClass(), ClientSideState.class);
        if (!annotatedFields.isEmpty()) {
            Map componentClientState = null;
            if (component instanceof View) {
                componentClientState = clientSideState;
            } else if (clientSideState.containsKey(component.getId())) {
                componentClientState = (Map)clientSideState.get(component.getId());
            } else {
                componentClientState = new HashMap<String, Object>();
                clientSideState.put(component.getId(), componentClientState);
            }
            for (Map.Entry<String, Annotation> annotatedField : annotatedFields.entrySet()) {
                ClientSideState clientSideStateAnnot = (ClientSideState)annotatedField.getValue();
                String variableName = clientSideStateAnnot.variableName();
                if (StringUtils.isBlank((CharSequence)variableName)) {
                    variableName = annotatedField.getKey();
                }
                Object value = ObjectPropertyUtils.getPropertyValue(component, annotatedField.getKey());
                componentClientState.put(variableName, value);
            }
        }
    }

    protected void syncClientSideStateForComponent(Component component, Map<String, Object> clientSideState) {
        Map componentState = null;
        if (component instanceof View) {
            componentState = clientSideState;
        } else if (clientSideState.containsKey(component.getId())) {
            componentState = (Map)clientSideState.get(component.getId());
        }
        if (componentState != null && !componentState.isEmpty()) {
            Map<String, Annotation> annotatedFields = CloneUtils.getFieldsWithAnnotation(component.getClass(), ClientSideState.class);
            for (Map.Entry<String, Annotation> annotatedField : annotatedFields.entrySet()) {
                ClientSideState clientSideStateAnnot = (ClientSideState)annotatedField.getValue();
                String variableName = clientSideStateAnnot.variableName();
                if (StringUtils.isBlank((CharSequence)variableName)) {
                    variableName = annotatedField.getKey();
                }
                if (!componentState.containsKey(variableName)) continue;
                Object value = componentState.get(variableName);
                ObjectPropertyUtils.setPropertyValue(component, annotatedField.getKey(), value);
            }
        }
    }

    protected void invokeMethodFinalizer(View view, Component component, Object model) {
        List<Object> additionalArguments;
        String finalizeMethodToCall = component.getFinalizeMethodToCall();
        if (StringUtils.isBlank((CharSequence)finalizeMethodToCall)) {
            return;
        }
        MethodInvoker finalizeMethodInvoker = new MethodInvoker();
        if (StringUtils.isBlank((CharSequence)finalizeMethodInvoker.getTargetMethod())) {
            finalizeMethodInvoker.setTargetMethod(finalizeMethodToCall);
        }
        if (finalizeMethodInvoker.getTargetClass() == null && finalizeMethodInvoker.getTargetObject() == null) {
            finalizeMethodInvoker.setTargetObject((Object)view.getViewHelperService());
        }
        if ((additionalArguments = component.getFinalizeMethodAdditionalArguments()) == null) {
            additionalArguments = new ArrayList<Object>();
        }
        Object[] arguments = new Object[2 + additionalArguments.size()];
        arguments[0] = component;
        arguments[1] = model;
        int argumentIndex = 1;
        for (Object argument : additionalArguments) {
            arguments[++argumentIndex] = argument;
        }
        finalizeMethodInvoker.setArguments(arguments);
        try {
            LOG.debug("Invoking render method: " + finalizeMethodInvoker.getTargetMethod() + " for component: " + component.getId());
            finalizeMethodInvoker.prepare();
            Class<?> methodReturnType = finalizeMethodInvoker.getPreparedMethod().getReturnType();
            if (StringUtils.equals((CharSequence)"void", (CharSequence)methodReturnType.getName())) {
                finalizeMethodInvoker.invoke();
            } else {
                String renderOutput = (String)finalizeMethodInvoker.invoke();
                component.setSelfRendered(true);
                component.setRenderOutput(renderOutput);
            }
        }
        catch (Exception e) {
            LOG.error("Error invoking rendering method for component: " + component.getId(), (Throwable)e);
            throw new RuntimeException("Error invoking rendering method for component: " + component.getId(), e);
        }
    }

    @Override
    public void cleanViewAfterRender(View view) {
        ViewCleaner.cleanView(view);
    }

    @Override
    public void processCollectionAddLine(View view, Object model, String collectionPath) {
        String addLinePath;
        Object addLine;
        Collection collection;
        CollectionGroup collectionGroup = view.getViewIndex().getCollectionGroupByPath(collectionPath);
        if (collectionGroup == null) {
            this.logAndThrowRuntime("Unable to get collection group component for path: " + collectionPath);
        }
        if ((collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath)) == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        if ((addLine = ObjectPropertyUtils.getPropertyValue(model, addLinePath = collectionGroup.getAddLineBindingInfo().getBindingPath())) == null) {
            this.logAndThrowRuntime("Add line instance not found for path: " + addLinePath);
        }
        this.processBeforeAddLine(view, collectionGroup, model, addLine);
        boolean isValidLine = this.performAddLineValidation(view, collectionGroup, model, addLine);
        if (isValidLine) {
            this.addLine(collection, addLine);
            collectionGroup.initializeNewCollectionLine(view, model, collectionGroup, true);
        }
        this.processAfterAddLine(view, collectionGroup, model, addLine);
    }

    protected void addLine(Collection<Object> collection, Object addLine) {
        if (collection instanceof List) {
            ((List)collection).add(0, addLine);
        } else {
            collection.add(addLine);
        }
    }

    protected boolean performAddLineValidation(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
        boolean isValid = true;
        return isValid;
    }

    @Override
    public void processCollectionDeleteLine(View view, Object model, String collectionPath, int lineIndex) {
        Collection collection;
        CollectionGroup collectionGroup = view.getViewIndex().getCollectionGroupByPath(collectionPath);
        if (collectionGroup == null) {
            this.logAndThrowRuntime("Unable to get collection group component for path: " + collectionPath);
        }
        if ((collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath)) == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        if (collection instanceof List) {
            Object deleteLine = ((List)collection).get(lineIndex);
            boolean isValid = this.performDeleteLineValidation(view, collectionGroup, deleteLine);
            if (isValid) {
                ((List)collection).remove(lineIndex);
                this.processAfterDeleteLine(view, collectionGroup, model, lineIndex);
            }
        } else {
            this.logAndThrowRuntime("Only List collection implementations are supported for the delete by index method");
        }
    }

    protected boolean performDeleteLineValidation(View view, CollectionGroup collectionGroup, Object deleteLine) {
        boolean isValid = true;
        return isValid;
    }

    @Override
    public void processMultipleValueLookupResults(View view, Object model, String collectionPath, String lookupResultValues) {
        String[] lineValues;
        if (StringUtils.isBlank((CharSequence)lookupResultValues)) {
            return;
        }
        CollectionGroup collectionGroup = view.getViewIndex().getCollectionGroupByPath(collectionPath);
        if (collectionGroup == null) {
            throw new RuntimeException("Unable to find collection group for path: " + collectionPath);
        }
        Class<?> collectionObjectClass = collectionGroup.getCollectionObjectClass();
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath());
        if (collection == null) {
            Class<?> collectionClass = ObjectPropertyUtils.getPropertyType(model, collectionGroup.getBindingInfo().getBindingPath());
            collection = (Collection)ObjectUtils.newInstance(collectionClass);
            ObjectPropertyUtils.setPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath(), collection);
        }
        Map<String, String> fieldConversions = collectionGroup.getCollectionLookup().getFieldConversions();
        ArrayList<String> toFieldNamesColl = new ArrayList<String>(fieldConversions.values());
        Collections.sort(toFieldNamesColl);
        String[] toFieldNames = new String[toFieldNamesColl.size()];
        toFieldNamesColl.toArray(toFieldNames);
        for (String lineValue : lineValues = StringUtils.split((String)lookupResultValues, (String)",")) {
            ExternalizableBusinessObject lineDataObject = null;
            ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(collectionObjectClass);
            lineDataObject = moduleService != null && moduleService.isExternalizable(collectionObjectClass) ? moduleService.createNewObjectFromExternalizableClass(collectionObjectClass.asSubclass(ExternalizableBusinessObject.class)) : (ExternalizableBusinessObject)ObjectUtils.newInstance(collectionObjectClass);
            this.applyDefaultValuesForCollectionLine(view, model, collectionGroup, lineDataObject);
            String[] fieldValues = StringUtils.split((String)lineValue, (String)":");
            if (fieldValues.length != toFieldNames.length) {
                throw new RuntimeException("Value count passed back from multi-value lookup does not match field conversion count");
            }
            for (int i = 0; i < fieldValues.length; ++i) {
                String fieldName = toFieldNames[i];
                ObjectPropertyUtils.setPropertyValue(lineDataObject, fieldName, fieldValues[i]);
            }
            collection.add(lineDataObject);
        }
    }

    @Override
    public void buildInquiryLink(Object dataObject, String propertyName, Inquiry inquiry) {
        Inquirable inquirable = this.getViewDictionaryService().getInquirable(dataObject.getClass(), inquiry.getViewName());
        if (inquirable != null) {
            inquirable.buildInquirableLink(dataObject, propertyName, inquiry);
        } else {
            inquiry.setRender(false);
        }
    }

    @Override
    public void applyDefaultValuesForCollectionLine(View view, Object model, CollectionGroup collectionGroup, Object line) {
        List<DataField> dataFields = ComponentUtils.getComponentsOfTypeDeep(collectionGroup.getAddLineFields(), DataField.class);
        for (DataField dataField : dataFields) {
            String bindingPath = "";
            if (StringUtils.isNotBlank((CharSequence)dataField.getBindingInfo().getBindByNamePrefix())) {
                bindingPath = dataField.getBindingInfo().getBindByNamePrefix() + ".";
            }
            bindingPath = bindingPath + dataField.getBindingInfo().getBindingName();
            this.populateDefaultValueForField(view, line, dataField, bindingPath);
        }
    }

    protected void applyDefaultValues(View view, Component component, Object model) {
        if (component == null) {
            return;
        }
        if (component instanceof DataField) {
            DataField dataField = (DataField)component;
            dataField.getBindingInfo().setDefaults(view, dataField.getPropertyName());
            this.populateDefaultValueForField(view, model, dataField, dataField.getBindingInfo().getBindingPath());
        }
        List<Component> nestedComponents = component.getComponentsForLifecycle();
        if (component instanceof View) {
            nestedComponents.addAll(((View)component).getItems());
        }
        for (Component nested : nestedComponents) {
            this.applyDefaultValues(view, nested, model);
        }
    }

    protected void populateDefaultValueForField(View view, Object object, DataField dataField, String bindingPath) {
        String defaultValue = dataField.getDefaultValue();
        if (StringUtils.isBlank((CharSequence)defaultValue) && dataField.getDefaultValueFinderClass() != null) {
            ValueFinder defaultValueFinder = ObjectUtils.newInstance(dataField.getDefaultValueFinderClass());
            defaultValue = defaultValueFinder.getValue();
        }
        if (StringUtils.isNotBlank((CharSequence)defaultValue) && ObjectPropertyUtils.isWritableProperty(object, bindingPath)) {
            if (this.getExpressionEvaluatorService().containsElPlaceholder(defaultValue)) {
                Map<String, Object> context = this.getPreModelContext(view);
                defaultValue = this.getExpressionEvaluatorService().evaluateExpressionTemplate(null, context, defaultValue);
            }
            Object currentValue = ObjectPropertyUtils.getPropertyValue(object, bindingPath);
            Class<?> currentClazz = ObjectPropertyUtils.getPropertyType(object, bindingPath);
            if (currentValue == null || StringUtils.isBlank((CharSequence)currentValue.toString()) || ClassUtils.isPrimitiveOrWrapper(currentClazz)) {
                ObjectPropertyUtils.setPropertyValue(object, bindingPath, defaultValue);
            }
        }
    }

    protected void addCustomContainerComponents(View view, Object model, Container container) {
    }

    protected void performCustomInitialization(View view, Component component) {
    }

    protected void performCustomApplyModel(View view, Component component, Object model) {
    }

    protected void performCustomFinalize(View view, Component component, Object model, Component parent) {
    }

    protected void processBeforeAddLine(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
    }

    protected void processAfterAddLine(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
    }

    protected void processAfterDeleteLine(View view, CollectionGroup collectionGroup, Object model, int lineIndex) {
    }

    protected void logAndThrowRuntime(String message) {
        LOG.error(message);
        throw new RuntimeException(message);
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected ExpressionEvaluatorService getExpressionEvaluatorService() {
        if (this.expressionEvaluatorService == null) {
            this.expressionEvaluatorService = KRADServiceLocatorWeb.getExpressionEvaluatorService();
        }
        return this.expressionEvaluatorService;
    }

    public void setExpressionEvaluatorService(ExpressionEvaluatorService expressionEvaluatorService) {
        this.expressionEvaluatorService = expressionEvaluatorService;
    }

    public ViewDictionaryService getViewDictionaryService() {
        if (this.viewDictionaryService == null) {
            this.viewDictionaryService = KRADServiceLocatorWeb.getViewDictionaryService();
        }
        return this.viewDictionaryService;
    }

    public void setViewDictionaryService(ViewDictionaryService viewDictionaryService) {
        this.viewDictionaryService = viewDictionaryService;
    }
}

