/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util.documentserializer;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.WorkflowProperties;
import org.kuali.kfs.krad.datadictionary.WorkflowProperty;
import org.kuali.kfs.krad.datadictionary.WorkflowPropertyGroup;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializabilityEvaluatorBase;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializerTrie;

public class BusinessObjectPropertySerializibilityEvaluator
extends PropertySerializabilityEvaluatorBase
implements PropertySerializabilityEvaluator {
    @Override
    public void initializeEvaluatorForDocument(Document document) {
        DataDictionary dictionary = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary();
        DocumentEntry docEntry = dictionary.getDocumentEntry(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        WorkflowProperties workflowProperties = docEntry.getWorkflowProperties();
        List<WorkflowPropertyGroup> groups = workflowProperties.getWorkflowPropertyGroups();
        this.serializableProperties = new PropertySerializerTrie();
        for (WorkflowPropertyGroup group : groups) {
            if (StringUtils.isEmpty((CharSequence)group.getBasePath())) {
                this.serializableProperties.addSerializablePropertyName(document.getBasePathToDocumentDuringSerialization(), false);
            } else {
                this.serializableProperties.addSerializablePropertyName(group.getBasePath(), false);
            }
            for (WorkflowProperty property : group.getWorkflowProperties()) {
                String fullPath = StringUtils.isEmpty((CharSequence)group.getBasePath()) ? document.getBasePathToDocumentDuringSerialization() + "." + property.getPath() : group.getBasePath() + "." + property.getPath();
                this.serializableProperties.addSerializablePropertyName(fullPath, false);
            }
        }
    }
}

