/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.bind;

import java.beans.PropertyEditor;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.uif.view.ViewIndex;
import org.kuali.kfs.krad.uif.view.ViewModel;
import org.kuali.kfs.krad.web.bind.UifEncryptionPropertyEditorWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;

public class UifViewBeanWrapper
extends BeanWrapperImpl {
    private static final Logger LOG = LogManager.getLogger(UifViewBeanWrapper.class);
    private ViewModel model;
    private Set<String> processedProperties;

    public UifViewBeanWrapper(ViewModel model) {
        super((Object)model);
        this.model = model;
        this.processedProperties = new HashSet<String>();
    }

    protected void registerEditorFromView(String propertyName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to find property editor for property '" + propertyName + "'");
        }
        if (this.processedProperties.contains(propertyName)) {
            return;
        }
        ViewIndex viewIndex = null;
        if (this.model.getView() != null) {
            viewIndex = this.model.getView().getViewIndex();
        } else if (this.model.getPostedView() != null) {
            viewIndex = this.model.getPostedView().getViewIndex();
        }
        if (viewIndex == null) {
            return;
        }
        PropertyEditor propertyEditor = null;
        boolean requiresEncryption = false;
        if (viewIndex.getFieldPropertyEditors().containsKey(propertyName)) {
            propertyEditor = viewIndex.getFieldPropertyEditors().get(propertyName);
        } else if (viewIndex.getSecureFieldPropertyEditors().containsKey(propertyName)) {
            propertyEditor = viewIndex.getSecureFieldPropertyEditors().get(propertyName);
            requiresEncryption = true;
        }
        if (propertyEditor != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering custom editor for property path '" + propertyName + "' and property editor class '" + propertyEditor.getClass().getName() + "'");
            }
            if (requiresEncryption) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Enabling encryption for custom editor '" + propertyName + "' and property editor class '" + propertyEditor.getClass().getName() + "'");
                }
                this.registerCustomEditor(null, propertyName, new UifEncryptionPropertyEditorWrapper(propertyEditor));
            } else {
                this.registerCustomEditor(null, propertyName, propertyEditor);
            }
        } else if (requiresEncryption) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No custom formatter for property path '" + propertyName + "' but property does require encryption");
            }
            this.registerCustomEditor(null, propertyName, new UifEncryptionPropertyEditorWrapper(this.findEditorForPropertyName(propertyName)));
        }
        this.processedProperties.add(propertyName);
    }

    protected PropertyEditor findEditorForPropertyName(String propertyName) {
        PropertyEditor editor;
        Class clazz = this.getPropertyType(propertyName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting retrieval of property editor using class '" + clazz + "' and property path '" + propertyName + "'");
        }
        if ((editor = this.findCustomEditor(clazz, propertyName)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No custom property editor found using class '" + clazz + "' and property path '" + propertyName + "'. Attempting to find default property editor class.");
            }
            editor = this.getDefaultEditor(clazz);
        }
        return editor;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        this.registerEditorFromView(propertyName);
        return super.getPropertyValue(propertyName);
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.registerEditorFromView(pv.getName());
        super.setPropertyValue(pv);
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        this.registerEditorFromView(propertyName);
        super.setPropertyValue(propertyName, value);
    }

    public void setWrappedInstance(Object object, String nestedPath, Object rootObject) {
        this.model = (ViewModel)object;
        super.setWrappedInstance(object, nestedPath, rootObject);
    }

    public void setWrappedInstance(Object object) {
        this.model = (ViewModel)object;
        super.setWrappedInstance(object);
    }
}

