/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.controller;

import java.io.OutputStream;
import java.util.Collections;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.bo.Exporter;
import org.kuali.kfs.krad.datadictionary.DataObjectEntry;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.controller.UifControllerBase;
import org.kuali.kfs.krad.web.form.InquiryForm;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/inquiry"})
public class InquiryController
extends UifControllerBase {
    private static final Logger LOG = LogManager.getLogger(InquiryController.class);

    @Override
    protected InquiryForm createInitialForm(HttpServletRequest request) {
        return new InquiryForm();
    }

    @Override
    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (!inquiryForm.isRedirectedInquiry()) {
            Class<?> inquiryObjectClass = null;
            try {
                inquiryObjectClass = Class.forName(inquiryForm.getDataObjectClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RiceRuntimeException("Unable to get class for name: " + inquiryForm.getDataObjectClassName());
            }
            ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(inquiryObjectClass);
            if (responsibleModuleService != null && responsibleModuleService.isExternalizable(inquiryObjectClass)) {
                String inquiryUrl = responsibleModuleService.getExternalizableDataObjectInquiryUrl(inquiryObjectClass, KRADUtils.convertRequestMapToProperties(request.getParameterMap()));
                Properties redirectUrlProps = new Properties();
                redirectUrlProps.put("redirectedInquiry", "true");
                GlobalVariables.getUifFormManager().removeForm(form);
                return this.performRedirect(form, inquiryUrl, redirectUrlProps);
            }
        }
        try {
            inquiryForm.getInquirable().setDataObjectClass(Class.forName(inquiryForm.getDataObjectClassName()));
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to get new instance for object class: " + inquiryForm.getDataObjectClassName(), (Throwable)e);
            throw new RuntimeException("Unable to get new instance for object class: " + inquiryForm.getDataObjectClassName(), e);
        }
        Object dataObject = inquiryForm.getInquirable().retrieveDataObject(KRADUtils.translateRequestParameterMap(request.getParameterMap()));
        inquiryForm.setDataObject(dataObject);
        return super.start(form, result, request, response);
    }

    @RequestMapping(params={"methodToCall=export"})
    public ModelAndView export(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DataObjectEntry dataObjectEntry;
        Class<? extends Exporter> exporterClass;
        InquiryForm inquiryForm = (InquiryForm)form;
        Object dataObject = inquiryForm.getDataObject();
        if (dataObject != null && (exporterClass = (dataObjectEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDataObjectEntry(inquiryForm.getDataObjectClassName())).getExporterClass()) != null) {
            Exporter exporter = exporterClass.newInstance();
            response.setContentType("application/xml");
            response.setHeader("Content-disposition", "attachment; filename=export.xml");
            exporter.export(dataObjectEntry.getDataObjectClass(), Collections.singletonList(dataObject), "xml", (OutputStream)response.getOutputStream());
        }
        return null;
    }
}

