/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.exception.AuthorizationException;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.field.AttributeQueryResult;
import org.kuali.kfs.krad.uif.service.ViewService;
import org.kuali.kfs.krad.uif.util.ComponentFactory;
import org.kuali.kfs.krad.uif.util.LookupInquiryUtils;
import org.kuali.kfs.krad.uif.util.UifFormManager;
import org.kuali.kfs.krad.uif.util.UifWebUtils;
import org.kuali.kfs.krad.uif.view.History;
import org.kuali.kfs.krad.uif.view.HistoryEntry;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

public abstract class UifControllerBase {
    private static final Logger LOG = LogManager.getLogger(UifControllerBase.class);
    protected static final String REDIRECT_PREFIX = "redirect:";

    @ModelAttribute(value="KualiForm")
    public final UifFormBase initForm(HttpServletRequest request) {
        UifFormBase form = null;
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        if (uifFormManager == null) {
            uifFormManager = new UifFormManager();
            request.getSession().setAttribute("formManager", (Object)uifFormManager);
        }
        GlobalVariables.setUifFormManager(uifFormManager);
        String formKeyParam = request.getParameter("formKey");
        if (StringUtils.isNotBlank((CharSequence)formKeyParam)) {
            form = uifFormManager.getForm(formKeyParam);
        }
        if (form == null) {
            form = this.createInitialForm(request);
        }
        uifFormManager.setCurrentForm(form);
        return form;
    }

    protected abstract UifFormBase createInitialForm(HttpServletRequest var1);

    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        if (form.getView() != null) {
            String methodToCall = request.getParameter("methodToCall");
            this.checkViewAuthorization(form, methodToCall);
        }
        return this.getUIFModelAndView(form);
    }

    public void checkViewAuthorization(UifFormBase form, String methodToCall) throws AuthorizationException {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean canOpenView = form.getView().getAuthorizer().canOpenView(form.getView(), form, user);
        if (!canOpenView) {
            throw new AuthorizationException(user.getPrincipalName(), "open", form.getView().getId(), "User '" + user.getPrincipalName() + "' is not authorized to open view ID: " + form.getView().getId(), null);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=addLine"})
    public ModelAndView addLine(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionPath = uifForm.getActionParamaterValue("selectedCollectionPath");
        if (StringUtils.isBlank((CharSequence)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection was not set for add line action, cannot add new line");
        }
        View view = uifForm.getPostedView();
        view.getViewHelperService().processCollectionAddLine(view, uifForm, selectedCollectionPath);
        return this.updateComponent(uifForm, result, request, response);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=deleteLine"})
    public ModelAndView deleteLine(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionPath = uifForm.getActionParamaterValue("selectedCollectionPath");
        if (StringUtils.isBlank((CharSequence)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection was not set for delete line action, cannot delete line");
        }
        int selectedLineIndex = -1;
        String selectedLine = uifForm.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotBlank((CharSequence)selectedLine)) {
            selectedLineIndex = Integer.parseInt(selectedLine);
        }
        if (selectedLineIndex == -1) {
            throw new RuntimeException("Selected line index was not set for delete line action, cannot delete line");
        }
        View view = uifForm.getPostedView();
        view.getViewHelperService().processCollectionDeleteLine(view, uifForm, selectedCollectionPath, selectedLineIndex);
        return this.updateComponent(uifForm, result, request, response);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=toggleInactiveRecordDisplay"})
    public ModelAndView toggleInactiveRecordDisplay(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String collectionGroupId = request.getParameter("reqComponentId");
        if (StringUtils.isBlank((CharSequence)collectionGroupId)) {
            throw new RuntimeException("Collection group id to update for inactive record display not found in request");
        }
        String showInactiveStr = request.getParameter("showInactiveRecords");
        Boolean showInactive = false;
        if (!StringUtils.isNotBlank((CharSequence)showInactiveStr)) {
            throw new RuntimeException("Show inactive records flag not found in request");
        }
        showInactive = (Boolean)new BooleanFormatter().convertFromPresentationFormat((Object)showInactiveStr);
        CollectionGroup collectionGroup = (CollectionGroup)ComponentFactory.getNewInstanceForRefresh(uifForm.getPostedView(), collectionGroupId);
        collectionGroup.setShowInactive(showInactive);
        uifForm.getPostedView().getViewHelperService().performComponentLifecycle(uifForm.getPostedView(), uifForm, collectionGroup, collectionGroupId);
        return UifWebUtils.getComponentModelAndView(collectionGroup, uifForm);
    }

    @RequestMapping(params={"methodToCall=cancel"})
    public ModelAndView cancel(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.close(form, result, request, response);
    }

    @RequestMapping(params={"methodToCall=close"})
    public ModelAndView close(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String returnUrl;
        Properties props = new Properties();
        props.put("methodToCall", "refresh");
        if (StringUtils.isNotBlank((CharSequence)form.getReturnFormKey())) {
            props.put("formKey", form.getReturnFormKey());
        }
        if (StringUtils.isBlank((CharSequence)(returnUrl = form.getReturnLocation()))) {
            returnUrl = ConfigContext.getCurrentContextConfig().getProperty("application.url");
        }
        GlobalVariables.getUifFormManager().removeForm(form);
        return this.performRedirect(form, returnUrl, props);
    }

    @RequestMapping(params={"methodToCall=returnToPrevious"})
    public ModelAndView returnToPrevious(@ModelAttribute(value="KualiForm") UifFormBase form) {
        return this.returnToHistory(form, false);
    }

    @RequestMapping(params={"methodToCall=returnToHub"})
    public ModelAndView returnToHub(@ModelAttribute(value="KualiForm") UifFormBase form) {
        return this.returnToHistory(form, true);
    }

    public ModelAndView returnToHistory(UifFormBase form, boolean homeFlag) {
        History hist = form.getFormHistory();
        List<HistoryEntry> histEntries = hist.getHistoryEntries();
        String histUrl = null;
        if (histEntries.isEmpty()) {
            histUrl = ConfigContext.getCurrentContextConfig().getProperty("application.url");
        } else if (homeFlag) {
            histUrl = histEntries.get(0).getUrl();
            histEntries.clear();
        } else {
            histUrl = histEntries.get(histEntries.size() - 1).getUrl();
            histEntries.remove(histEntries.size() - 1);
            hist.setCurrent(null);
        }
        Properties props = new Properties();
        props.put("methodToCall", "refresh");
        GlobalVariables.getUifFormManager().removeForm(form);
        return this.performRedirect(form, histUrl, props);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=navigate"})
    public ModelAndView navigate(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String pageId = form.getActionParamaterValue("navigateToPageId");
        form.setRenderFullView(false);
        return this.getUIFModelAndView(form, pageId);
    }

    @RequestMapping(params={"methodToCall=refresh"})
    public ModelAndView refresh(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String refreshCallerType = "";
        if (request.getParameterMap().containsKey("refreshCallerType")) {
            refreshCallerType = request.getParameter("refreshCallerType");
        }
        if (StringUtils.equals((CharSequence)refreshCallerType, (CharSequence)"MULTI_VALUE_LOOKUP")) {
            String lookupCollectionName = "";
            if (request.getParameterMap().containsKey("lookupCollectionName")) {
                lookupCollectionName = request.getParameter("lookupCollectionName");
            }
            if (StringUtils.isBlank((CharSequence)lookupCollectionName)) {
                throw new RuntimeException("Lookup collection name is required for processing multi-value lookup results");
            }
            String selectedLineValues = "";
            if (request.getParameterMap().containsKey("selectedLineValues")) {
                selectedLineValues = request.getParameter("selectedLineValues");
            }
            form.getPostedView().getViewHelperService().processMultipleValueLookupResults(form.getPostedView(), form, lookupCollectionName, selectedLineValues);
        }
        if (request.getParameterMap().containsKey("renderFullView")) {
            form.setRenderFullView(Boolean.parseBoolean(request.getParameter("renderFullView")));
        } else {
            form.setRenderFullView(true);
        }
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=updateComponent"})
    public ModelAndView updateComponent(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String requestedComponentId = request.getParameter("reqComponentId");
        if (StringUtils.isBlank((CharSequence)requestedComponentId)) {
            throw new RuntimeException("Requested component id for update not found in request");
        }
        Component comp = ComponentFactory.getNewInstanceForRefresh(form.getPostedView(), requestedComponentId);
        View postedView = form.getPostedView();
        postedView.getViewHelperService().performComponentLifecycle(postedView, form, comp, requestedComponentId);
        postedView.getCurrentPage().getErrorsField().setDisplayNestedMessages(true);
        postedView.getCurrentPage().getErrorsField().generateMessages(false, postedView, form, postedView.getCurrentPage());
        return UifWebUtils.getComponentModelAndView(comp, form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=performLookup"})
    public ModelAndView performLookup(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ModuleService responsibleModuleService;
        Properties lookupParameters = form.getActionParametersAsProperties();
        String lookupObjectClassName = (String)lookupParameters.get("dataObjectClassName");
        Class<?> lookupObjectClass = null;
        try {
            lookupObjectClass = Class.forName(lookupObjectClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to get class for name: " + lookupObjectClassName);
            throw new RuntimeException("Unable to get class for name: " + lookupObjectClassName, e);
        }
        String lookupParameterString = (String)lookupParameters.get("lookupParameters");
        if (lookupParameterString != null) {
            Map<String, String> lookupParameterFields = KRADUtils.getMapFromParameterString(lookupParameterString);
            for (Map.Entry<String, String> lookupParameter : lookupParameterFields.entrySet()) {
                String lookupParameterValue = LookupInquiryUtils.retrieveLookupParameterValue(form, request, lookupObjectClass, lookupParameter.getValue(), lookupParameter.getKey());
                if (!StringUtils.isNotBlank((CharSequence)lookupParameterValue)) continue;
                lookupParameters.put("criteriaFields['" + lookupParameter.getValue() + "']", lookupParameterValue);
            }
        }
        String baseLookupUrl = (String)lookupParameters.get("baseLookupUrl");
        lookupParameters.remove("baseLookupUrl");
        lookupParameters.put("methodToCall", "start");
        String autoSearchString = (String)lookupParameters.get("autoSearch");
        if (Boolean.parseBoolean(autoSearchString)) {
            lookupParameters.put("methodToCall", "search");
        }
        lookupParameters.put("returnLocation", form.getFormPostUrl());
        lookupParameters.put("returnFormKey", form.getFormKey());
        if (lookupObjectClass != null && (responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(lookupObjectClass)) != null && responsibleModuleService.isExternalizable(lookupObjectClass)) {
            String lookupUrl = responsibleModuleService.getExternalizableDataObjectLookupUrl(lookupObjectClass, lookupParameters);
            Properties externalInquiryProperties = new Properties();
            if (lookupParameters.containsKey("lightBoxCall")) {
                externalInquiryProperties.put("lightBoxCall", lookupParameters.get("lightBoxCall"));
            }
            return this.performRedirect(form, lookupUrl, externalInquiryProperties);
        }
        return this.performRedirect(form, baseLookupUrl, lookupParameters);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=performFieldSuggest"})
    @ResponseBody
    public AttributeQueryResult performFieldSuggest(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (Object parameterName : request.getParameterMap().keySet()) {
            if (!parameterName.toString().startsWith("queryParameter.")) continue;
            String fieldName = StringUtils.substringAfter((String)parameterName.toString(), (String)"queryParameter.");
            String fieldValue = request.getParameter(parameterName.toString());
            queryParameters.put(fieldName, fieldValue);
        }
        String queryFieldId = request.getParameter("queryFieldId");
        if (StringUtils.isBlank((CharSequence)queryFieldId)) {
            throw new RuntimeException("Unable to find id for field to perform query on under request parameter name: queryFieldId");
        }
        String queryTerm = request.getParameter("queryTerm");
        if (StringUtils.isBlank((CharSequence)queryTerm)) {
            throw new RuntimeException("Unable to find id for query term value for attribute query on under request parameter name: queryTerm");
        }
        AttributeQueryResult queryResult = KRADServiceLocatorWeb.getAttributeQueryService().performFieldSuggestQuery(form.getPostedView(), queryFieldId, queryTerm, queryParameters);
        return queryResult;
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=performFieldQuery"})
    @ResponseBody
    public AttributeQueryResult performFieldQuery(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (Object parameterName : request.getParameterMap().keySet()) {
            if (!parameterName.toString().startsWith("queryParameter.")) continue;
            String fieldName = StringUtils.substringAfter((String)parameterName.toString(), (String)"queryParameter.");
            String fieldValue = request.getParameter(parameterName.toString());
            queryParameters.put(fieldName, fieldValue);
        }
        String queryFieldId = request.getParameter("queryFieldId");
        if (StringUtils.isBlank((CharSequence)queryFieldId)) {
            throw new RuntimeException("Unable to find id for field to perform query on under request parameter name: queryFieldId");
        }
        AttributeQueryResult queryResult = KRADServiceLocatorWeb.getAttributeQueryService().performFieldQuery(form.getPostedView(), queryFieldId, queryParameters);
        return queryResult;
    }

    protected ModelAndView performRedirect(UifFormBase form, String baseUrl, Properties urlParameters) {
        form.setView(form.getPostedView());
        urlParameters.setProperty("history", form.getFormHistory().getHistoryParameterString());
        if (urlParameters.get("lightBoxCall") != null && urlParameters.get("lightBoxCall").equals("true")) {
            urlParameters.remove("lightBoxCall");
            String redirectUrl = UrlFactory.parameterizeUrl(baseUrl, urlParameters);
            ModelAndView modelAndView = new ModelAndView("redirectURL");
            modelAndView.addObject("redirectUrl", (Object)redirectUrl);
            return modelAndView;
        }
        String redirectUrl = UrlFactory.parameterizeUrl(baseUrl, urlParameters);
        ModelAndView modelAndView = new ModelAndView(REDIRECT_PREFIX + redirectUrl);
        return modelAndView;
    }

    protected ModelAndView getUIFModelAndView(UifFormBase form) {
        return this.getUIFModelAndView(form, form.getPageId());
    }

    protected ModelAndView getUIFModelAndView(UifFormBase form, String pageId) {
        return UifWebUtils.getUIFModelAndView(form, pageId);
    }

    protected ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }
}

