/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.api.preferences.PreferencesService;

public class UserPreferencesFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(UserPreferencesFilter.class);
    private FilterConfig filterConfig;
    private PreferencesService preferencesService;

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserSession session = KRADUtils.getUserSessionFromRequest(request);
        if (session == null) {
            throw new IllegalStateException("A user session has not been established");
        }
        String principalId = session.getPrincipalId();
        if (session.retrieveObject("Preferences") == null) {
            Preferences preferences = this.retrievePreferences(principalId);
            session.addObject("Preferences", preferences);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        this.filterConfig = null;
    }

    private Preferences retrievePreferences(String principalId) {
        Preferences preferences = this.getPreferenceService().getPreferences(principalId);
        if (preferences.isRequiresSave()) {
            LOG.info((Object)"Detected that user preferences require saving.");
            this.getPreferenceService().savePreferences(principalId, preferences);
            preferences = this.getPreferenceService().getPreferences(principalId);
        }
        return preferences;
    }

    private PreferencesService getPreferenceService() {
        if (this.preferencesService == null) {
            this.preferencesService = KewApiServiceLocator.getPreferencesService();
        }
        return this.preferencesService;
    }
}

