/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.form;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.lookup.LookupUtils;
import org.kuali.kfs.krad.lookup.Lookupable;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.view.LookupView;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.form.UifFormBase;

public class LookupForm
extends UifFormBase {
    private static final long serialVersionUID = -7323484966538685327L;
    private static final Logger LOG = LogManager.getLogger(LookupForm.class);
    private String dataObjectClassName;
    private String docNum;
    private String referencesToRefresh;
    private boolean multipleValuesSelect;
    private String lookupCollectionName;
    private Map<String, String> criteriaFields;
    private Map<String, String> fieldConversions;
    private boolean atLeastOneRowReturnable;
    private boolean atLeastOneRowHasActions;
    private Collection<?> searchResults;
    private boolean redirectedLookup;

    public LookupForm() {
        this.setViewTypeName(UifConstants.ViewType.LOOKUP);
        this.atLeastOneRowReturnable = false;
        this.atLeastOneRowHasActions = false;
        this.multipleValuesSelect = false;
        this.redirectedLookup = false;
        this.criteriaFields = new HashMap<String, String>();
        this.fieldConversions = new HashMap<String, String>();
    }

    @Override
    public void postBind(HttpServletRequest request) {
        super.postBind(request);
        try {
            Lookupable lookupable = this.getLookupable();
            if (lookupable == null) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)this.getDataObjectClassName())) {
                this.setDataObjectClassName(((LookupView)this.getView()).getDataObjectClassName().getName());
            }
            Class<?> dataObjectClass = Class.forName(this.getDataObjectClassName());
            lookupable.setDataObjectClass(dataObjectClass);
            if (!((LookupView)this.getView()).isShowMaintenanceLinks() && (StringUtils.contains((CharSequence)this.getReturnLocation(), (CharSequence)"/portal.do") || StringUtils.contains((CharSequence)this.getReturnLocation(), (CharSequence)"/index.html"))) {
                ((LookupView)this.getView()).setShowMaintenanceLinks(true);
            }
            lookupable.setReadOnlyFieldsList(this.getReadOnlyFieldsList());
            if (request.getParameter("conversionFields") != null) {
                String conversionFields = request.getParameter("conversionFields");
                this.setFieldConversions(KRADUtils.convertStringParameterToMap(conversionFields));
                lookupable.setFieldConversions(this.getFieldConversions());
            }
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            Map<String, String> formFields = this.getCriteriaFields();
            if (formFields != null) {
                for (Map.Entry<String, String> entry : formFields.entrySet()) {
                    fieldValues.put(entry.getKey(), LookupUtils.forceUppercase(dataObjectClass, entry.getKey(), entry.getValue()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.getDocNum())) {
                fieldValues.put("docNum", this.getDocNum());
            }
            this.setCriteriaFields(fieldValues);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Object class " + this.getDataObjectClassName() + " not found");
            throw new RuntimeException("Object class " + this.getDataObjectClassName() + " not found", e);
        }
    }

    public Lookupable getLookupable() {
        if (this.getView() != null && Lookupable.class.isAssignableFrom(this.getView().getViewHelperService().getClass())) {
            return (Lookupable)this.getView().getViewHelperService();
        }
        return null;
    }

    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    public String getDocNum() {
        return this.docNum;
    }

    public void setDocNum(String docNum) {
        this.docNum = docNum;
    }

    public String getReferencesToRefresh() {
        return this.referencesToRefresh;
    }

    public void setReferencesToRefresh(String referencesToRefresh) {
        this.referencesToRefresh = referencesToRefresh;
    }

    public boolean isMultipleValuesSelect() {
        return this.multipleValuesSelect;
    }

    public void setMultipleValuesSelect(boolean multipleValuesSelect) {
        this.multipleValuesSelect = multipleValuesSelect;
    }

    public String getLookupCollectionName() {
        return this.lookupCollectionName;
    }

    public void setLookupCollectionName(String lookupCollectionName) {
        this.lookupCollectionName = lookupCollectionName;
    }

    public Map<String, String> getCriteriaFields() {
        return this.criteriaFields;
    }

    public void setCriteriaFields(Map<String, String> criteriaFields) {
        this.criteriaFields = criteriaFields;
    }

    public Map<String, String> getFieldConversions() {
        return this.fieldConversions;
    }

    public void setFieldConversions(Map<String, String> fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    public Collection<?> getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(Collection<?> searchResults) {
        this.searchResults = searchResults;
    }

    public boolean isAtLeastOneRowReturnable() {
        return this.atLeastOneRowReturnable;
    }

    public void setAtLeastOneRowReturnable(boolean atLeastOneRowReturnable) {
        this.atLeastOneRowReturnable = atLeastOneRowReturnable;
    }

    public boolean isAtLeastOneRowHasActions() {
        return this.atLeastOneRowHasActions;
    }

    public void setAtLeastOneRowHasActions(boolean atLeastOneRowHasActions) {
        this.atLeastOneRowHasActions = atLeastOneRowHasActions;
    }

    public boolean isRedirectedLookup() {
        return this.redirectedLookup;
    }

    public void setRedirectedLookup(boolean redirectedLookup) {
        this.redirectedLookup = redirectedLookup;
    }
}

