/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.form;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.service.ViewService;
import org.kuali.kfs.krad.uif.view.History;
import org.kuali.kfs.krad.uif.view.HistoryEntry;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.view.ViewModel;
import org.kuali.kfs.krad.util.KRADUtils;
import org.springframework.web.multipart.MultipartFile;

public class UifFormBase
implements ViewModel {
    private static final long serialVersionUID = 8432543267099454434L;
    private static final Log LOG = LogFactory.getLog(UifFormBase.class);
    protected String viewId;
    protected String viewName;
    protected UifConstants.ViewType viewTypeName;
    protected String pageId;
    protected String methodToCall;
    protected String formKey = this.generateFormKey();
    protected String jumpToId;
    protected String jumpToName;
    protected String focusId;
    protected String formPostUrl;
    protected boolean defaultsApplied = false;
    protected boolean skipViewInit = false;
    protected View view;
    protected View postedView;
    protected Map<String, String> viewRequestParameters;
    protected List<String> readOnlyFieldsList;
    protected Map<String, Object> newCollectionLines;
    protected Map<String, String> actionParameters;
    protected Map<String, Object> clientStateForSyncing;
    protected Map<String, Set<String>> selectedCollectionLines;
    protected MultipartFile attachmentFile;
    protected String returnLocation;
    protected String returnFormKey;
    protected History formHistory = new History();
    protected boolean renderFullView = true;
    protected boolean validateDirty;
    protected String csrfToken;

    public UifFormBase() {
        this.readOnlyFieldsList = new ArrayList<String>();
        this.viewRequestParameters = new HashMap<String, String>();
        this.newCollectionLines = new HashMap<String, Object>();
        this.actionParameters = new HashMap<String, String>();
        this.clientStateForSyncing = new HashMap<String, Object>();
        this.selectedCollectionLines = new HashMap<String, Set<String>>();
    }

    protected String generateFormKey() {
        return UUID.randomUUID().toString();
    }

    public void postBind(HttpServletRequest request) {
        String clientStateJSON;
        this.formPostUrl = request.getRequestURL().toString();
        if (request.getParameterMap().containsKey("clientViewState") && StringUtils.isNotBlank((CharSequence)(clientStateJSON = request.getParameter("clientViewState")))) {
            clientStateJSON = StringUtils.replace((String)clientStateJSON, (String)"'", (String)"\"");
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.clientStateForSyncing = (Map)mapper.readValue(clientStateJSON, Map.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to decode client side state JSON", e);
            }
        }
        if (request.getParameter("readOnlyFields") != null) {
            String readOnlyFields = request.getParameter("readOnlyFields");
            this.setReadOnlyFieldsList(KRADUtils.convertStringParameterToList(readOnlyFields));
        }
        if (!request.getParameterMap().containsKey("skipViewInit")) {
            this.skipViewInit = false;
        }
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public UifConstants.ViewType getViewTypeName() {
        return this.viewTypeName;
    }

    @Override
    public void setViewTypeName(UifConstants.ViewType viewTypeName) {
        this.viewTypeName = viewTypeName;
    }

    @Override
    public String getPageId() {
        return this.pageId;
    }

    @Override
    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    @Override
    public String getFormPostUrl() {
        return this.formPostUrl;
    }

    @Override
    public void setFormPostUrl(String formPostUrl) {
        this.formPostUrl = formPostUrl;
    }

    public String getReturnLocation() {
        return this.returnLocation;
    }

    public void setReturnLocation(String returnLocation) {
        this.returnLocation = returnLocation;
    }

    public String getReturnFormKey() {
        return this.returnFormKey;
    }

    public void setReturnFormKey(String returnFormKey) {
        this.returnFormKey = returnFormKey;
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    @Override
    public Map<String, String> getViewRequestParameters() {
        return this.viewRequestParameters;
    }

    @Override
    public void setViewRequestParameters(Map<String, String> viewRequestParameters) {
        this.viewRequestParameters = viewRequestParameters;
    }

    @Override
    public List<String> getReadOnlyFieldsList() {
        return this.readOnlyFieldsList;
    }

    @Override
    public void setReadOnlyFieldsList(List<String> readOnlyFieldsList) {
        this.readOnlyFieldsList = readOnlyFieldsList;
    }

    @Override
    public Map<String, Object> getNewCollectionLines() {
        return this.newCollectionLines;
    }

    @Override
    public void setNewCollectionLines(Map<String, Object> newCollectionLines) {
        this.newCollectionLines = newCollectionLines;
    }

    @Override
    public Map<String, String> getActionParameters() {
        return this.actionParameters;
    }

    public Properties getActionParametersAsProperties() {
        return KRADUtils.convertMapToProperties(this.actionParameters);
    }

    @Override
    public void setActionParameters(Map<String, String> actionParameters) {
        this.actionParameters = actionParameters;
    }

    public String getActionParamaterValue(String actionParameterName) {
        if (this.actionParameters != null && this.actionParameters.containsKey(actionParameterName)) {
            return this.actionParameters.get(actionParameterName);
        }
        return "";
    }

    public String getActionEvent() {
        if (this.actionParameters != null && this.actionParameters.containsKey("actionEvent")) {
            return this.actionParameters.get("actionEvent");
        }
        return "";
    }

    @Override
    public Map<String, Object> getClientStateForSyncing() {
        return this.clientStateForSyncing;
    }

    @Override
    public Map<String, Set<String>> getSelectedCollectionLines() {
        return this.selectedCollectionLines;
    }

    @Override
    public void setSelectedCollectionLines(Map<String, Set<String>> selectedCollectionLines) {
        this.selectedCollectionLines = selectedCollectionLines;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    @Override
    public boolean isDefaultsApplied() {
        return this.defaultsApplied;
    }

    @Override
    public void setDefaultsApplied(boolean defaultsApplied) {
        this.defaultsApplied = defaultsApplied;
    }

    public boolean isSkipViewInit() {
        return this.skipViewInit;
    }

    public void setSkipViewInit(boolean skipViewInit) {
        this.skipViewInit = skipViewInit;
    }

    public MultipartFile getAttachmentFile() {
        return this.attachmentFile;
    }

    public void setAttachmentFile(MultipartFile attachmentFile) {
        this.attachmentFile = attachmentFile;
    }

    public boolean isRenderFullView() {
        return this.renderFullView;
    }

    public void setRenderFullView(boolean renderFullView) {
        this.renderFullView = renderFullView;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public void setView(View view) {
        this.view = view;
        this.initHomewardPathList();
    }

    private void initHomewardPathList() {
        if (this.getReturnLocation() == null) {
            LOG.warn((Object)"Could not init homewardPathList.  returnLocation is null.");
            return;
        }
        List<Object> homewardPathList = new ArrayList();
        if (this.view != null && this.view.getBreadcrumbs() != null && this.view.getBreadcrumbs().getHomewardPathList() != null) {
            homewardPathList = this.view.getBreadcrumbs().getHomewardPathList();
        }
        HistoryEntry historyEntry = new HistoryEntry("", "", "Home", this.getReturnLocation(), "");
        if (homewardPathList.isEmpty()) {
            homewardPathList.add(historyEntry);
        } else if (StringUtils.equals((CharSequence)((HistoryEntry)homewardPathList.get(0)).getTitle(), (CharSequence)"Home")) {
            homewardPathList.set(0, historyEntry);
        } else {
            homewardPathList.add(0, historyEntry);
        }
    }

    @Override
    public View getPostedView() {
        return this.postedView;
    }

    @Override
    public void setPostedView(View postedView) {
        this.postedView = postedView;
    }

    protected ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }

    public String getJumpToId() {
        return this.jumpToId;
    }

    public void setJumpToId(String jumpToId) {
        this.jumpToId = jumpToId;
    }

    public String getJumpToName() {
        return this.jumpToName;
    }

    public void setJumpToName(String jumpToName) {
        this.jumpToName = jumpToName;
    }

    public String getFocusId() {
        return this.focusId;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public History getFormHistory() {
        return this.formHistory;
    }

    public void setFormHistory(History history) {
        this.formHistory = history;
    }

    public boolean isValidateDirty() {
        return this.validateDirty;
    }

    public void setValidateDirty(boolean validateDirty) {
        this.validateDirty = validateDirty;
    }

    public String getCsrfToken() {
        return this.csrfToken;
    }

    public void setCsrfToken(String csrfToken) {
        this.csrfToken = csrfToken;
    }
}

