/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.impl.style;

import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.api.style.Style;
import org.kuali.kfs.coreservice.api.style.StyleRepositoryService;
import org.kuali.kfs.coreservice.api.style.StyleService;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.coreservice.impl.style.StyleUriResolver;

public class StyleServiceImpl
implements StyleService {
    private static final Logger LOG = LogManager.getLogger(StyleServiceImpl.class);
    private StyleRepositoryService styleRepositoryService;

    public void setStyleRepositoryService(StyleRepositoryService styleRepositoryService) {
        this.styleRepositoryService = styleRepositoryService;
    }

    @Override
    public Style getStyle(String styleName) {
        return this.styleRepositoryService.getStyle(styleName);
    }

    @Override
    public Templates getStyleAsTranslet(String name) throws TransformerConfigurationException {
        if (name == null) {
            return null;
        }
        Style style = this.getStyle(name);
        if (style == null) {
            return null;
        }
        boolean useXSLTC = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "EDocLite", "USE_XSLTC_IND");
        if (useXSLTC) {
            LOG.info("using xsltc to compile stylesheet");
            String key = "javax.xml.transform.TransformerFactory";
            String value = "org.apache.xalan.xsltc.trax.TransformerFactoryImpl";
            Properties props = System.getProperties();
            props.put(key, value);
            System.setProperties(props);
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver(new StyleUriResolver(this));
        if (useXSLTC) {
            factory.setAttribute("translet-name", name);
            factory.setAttribute("generate-translet", Boolean.TRUE);
            String debugTransform = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "EDocLite", "DEBUG_TRANSFORM_IND");
            if (debugTransform.trim().equals("Y")) {
                factory.setAttribute("debug", Boolean.TRUE);
            }
        }
        return factory.newTemplates(new StreamSource(new StringReader(style.getXmlContent())));
    }

    @Override
    public void saveStyle(Style style) {
        this.styleRepositoryService.saveStyle(style);
    }

    @Override
    public List<String> getAllStyleNames() {
        return this.styleRepositoryService.getAllStyleNames();
    }
}

