/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.bo.authorization;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.kns.authorization.BusinessObjectAuthorizer;
import org.kuali.kfs.krad.bo.DataObjectAuthorizerBase;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.rice.krad.bo.BusinessObject;

public class BusinessObjectAuthorizerBase
extends DataObjectAuthorizerBase
implements BusinessObjectAuthorizer {
    private static final long serialVersionUID = -6315759348728853851L;
    private static KualiModuleService kualiModuleService;
    private static DataDictionaryService dataDictionaryService;

    protected final boolean permissionExistsByTemplate(BusinessObject businessObject, String namespaceCode, String permissionTemplateName) {
        return BusinessObjectAuthorizerBase.getPermissionService().isPermissionDefinedByTemplate(namespaceCode, permissionTemplateName, new HashMap<String, String>(this.getPermissionDetailValues(businessObject)));
    }

    protected final boolean permissionExistsByTemplate(BusinessObject businessObject, String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails) {
        HashMap<String, String> combinedPermissionDetails = new HashMap<String, String>(this.getPermissionDetailValues(businessObject));
        combinedPermissionDetails.putAll(permissionDetails);
        return BusinessObjectAuthorizerBase.getPermissionService().isPermissionDefinedByTemplate(namespaceCode, permissionTemplateName, combinedPermissionDetails);
    }

    @Override
    public final boolean isAuthorized(BusinessObject businessObject, String namespaceCode, String permissionName, String principalId) {
        return BusinessObjectAuthorizerBase.getPermissionService().isAuthorized(principalId, namespaceCode, permissionName, new HashMap<String, String>(this.getRoleQualification(businessObject, principalId)));
    }

    @Override
    public final boolean isAuthorizedByTemplate(BusinessObject dataObject, String namespaceCode, String permissionTemplateName, String principalId) {
        return BusinessObjectAuthorizerBase.getPermissionService().isAuthorizedByTemplate(principalId, namespaceCode, permissionTemplateName, new HashMap<String, String>(this.getPermissionDetailValues(dataObject)), new HashMap<String, String>(this.getRoleQualification(dataObject, principalId)));
    }

    @Override
    public final boolean isAuthorized(BusinessObject businessObject, String namespaceCode, String permissionName, String principalId, Map<String, String> collectionOrFieldLevelPermissionDetails, Map<String, String> collectionOrFieldLevelRoleQualification) {
        HashMap<String, String> roleQualifiers;
        if (collectionOrFieldLevelRoleQualification != null) {
            roleQualifiers = new HashMap<String, String>(this.getRoleQualification(businessObject, principalId));
            roleQualifiers.putAll(collectionOrFieldLevelRoleQualification);
        } else {
            roleQualifiers = new HashMap<String, String>(this.getRoleQualification(businessObject, principalId));
        }
        return BusinessObjectAuthorizerBase.getPermissionService().isAuthorized(principalId, namespaceCode, permissionName, roleQualifiers);
    }

    protected final Map<String, String> getRoleQualification(BusinessObject primaryBusinessObjectOrDocument) {
        return this.getRoleQualification(primaryBusinessObjectOrDocument, GlobalVariables.getUserSession().getPerson().getPrincipalId());
    }

    @Override
    public Map<String, String> getCollectionItemPermissionDetails(BusinessObject collectionItemBusinessObject) {
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> getCollectionItemRoleQualifications(BusinessObject collectionItemBusinessObject) {
        return new HashMap<String, String>();
    }

    protected static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    protected static DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return dataDictionaryService;
    }
}

