/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.datadictionary.CollectionDefinitionI;
import org.kuali.kfs.kns.datadictionary.FieldDefinitionI;
import org.kuali.kfs.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.rice.krad.bo.BusinessObject;

public class MaintainableCollectionDefinition
extends MaintainableItemDefinition
implements CollectionDefinitionI {
    private static final long serialVersionUID = -5617868782623587053L;
    protected Class<? extends BusinessObject> businessObjectClass;
    protected Class<? extends BusinessObject> sourceClassName;
    protected String summaryTitle;
    protected String attributeToHighlightOnDuplicateKey;
    protected boolean includeAddLine = true;
    protected boolean includeMultipleLookupLine = true;
    private boolean alwaysAllowCollectionDeletion = false;
    protected Map<String, MaintainableFieldDefinition> maintainableFieldMap = new HashMap<String, MaintainableFieldDefinition>();
    protected Map<String, MaintainableCollectionDefinition> maintainableCollectionMap = new HashMap<String, MaintainableCollectionDefinition>();
    protected Map<String, MaintainableFieldDefinition> summaryFieldMap = new HashMap<String, MaintainableFieldDefinition>();
    protected Map<String, MaintainableFieldDefinition> duplicateIdentificationFieldMap = new HashMap<String, MaintainableFieldDefinition>();
    protected List<MaintainableFieldDefinition> maintainableFields = new ArrayList<MaintainableFieldDefinition>();
    protected List<MaintainableCollectionDefinition> maintainableCollections = new ArrayList<MaintainableCollectionDefinition>();
    protected List<MaintainableFieldDefinition> summaryFields = new ArrayList<MaintainableFieldDefinition>();
    protected List<MaintainableFieldDefinition> duplicateIdentificationFields = new ArrayList<MaintainableFieldDefinition>();

    @Override
    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        this.businessObjectClass = businessObjectClass;
    }

    public List<MaintainableFieldDefinition> getMaintainableFields() {
        return this.maintainableFields;
    }

    @Override
    public List<? extends FieldDefinitionI> getFields() {
        return this.maintainableFields;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        if (!DataDictionary.isCollectionPropertyOf(rootBusinessObjectClass, this.getName())) {
            throw new AttributeValidationException("unable to find collection named '" + this.getName() + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
        if (this.dissallowDuplicateKey() && !DataDictionary.isPropertyOf(this.businessObjectClass, this.attributeToHighlightOnDuplicateKey)) {
            throw new AttributeValidationException("unable to find attribute named '" + this.attributeToHighlightOnDuplicateKey + "'in dataObjectClass '" + this.businessObjectClass.getName() + "' of collection '" + this.getName() + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
        for (MaintainableFieldDefinition maintainableField : this.maintainableFields) {
            maintainableField.completeValidation((Class)this.businessObjectClass, (Class)null);
        }
        for (MaintainableCollectionDefinition maintainableCollection : this.maintainableCollections) {
            maintainableCollection.completeValidation((Class)this.businessObjectClass, (Class)null);
        }
    }

    @Override
    public String toString() {
        return "MaintainableCollectionDefinition for " + this.getName();
    }

    public Class<? extends BusinessObject> getSourceClassName() {
        return this.sourceClassName;
    }

    public void setSourceClassName(Class<? extends BusinessObject> sourceClass) {
        this.sourceClassName = sourceClass;
    }

    @Override
    public boolean getIncludeAddLine() {
        return this.includeAddLine;
    }

    public void setIncludeAddLine(boolean includeAddLine) {
        this.includeAddLine = includeAddLine;
    }

    public List<MaintainableCollectionDefinition> getMaintainableCollections() {
        return this.maintainableCollections;
    }

    @Override
    public List<? extends CollectionDefinitionI> getCollections() {
        return this.maintainableCollections;
    }

    @Override
    public List<? extends FieldDefinitionI> getSummaryFields() {
        return this.summaryFields;
    }

    @Override
    public boolean hasSummaryField(String key) {
        return this.summaryFieldMap.containsKey(key);
    }

    public boolean isIncludeMultipleLookupLine() {
        return this.includeMultipleLookupLine;
    }

    public void setIncludeMultipleLookupLine(boolean includeMultipleLookupLine) {
        this.includeMultipleLookupLine = includeMultipleLookupLine;
    }

    @Override
    public String getSummaryTitle() {
        return this.summaryTitle;
    }

    public void setSummaryTitle(String overrideSummaryName) {
        this.summaryTitle = overrideSummaryName;
    }

    public String getAttributeToHighlightOnDuplicateKey() {
        return this.attributeToHighlightOnDuplicateKey;
    }

    public void setAttributeToHighlightOnDuplicateKey(String attributeToHighlightOnDuplicate) {
        this.attributeToHighlightOnDuplicateKey = attributeToHighlightOnDuplicate;
    }

    public boolean dissallowDuplicateKey() {
        return StringUtils.isNotBlank((CharSequence)this.getAttributeToHighlightOnDuplicateKey());
    }

    public List<MaintainableFieldDefinition> getDuplicateIdentificationFields() {
        return this.duplicateIdentificationFields;
    }

    public void setMaintainableFields(List<MaintainableFieldDefinition> maintainableFields) {
        this.maintainableFieldMap.clear();
        for (MaintainableFieldDefinition maintainableField : maintainableFields) {
            if (maintainableField == null) {
                throw new IllegalArgumentException("invalid (null) maintainableField");
            }
            String fieldName = maintainableField.getName();
            if (this.maintainableFieldMap.containsKey(fieldName)) {
                throw new DuplicateEntryException("duplicate fieldName entry for field '" + fieldName + "'");
            }
            this.maintainableFieldMap.put(fieldName, maintainableField);
        }
        this.maintainableFields = maintainableFields;
    }

    public void setMaintainableCollections(List<MaintainableCollectionDefinition> maintainableCollections) {
        this.maintainableCollectionMap.clear();
        for (MaintainableCollectionDefinition maintainableCollection : maintainableCollections) {
            if (maintainableCollection == null) {
                throw new IllegalArgumentException("invalid (null) maintainableCollection");
            }
            String fieldName = maintainableCollection.getName();
            if (this.maintainableCollectionMap.containsKey(fieldName)) {
                throw new DuplicateEntryException("duplicate fieldName entry for field '" + fieldName + "'");
            }
            this.maintainableCollectionMap.put(fieldName, maintainableCollection);
        }
        this.maintainableCollections = maintainableCollections;
    }

    public void setSummaryFields(List<MaintainableFieldDefinition> summaryFields) {
        this.summaryFieldMap.clear();
        for (MaintainableFieldDefinition summaryField : summaryFields) {
            if (summaryField == null) {
                throw new IllegalArgumentException("invalid (null) summaryField");
            }
            String fieldName = summaryField.getName();
            if (this.summaryFieldMap.containsKey(fieldName)) {
                throw new DuplicateEntryException("duplicate fieldName entry for field '" + fieldName + "'");
            }
            this.summaryFieldMap.put(fieldName, summaryField);
        }
        this.summaryFields = summaryFields;
    }

    public void setDuplicateIdentificationFields(List<MaintainableFieldDefinition> duplicateIdentificationFields) {
        this.duplicateIdentificationFieldMap.clear();
        for (MaintainableFieldDefinition identifierField : duplicateIdentificationFields) {
            if (identifierField == null) {
                throw new IllegalArgumentException("invalid (null) identifierField");
            }
            String fieldName = identifierField.getName();
            if (this.duplicateIdentificationFieldMap.containsKey(fieldName)) {
                throw new DuplicateEntryException("duplicate fieldName entry for field '" + fieldName + "'");
            }
            this.duplicateIdentificationFieldMap.put(fieldName, identifierField);
        }
        this.duplicateIdentificationFields = duplicateIdentificationFields;
    }

    @Override
    public boolean isAlwaysAllowCollectionDeletion() {
        return this.alwaysAllowCollectionDeletion;
    }

    public void setAlwaysAllowCollectionDeletion(boolean alwaysAllowCollectionDeletion) {
        this.alwaysAllowCollectionDeletion = alwaysAllowCollectionDeletion;
    }
}

