/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.datadictionary.InquirySectionDefinition;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.kfs.krad.datadictionary.SupportAttributeDefinition;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.impl.DataObjectMetaDataServiceImpl;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.valuefinder.DefaultValueFinder;
import org.kuali.rice.krad.bo.BusinessObject;

@Deprecated
public class BusinessObjectMetaDataServiceImpl
extends DataObjectMetaDataServiceImpl
implements BusinessObjectMetaDataService {
    private static final Logger LOG = LogManager.getLogger(BusinessObjectMetaDataServiceImpl.class);
    private BusinessObjectDictionaryService businessObjectDictionaryService;

    @Override
    public Collection<String> getCollectionNames(BusinessObject bo) {
        return this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(bo.getClass().getName()).getCollectionNames();
    }

    @Override
    public Collection<String> getInquirableFieldNames(Class boClass, String sectionTitle) {
        return this.businessObjectDictionaryService.getInquiryFieldNames(boClass, sectionTitle);
    }

    @Override
    public List<String> getLookupableFieldNames(Class boClass) {
        return this.businessObjectDictionaryService.getLookupFieldNames(boClass);
    }

    @Override
    public String getLookupFieldDefaultValue(Class businessObjectClass, String attributeName) {
        return this.businessObjectDictionaryService.getLookupFieldDefaultValue(businessObjectClass, attributeName);
    }

    @Override
    public Class getLookupFieldDefaultValueFinderClass(Class businessObjectClass, String attributeName) {
        return this.businessObjectDictionaryService.getLookupFieldDefaultValueFinderClass(businessObjectClass, attributeName);
    }

    @Override
    public String getLookupFieldQuickfinderParameterString(Class businessObjectClass, String attributeName) {
        return this.businessObjectDictionaryService.getLookupFieldQuickfinderParameterString(businessObjectClass, attributeName);
    }

    @Override
    public Class<? extends DefaultValueFinder> getLookupFieldQuickfinderParameterStringBuilderClass(Class businessObjectClass, String attributeName) {
        return this.businessObjectDictionaryService.getLookupFieldQuickfinderParameterStringBuilderClass(businessObjectClass, attributeName);
    }

    @Override
    public boolean isAttributeInquirable(Class boClass, String attributeName, String sectionTitle) {
        List<InquirySectionDefinition> sections = this.businessObjectDictionaryService.getInquirySections(boClass);
        boolean isInquirable = true;
        for (InquirySectionDefinition section : sections) {
            for (FieldDefinition field : section.getInquiryFields()) {
                if (!field.getAttributeName().equalsIgnoreCase(attributeName)) continue;
                isInquirable = !field.isNoInquiry();
            }
        }
        if (isInquirable) {
            Object obj = null;
            if (boClass != null && BusinessObject.class.isAssignableFrom(boClass)) {
                obj = ObjectUtils.createNewObjectFromClass(boClass);
            }
            if (obj != null) {
                BusinessObject bo = (BusinessObject)obj;
                Class clazz = this.getNestedBOClass(bo, attributeName);
                if (clazz != null && BusinessObject.class.isAssignableFrom(clazz)) {
                    return this.businessObjectDictionaryService.isInquirable(clazz);
                }
                return false;
            }
            return false;
        }
        return isInquirable;
    }

    @Override
    public boolean isInquirable(Class boClass) {
        boolean inquirable = false;
        ModuleService moduleService = this.getKualiModuleService().getResponsibleModuleService(boClass);
        if (moduleService != null && moduleService.isExternalizable(boClass)) {
            inquirable = moduleService.isExternalizableBusinessObjectInquirable(boClass);
        } else {
            Boolean isLookupable = this.businessObjectDictionaryService.isInquirable(boClass);
            if (isLookupable != null) {
                inquirable = isLookupable;
            }
        }
        return inquirable;
    }

    @Override
    public boolean isAttributeLookupable(Class boClass, String attributeName) {
        Object obj = null;
        if (boClass != null && BusinessObject.class.isAssignableFrom(boClass)) {
            obj = ObjectUtils.createNewObjectFromClass(boClass);
        }
        if (obj != null) {
            BusinessObject bo = (BusinessObject)obj;
            DataObjectRelationship relationship = this.getBusinessObjectRelationship(bo, attributeName);
            if (relationship != null && relationship.getRelatedClass() != null && BusinessObject.class.isAssignableFrom(relationship.getRelatedClass())) {
                return this.isLookupable(relationship.getRelatedClass());
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isLookupable(Class boClass) {
        boolean lookupable = false;
        ModuleService moduleService = this.getKualiModuleService().getResponsibleModuleService(boClass);
        if (moduleService != null && moduleService.isExternalizable(boClass)) {
            lookupable = moduleService.isExternalizableBusinessObjectLookupable(boClass);
        } else {
            Boolean isLookupable = this.businessObjectDictionaryService.isLookupable(boClass);
            if (isLookupable != null) {
                lookupable = isLookupable;
            }
        }
        return lookupable;
    }

    @Override
    public DataObjectRelationship getBusinessObjectRelationship(BusinessObject bo, String attributeName) {
        return this.getBusinessObjectRelationship(bo, bo.getClass(), attributeName, "", true);
    }

    @Override
    public DataObjectRelationship getBusinessObjectRelationship(RelationshipDefinition ddReference, BusinessObject bo, Class boClass, String attributeName, String attributePrefix, boolean keysOnly) {
        DataObjectRelationship relationship = null;
        if (ObjectUtils.isNestedAttribute(attributeName)) {
            if (ddReference != null) {
                relationship = new DataObjectRelationship(boClass, ddReference.getObjectAttributeName(), ddReference.getTargetClass());
                for (PrimitiveAttributeDefinition primitiveAttributeDefinition : ddReference.getPrimitiveAttributes()) {
                    if (StringUtils.isNotBlank((CharSequence)attributePrefix)) {
                        relationship.getParentToChildReferences().put(attributePrefix + "." + primitiveAttributeDefinition.getSourceName(), primitiveAttributeDefinition.getTargetName());
                        continue;
                    }
                    relationship.getParentToChildReferences().put(primitiveAttributeDefinition.getSourceName(), primitiveAttributeDefinition.getTargetName());
                }
                if (!keysOnly) {
                    for (SupportAttributeDefinition supportAttributeDefinition : ddReference.getSupportAttributes()) {
                        if (StringUtils.isNotBlank((CharSequence)attributePrefix)) {
                            relationship.getParentToChildReferences().put(attributePrefix + "." + supportAttributeDefinition.getSourceName(), supportAttributeDefinition.getTargetName());
                            if (!supportAttributeDefinition.isIdentifier()) continue;
                            relationship.setUserVisibleIdentifierKey(attributePrefix + "." + supportAttributeDefinition.getSourceName());
                            continue;
                        }
                        relationship.getParentToChildReferences().put(supportAttributeDefinition.getSourceName(), supportAttributeDefinition.getTargetName());
                        if (!supportAttributeDefinition.isIdentifier()) continue;
                        relationship.setUserVisibleIdentifierKey(supportAttributeDefinition.getSourceName());
                    }
                }
                return relationship;
            }
            String localPrefix = StringUtils.substringBefore((String)attributeName, (String)".");
            String string = StringUtils.substringAfter((String)attributeName, (String)".");
            if (bo == null) {
                bo = (BusinessObject)ObjectUtils.createNewObjectFromClass(boClass);
            }
            Class clazz = ObjectUtils.getPropertyType(bo, localPrefix, this.getPersistenceStructureService());
            String fullPrefix = localPrefix;
            if (StringUtils.isNotBlank((CharSequence)attributePrefix)) {
                fullPrefix = attributePrefix + "." + localPrefix;
            }
            if (BusinessObject.class.isAssignableFrom(clazz)) {
                relationship = this.getBusinessObjectRelationship(null, clazz, string, fullPrefix, keysOnly);
            }
            return relationship;
        }
        int maxSize = Integer.MAX_VALUE;
        if (PersistableBusinessObject.class.isAssignableFrom(boClass) && this.getPersistenceStructureService().isPersistable(boClass)) {
            Map<String, DataObjectRelationship> map = this.getPersistenceStructureService().getRelationshipMetadata(boClass, attributeName, attributePrefix);
            if (map.size() > 0) {
                for (DataObjectRelationship rel : map.values()) {
                    if (rel.getParentToChildReferences().size() >= maxSize || !this.isLookupable(rel.getRelatedClass())) continue;
                    maxSize = rel.getParentToChildReferences().size();
                    relationship = rel;
                }
            }
        } else {
            ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(boClass);
            if (moduleService != null && moduleService.isExternalizable(boClass) && (relationship = this.getRelationshipMetadata(boClass, attributeName, attributePrefix)) != null) {
                return relationship;
            }
        }
        if (ddReference != null && this.isLookupable(ddReference.getTargetClass()) && bo != null && ddReference.getPrimitiveAttributes().size() < maxSize) {
            relationship = new DataObjectRelationship(boClass, ddReference.getObjectAttributeName(), ddReference.getTargetClass());
            for (PrimitiveAttributeDefinition primitiveAttributeDefinition : ddReference.getPrimitiveAttributes()) {
                relationship.getParentToChildReferences().put(primitiveAttributeDefinition.getSourceName(), primitiveAttributeDefinition.getTargetName());
            }
            if (!keysOnly) {
                for (SupportAttributeDefinition supportAttributeDefinition : ddReference.getSupportAttributes()) {
                    relationship.getParentToChildReferences().put(supportAttributeDefinition.getSourceName(), supportAttributeDefinition.getTargetName());
                }
            }
        }
        return relationship;
    }

    @Override
    public RelationshipDefinition getBusinessObjectRelationshipDefinition(Class c, String attributeName) {
        return this.getDictionaryRelationship(c, attributeName);
    }

    @Override
    public RelationshipDefinition getBusinessObjectRelationshipDefinition(BusinessObject bo, String attributeName) {
        return this.getBusinessObjectRelationshipDefinition(bo.getClass(), attributeName);
    }

    @Override
    public DataObjectRelationship getBusinessObjectRelationship(BusinessObject bo, Class boClass, String attributeName, String attributePrefix, boolean keysOnly) {
        RelationshipDefinition ddReference = this.getBusinessObjectRelationshipDefinition(boClass, attributeName);
        return this.getBusinessObjectRelationship(ddReference, bo, boClass, attributeName, attributePrefix, keysOnly);
    }

    public BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        return this.businessObjectDictionaryService;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    private Class getNestedBOClass(BusinessObject bo, String attributeName) {
        String[] nestedAttributes = StringUtils.split((String)attributeName, (String)".");
        Class clazz = null;
        if (nestedAttributes.length > 1) {
            String attributeStringSoFar = "";
            for (int i = 0; i < nestedAttributes.length - 1; ++i) {
                try {
                    if (i != 0) {
                        attributeStringSoFar = attributeStringSoFar + ".";
                    }
                    attributeStringSoFar = attributeStringSoFar + nestedAttributes[i];
                    clazz = ObjectUtils.easyGetPropertyType(bo, attributeStringSoFar);
                    continue;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ite) {
                    LOG.info((Object)ite);
                    return null;
                }
            }
        }
        return clazz;
    }

    @Override
    public List<DataObjectRelationship> getBusinessObjectRelationships(BusinessObject bo) {
        if (bo == null) {
            return null;
        }
        return this.getBusinessObjectRelationships(bo.getClass());
    }

    @Override
    public List<DataObjectRelationship> getBusinessObjectRelationships(Class<? extends BusinessObject> boClass) {
        DataDictionaryEntry ddEntry;
        if (boClass == null) {
            return null;
        }
        Map<String, Class> referenceClasses = null;
        if (PersistableBusinessObject.class.isAssignableFrom(boClass) && this.getPersistenceStructureService().isPersistable(boClass)) {
            referenceClasses = this.getPersistenceStructureService().listReferenceObjectFields(boClass);
        }
        List<Object> ddRelationships = (ddEntry = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(boClass.getName())) == null ? new ArrayList() : ddEntry.getRelationships();
        ArrayList<DataObjectRelationship> relationships = new ArrayList<DataObjectRelationship>();
        if (referenceClasses != null) {
            for (Map.Entry entry : referenceClasses.entrySet()) {
                if (!this.isLookupable((Class)entry.getValue())) continue;
                Map fkToPkRefs = this.getPersistenceStructureService().getForeignKeysForReference(boClass, (String)entry.getKey());
                DataObjectRelationship rel = new DataObjectRelationship(boClass, (String)entry.getKey(), (Class)entry.getValue());
                for (Map.Entry ref : fkToPkRefs.entrySet()) {
                    rel.getParentToChildReferences().put((String)ref.getKey(), (String)ref.getValue());
                }
                relationships.add(rel);
            }
        }
        for (RelationshipDefinition relationshipDefinition : ddRelationships) {
            if (!this.isLookupable(relationshipDefinition.getTargetClass())) continue;
            DataObjectRelationship rel = new DataObjectRelationship(boClass, relationshipDefinition.getObjectAttributeName(), relationshipDefinition.getTargetClass());
            for (PrimitiveAttributeDefinition def : relationshipDefinition.getPrimitiveAttributes()) {
                rel.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
            }
            relationships.add(rel);
        }
        return relationships;
    }

    @Override
    public Map<String, Class> getReferencesForForeignKey(BusinessObject bo, String attributeName) {
        List<DataObjectRelationship> dataObjectRelationships = this.getBusinessObjectRelationships(bo);
        HashMap<String, Class> referencesForForeignKey = new HashMap<String, Class>();
        for (DataObjectRelationship dataObjectRelationship : dataObjectRelationships) {
            if (dataObjectRelationship == null || dataObjectRelationship.getParentToChildReferences() == null || !dataObjectRelationship.getParentToChildReferences().containsKey(attributeName)) continue;
            referencesForForeignKey.put(dataObjectRelationship.getParentAttributeName(), dataObjectRelationship.getRelatedClass());
        }
        return referencesForForeignKey;
    }

    @Override
    public String getForeignKeyFieldName(Class businessObjectClass, String attributeName, String targetName) {
        String fkName = "";
        RelationshipDefinition relationshipDefinition = this.getDictionaryRelationship(businessObjectClass, attributeName);
        if (relationshipDefinition != null) {
            List<PrimitiveAttributeDefinition> primitives = relationshipDefinition.getPrimitiveAttributes();
            for (PrimitiveAttributeDefinition primitiveAttributeDefinition : primitives) {
                if (!primitiveAttributeDefinition.getTargetName().equals(targetName)) continue;
                fkName = primitiveAttributeDefinition.getSourceName();
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)fkName) && PersistableBusinessObject.class.isAssignableFrom(businessObjectClass) && this.getPersistenceStructureService().isPersistable(businessObjectClass)) {
            fkName = this.getPersistenceStructureService().getForeignKeyFieldName(businessObjectClass, attributeName, targetName);
        }
        return fkName;
    }
}

