/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class ErrorContainer
implements Serializable {
    private final MessageMap errorMap;
    private final int errorCount;

    public ErrorContainer(MessageMap errorMap) {
        this.errorMap = errorMap;
        this.errorCount = errorMap.getErrorCount();
    }

    public int getErrorCount() {
        if (this.hasFormatterError()) {
            return 0;
        }
        return this.errorCount;
    }

    public List<String> getErrorPropertyList() {
        return new ArrayList<String>(this.errorMap.getAllPropertiesWithErrors());
    }

    private boolean hasFormatterError() {
        if (this.errorMap.getErrorCount() > 0) {
            for (String errorKey : this.errorMap.getAllPropertiesWithErrors()) {
                AutoPopulatingList<ErrorMessage> errorValues = this.errorMap.getMessages(errorKey);
                for (ErrorMessage errorMessage : errorValues) {
                    if (!errorMessage.getErrorKey().equals("error.document.maintenance.formattingError")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ActionMessages getRequestErrors() {
        ActionMessages requestErrors = new ActionMessages();
        for (String property : this.errorMap.getAllPropertiesWithErrors()) {
            AutoPopulatingList<ErrorMessage> errorList = this.errorMap.getErrorMessagesForProperty(property);
            for (ErrorMessage errorMessage : errorList) {
                requestErrors.add(property, new ActionMessage(errorMessage.getErrorKey(), (Object[])errorMessage.getMessageParameters()));
            }
        }
        return requestErrors;
    }
}

