/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryException;
import org.kuali.kfs.krad.datadictionary.DataObjectEntry;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingDefinition;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.kfs.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.krad.datadictionary.TransactionalDocumentEntry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class DataDictionaryIndex
implements Runnable {
    private static final Logger LOG = LogManager.getLogger();
    private DefaultListableBeanFactory ddBeans;
    private Map<String, BusinessObjectEntry> businessObjectEntries;
    private Map<String, DataObjectEntry> objectEntries;
    private Map<String, DocumentEntry> documentEntries;
    private Map<Class, DocumentEntry> documentEntriesByBusinessObjectClass;
    private Map<Class, DocumentEntry> documentEntriesByMaintainableClass;
    private Map<String, DataDictionaryEntry> entriesByJstlKey;
    private Map<Class, Set<InactivationBlockingMetadata>> inactivationBlockersForClass;
    private Set<String> parentAttributes;
    private Map<String, String> childAttributesParent;

    public DataDictionaryIndex(DefaultListableBeanFactory ddBeans) {
        this.ddBeans = ddBeans;
    }

    public Map<String, BusinessObjectEntry> getBusinessObjectEntries() {
        return this.businessObjectEntries;
    }

    public Map<String, DataObjectEntry> getDataObjectEntries() {
        return this.objectEntries;
    }

    public Map<String, DocumentEntry> getDocumentEntries() {
        return this.documentEntries;
    }

    public Map<Class, DocumentEntry> getDocumentEntriesByBusinessObjectClass() {
        return this.documentEntriesByBusinessObjectClass;
    }

    public Map<Class, DocumentEntry> getDocumentEntriesByMaintainableClass() {
        return this.documentEntriesByMaintainableClass;
    }

    public Map<String, DataDictionaryEntry> getEntriesByJstlKey() {
        return this.entriesByJstlKey;
    }

    public Map<Class, Set<InactivationBlockingMetadata>> getInactivationBlockersForClass() {
        return this.inactivationBlockersForClass;
    }

    private void buildDDIndicies() {
        this.businessObjectEntries = new HashMap<String, BusinessObjectEntry>();
        this.objectEntries = new HashMap<String, DataObjectEntry>();
        this.documentEntries = new HashMap<String, DocumentEntry>();
        this.documentEntriesByBusinessObjectClass = new HashMap<Class, DocumentEntry>();
        this.documentEntriesByMaintainableClass = new HashMap<Class, DocumentEntry>();
        this.entriesByJstlKey = new HashMap<String, DataDictionaryEntry>();
        Map boBeans = this.ddBeans.getBeansOfType(DataObjectEntry.class);
        for (DataObjectEntry entry : boBeans.values()) {
            DataObjectEntry indexedEntry = this.objectEntries.get(entry.getJstlKey());
            if (indexedEntry == null) {
                indexedEntry = this.businessObjectEntries.get(entry.getJstlKey());
            }
            if (indexedEntry != null && !indexedEntry.getDataObjectClass().equals(entry.getDataObjectClass())) {
                throw new DataDictionaryException("Two object classes may not share the same jstl key: this=" + entry.getDataObjectClass() + " / existing=" + indexedEntry.getDataObjectClass());
            }
            this.objectEntries.put(entry.getDataObjectClass().getName(), entry);
            this.objectEntries.put(entry.getDataObjectClass().getSimpleName(), entry);
            if (entry instanceof BusinessObjectEntry) {
                BusinessObjectEntry boEntry = (BusinessObjectEntry)entry;
                this.businessObjectEntries.put(boEntry.getBusinessObjectClass().getName(), boEntry);
                this.businessObjectEntries.put(boEntry.getBusinessObjectClass().getSimpleName(), boEntry);
                if (boEntry.getBaseBusinessObjectClass() != null) {
                    this.businessObjectEntries.put(boEntry.getBaseBusinessObjectClass().getName(), boEntry);
                    this.businessObjectEntries.put(boEntry.getBaseBusinessObjectClass().getSimpleName(), boEntry);
                }
            }
            this.entriesByJstlKey.put(entry.getJstlKey(), entry);
        }
        Map docBeans = this.ddBeans.getBeansOfType(DocumentEntry.class);
        for (DocumentEntry entry : docBeans.values()) {
            String entryName = entry.getDocumentTypeName();
            if (entry instanceof TransactionalDocumentEntry && this.documentEntries.get(entry.getFullClassName()) != null && !StringUtils.equals((CharSequence)this.documentEntries.get(entry.getFullClassName()).getDocumentTypeName(), (CharSequence)entry.getDocumentTypeName())) {
                throw new DataDictionaryException("Two transactional document types may not share the same document class: this=" + entry.getDocumentTypeName() + " / existing=" + this.documentEntries.get(entry.getDocumentClass().getName()).getDocumentTypeName());
            }
            if (this.documentEntries.get(entry.getJstlKey()) != null && !this.documentEntries.get(entry.getJstlKey()).getDocumentTypeName().equals(entry.getDocumentTypeName())) {
                throw new DataDictionaryException("Two document types may not share the same jstl key: this=" + entry.getDocumentTypeName() + " / existing=" + this.documentEntries.get(entry.getJstlKey()).getDocumentTypeName());
            }
            if (entryName != null) {
                this.documentEntries.put(entryName, entry);
            }
            this.documentEntries.put(entry.getDocumentClass().getName(), entry);
            if (entry.getBaseDocumentClass() != null) {
                this.documentEntries.put(entry.getBaseDocumentClass().getName(), entry);
            }
            this.entriesByJstlKey.put(entry.getJstlKey(), entry);
            if (entry instanceof TransactionalDocumentEntry) {
                TransactionalDocumentEntry tde = (TransactionalDocumentEntry)entry;
                this.documentEntries.put(tde.getDocumentClass().getSimpleName(), entry);
                if (tde.getBaseDocumentClass() != null) {
                    this.documentEntries.put(tde.getBaseDocumentClass().getSimpleName(), entry);
                }
            }
            if (!(entry instanceof MaintenanceDocumentEntry)) continue;
            MaintenanceDocumentEntry mde = (MaintenanceDocumentEntry)entry;
            this.documentEntriesByBusinessObjectClass.put(mde.getDataObjectClass(), entry);
            this.documentEntriesByMaintainableClass.put(mde.getMaintainableClass(), entry);
            this.documentEntries.put(mde.getDataObjectClass().getSimpleName() + "MaintenanceDocument", entry);
        }
    }

    private void buildDDInactivationBlockingIndices() {
        this.inactivationBlockersForClass = new HashMap<Class, Set<InactivationBlockingMetadata>>();
        Map doBeans = this.ddBeans.getBeansOfType(DataObjectEntry.class);
        for (DataObjectEntry entry : doBeans.values()) {
            List<InactivationBlockingDefinition> inactivationBlockingDefinitions = entry.getInactivationBlockingDefinitions();
            if (inactivationBlockingDefinitions == null || inactivationBlockingDefinitions.isEmpty()) continue;
            for (InactivationBlockingDefinition inactivationBlockingDefinition : inactivationBlockingDefinitions) {
                this.registerInactivationBlockingDefinition(inactivationBlockingDefinition);
            }
        }
    }

    private void registerInactivationBlockingDefinition(InactivationBlockingDefinition inactivationBlockingDefinition) {
        boolean duplicateAdd;
        Set inactivationBlockingDefinitions = this.inactivationBlockersForClass.computeIfAbsent(inactivationBlockingDefinition.getBlockedBusinessObjectClass(), k -> new HashSet());
        boolean bl = duplicateAdd = !inactivationBlockingDefinitions.add(inactivationBlockingDefinition);
        if (duplicateAdd) {
            throw new DataDictionaryException("Detected duplicate InactivationBlockingDefinition for class " + inactivationBlockingDefinition.getBlockingReferenceBusinessObjectClass().getName());
        }
    }

    @Override
    public void run() {
        LOG.info("Starting DD Index Building");
        this.buildDDIndicies();
        LOG.info("Completed DD Index Building");
        LOG.info("Started DD Inactivation Blocking Index Building");
        this.buildDDInactivationBlockingIndices();
        LOG.info("Completed DD Inactivation Blocking Index Building");
        LOG.info("Started building Attribute Parent set");
        this.buildAttributeParentSet();
        LOG.info("Completed building Attribute Parent set");
    }

    private void buildAttributeParentSet() {
        this.parentAttributes = new HashSet<String>();
        this.childAttributesParent = new HashMap<String, String>();
        for (String beanName : this.ddBeans.getBeanNamesForType(AttributeDefinition.class)) {
            BeanDefinition beanDefinition = this.ddBeans.getBeanDefinition(beanName);
            if (beanDefinition == null || beanDefinition.getParentName() == null) continue;
            this.addParentBeanDefinitionType(beanName, beanName);
        }
    }

    private void addParentBeanDefinitionType(String beanName, String initialBeanName) {
        BeanDefinition beanDefinition = this.ddBeans.getBeanDefinition(beanName);
        if (beanDefinition.getParentName().endsWith("-parentBean")) {
            this.addParentBeanDefinitionType(beanDefinition.getParentName(), initialBeanName);
        } else {
            String parentName;
            this.parentAttributes.add(beanDefinition.getParentName());
            String string = parentName = this.isTopLevelAttribute(beanDefinition.getParentName()) ? beanName : beanDefinition.getParentName();
            if (!parentName.contains("-parentBean")) {
                this.childAttributesParent.put(initialBeanName, parentName);
            }
        }
    }

    public boolean isTopLevelAttribute(String attributeName) {
        return ("AttributeDefinition".equals(attributeName) || attributeName.startsWith("GenericAttributes") || attributeName.startsWith("CommonAttributes") || "ExternalizableAttributeDefinitionProxy".equals(attributeName)) && !"GenericAttributes-genericFiscalYear".equals(attributeName) && !"GenericAttributes-universityFiscalAccountingPeriod".equals(attributeName);
    }

    public Map<String, String> getChildAttributesParent() {
        return this.childAttributesParent;
    }
}

