/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.BaseAttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.ValidationUtils;
import org.kuali.kfs.krad.datadictionary.validation.capability.Constrainable;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;

public class DictionaryObjectAttributeValueReader
extends BaseAttributeValueReader {
    protected Object object;
    protected DataDictionaryEntry entry;
    protected BeanWrapper beanWrapper;
    private String attributePath;

    public DictionaryObjectAttributeValueReader(Object object, String entryName, DataDictionaryEntry entry) {
        this.object = object;
        this.entry = entry;
        this.entryName = entryName;
        if (object != null) {
            this.beanWrapper = new BeanWrapperImpl(object);
        }
    }

    public DictionaryObjectAttributeValueReader(Object object, String entryName, DataDictionaryEntry entry, String attributePath) {
        this(object, entryName, entry);
        this.attributePath = attributePath;
    }

    @Override
    public Constrainable getDefinition(String attrName) {
        return this.entry != null ? this.entry.getAttributeDefinition(attrName) : null;
    }

    @Override
    public List<Constrainable> getDefinitions() {
        if (this.entry instanceof DataDictionaryEntryBase) {
            DataDictionaryEntryBase entryBase = (DataDictionaryEntryBase)this.entry;
            List<AttributeDefinition> attributeDefinitions = entryBase.getAttributes();
            return new ArrayList<Constrainable>(attributeDefinitions);
        }
        return null;
    }

    @Override
    public Constrainable getEntry() {
        if (this.entry instanceof Constrainable) {
            return (Constrainable)((Object)this.entry);
        }
        return null;
    }

    @Override
    public String getLabel(String attrName) {
        AttributeDefinition attributeDefinition = this.entry != null ? this.entry.getAttributeDefinition(attrName) : null;
        return attributeDefinition != null ? attributeDefinition.getLabel() : attrName;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public String getPath() {
        String path = ValidationUtils.buildPath(this.attributePath, this.attributeName);
        return path != null ? path : "";
    }

    @Override
    public Class<?> getType(String attrName) {
        PropertyDescriptor propertyDescriptor = this.beanWrapper.getPropertyDescriptor(attrName);
        return propertyDescriptor.getPropertyType();
    }

    @Override
    public boolean isReadable() {
        return this.beanWrapper.isReadableProperty(this.attributeName);
    }

    @Override
    public <X> X getValue() throws AttributeValidationException {
        X value = this.getValue(this.attributeName);
        return value;
    }

    @Override
    public <X> X getValue(String attrName) throws AttributeValidationException {
        Object attributeValue = null;
        IllegalArgumentException e = null;
        try {
            attributeValue = this.beanWrapper.getPropertyValue(attrName);
        }
        catch (IllegalArgumentException iae) {
            e = iae;
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        if (e != null) {
            throw new AttributeValidationException("Unable to lookup attribute value by name (" + attrName + ") using introspection", e);
        }
        return (X)attributeValue;
    }

    public boolean isParentAttributeNull() {
        boolean isParentNull = true;
        if (this.isNestedAttribute()) {
            String[] pathTokens = this.attributeName.split("\\.");
            isParentNull = false;
            String parentPath = "";
            for (int i = 0; i < pathTokens.length - 1 && !isParentNull; ++i) {
                isParentNull = this.beanWrapper.getPropertyValue(parentPath = parentPath + pathTokens[i]) == null;
                parentPath = parentPath + ".";
            }
        }
        return isParentNull;
    }

    public boolean isNestedAttribute() {
        return this.attributePath != null || this.attributeName.contains(".");
    }

    @Override
    public AttributeValueReader clone() {
        DictionaryObjectAttributeValueReader readerClone = new DictionaryObjectAttributeValueReader(this.object, this.entryName, this.entry, this.attributePath);
        readerClone.setAttributeName(this.attributeName);
        return readerClone;
    }
}

