/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.inquiry;

import java.util.Set;
import org.kuali.kfs.krad.bo.Exporter;
import org.kuali.kfs.krad.datadictionary.DataObjectEntry;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.view.InquiryView;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.view.ViewPresentationControllerBase;
import org.kuali.kfs.krad.web.form.UifFormBase;

public class InquiryViewPresentationControllerBase
extends ViewPresentationControllerBase {
    private static final long serialVersionUID = 7504225899471226403L;

    @Override
    public Set<String> getActionFlags(View view, UifFormBase model) {
        Set<String> actionFlags = super.getActionFlags(view, model);
        if (this.isExportSupported((InquiryView)model.getView())) {
            actionFlags.add("canExport");
        }
        return actionFlags;
    }

    protected boolean isExportSupported(InquiryView view) {
        DataObjectEntry dataObjectEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDataObjectEntry(view.getDataObjectClassName().getName());
        Class<? extends Exporter> exporterClass = dataObjectEntry.getExporterClass();
        if (exporterClass != null) {
            try {
                Exporter exporter = exporterClass.newInstance();
                if (exporter.getSupportedFormats(dataObjectEntry.getDataObjectClass()).contains("xml")) {
                    return true;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to locate or create exporter class: " + exporterClass);
            }
        }
        return false;
    }
}

