/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.kim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.kim.permission.PermissionTypeServiceBase;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.permission.PermissionBo;

public class ViewPermissionTypeServiceImpl
extends PermissionTypeServiceBase {
    private boolean exactMatchPriority = true;

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> attributes = new ArrayList<String>(super.getRequiredAttributes());
        attributes.add("viewId");
        return Collections.unmodifiableList(attributes);
    }

    @Override
    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        String permissionViewId;
        PermissionBo bo;
        ArrayList<Permission> matchingPermissions = new ArrayList<Permission>();
        String requestedViewId = requestedDetails.get("viewId");
        for (Permission permission : permissionsList) {
            bo = PermissionBo.from((Permission)permission);
            permissionViewId = (String)bo.getDetails().get("viewId");
            if (!StringUtils.equals((CharSequence)requestedViewId, (CharSequence)permissionViewId)) continue;
            matchingPermissions.add(permission);
        }
        if (!this.exactMatchPriority || matchingPermissions.isEmpty()) {
            for (Permission kpi : permissionsList) {
                bo = PermissionBo.from((Permission)kpi);
                permissionViewId = (String)bo.getDetails().get("viewId");
                if (requestedViewId == null || permissionViewId == null || StringUtils.equals((CharSequence)requestedViewId, (CharSequence)permissionViewId) || !requestedViewId.matches(permissionViewId.replaceAll("\\*", ".*"))) continue;
                matchingPermissions.add(kpi);
            }
        }
        return matchingPermissions;
    }

    public boolean getExactMatchPriority() {
        return this.exactMatchPriority;
    }

    public void setExactMatchPriority(Boolean exactMatchPriority) {
        this.exactMatchPriority = exactMatchPriority;
    }
}

