/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.lookup;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.view.ViewAuthorizerBase;
import org.kuali.kfs.krad.uif.view.ViewModel;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.form.LookupForm;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kim.api.identity.Person;

public class LookupViewAuthorizerBase
extends ViewAuthorizerBase {
    private static final long serialVersionUID = 3755133641536256283L;
    private static final Logger LOG = LogManager.getLogger(LookupViewAuthorizerBase.class);

    @Override
    public boolean canOpenView(View view, ViewModel model, Person user) {
        boolean canOpen = super.canOpenView(view, model, user);
        if (canOpen) {
            Map<String, String> additionalPermissionDetails;
            LookupForm lookupForm = (LookupForm)model;
            try {
                additionalPermissionDetails = KRADUtils.getNamespaceAndComponentSimpleName(Class.forName(lookupForm.getDataObjectClassName()));
            }
            catch (ClassNotFoundException e) {
                throw new RiceRuntimeException("Unable to create class for lookup class name: " + lookupForm.getDataObjectClassName());
            }
            if (this.permissionExistsByTemplate(model, "KR-NS", "Look Up Records", additionalPermissionDetails)) {
                canOpen = this.isAuthorizedByTemplate(model, "KR-NS", "Look Up Records", user.getPrincipalId(), additionalPermissionDetails, null);
            }
        }
        return canOpen;
    }

    public boolean canInitiateDocument(LookupForm lookupForm, Person user) {
        boolean canInitiateDocument = false;
        try {
            Class<?> dataObjectClass = Class.forName(lookupForm.getDataObjectClassName());
            String documentTypeName = KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentTypeName(dataObjectClass);
            if (documentTypeName != null && KRADServiceLocatorWeb.getDocumentDictionaryService().getDocumentAuthorizer(documentTypeName).canInitiate(documentTypeName, user)) {
                canInitiateDocument = true;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Unable to load Data Object Class: " + lookupForm.getDataObjectClassName(), (Throwable)e);
        }
        return canInitiateDocument;
    }
}

