/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.service.DataDictionaryRemoteFieldService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorInternal;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.control.CheckboxControl;
import org.kuali.kfs.krad.uif.control.CheckboxGroupControl;
import org.kuali.kfs.krad.uif.control.Control;
import org.kuali.kfs.krad.uif.control.GroupControl;
import org.kuali.kfs.krad.uif.control.HiddenControl;
import org.kuali.kfs.krad.uif.control.MultiValueControl;
import org.kuali.kfs.krad.uif.control.RadioGroupControl;
import org.kuali.kfs.krad.uif.control.SelectControl;
import org.kuali.kfs.krad.uif.control.TextAreaControl;
import org.kuali.kfs.krad.uif.control.TextControl;
import org.kuali.kfs.krad.uif.control.UserControl;
import org.kuali.kfs.krad.workflow.service.WorkflowAttributePropertyResolutionService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableCheckbox;
import org.kuali.rice.core.api.uif.RemotableCheckboxGroup;
import org.kuali.rice.core.api.uif.RemotableHiddenInput;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.core.api.util.KeyValue;

public class DataDictionaryRemoteFieldServiceImpl
implements DataDictionaryRemoteFieldService {
    @Override
    public RemotableAttributeField buildRemotableFieldFromAttributeDefinition(String componentClassName, String attributeName) {
        RemotableQuickFinder.Builder qf;
        AttributeDefinition baseDefinition;
        Class<?> componentClass;
        try {
            componentClass = Class.forName(componentClassName);
            baseDefinition = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(componentClassName).getAttributeDefinition(attributeName);
        }
        catch (ClassNotFoundException ex) {
            throw new RiceRuntimeException("Unable to find attribute definition for attribute : " + attributeName);
        }
        RemotableAttributeField.Builder definition = RemotableAttributeField.Builder.create((String)baseDefinition.getName());
        definition.setLongLabel(baseDefinition.getLabel());
        definition.setShortLabel(baseDefinition.getShortLabel());
        definition.setMaxLength(baseDefinition.getMaxLength());
        definition.setRequired(baseDefinition.isRequired().booleanValue());
        definition.setForceUpperCase(baseDefinition.getForceUppercase().booleanValue());
        WorkflowAttributePropertyResolutionService propertyResolutionService = KRADServiceLocatorInternal.getWorkflowAttributePropertyResolutionService();
        String dataType = propertyResolutionService.determineFieldDataType(componentClass, attributeName);
        definition.setDataType(DataType.valueOf((String)dataType.toUpperCase()));
        RemotableAbstractControl.Builder control = this.createControl(baseDefinition);
        if (control != null) {
            definition.setControl(control);
        }
        if ((qf = this.createQuickFinder(componentClass, attributeName)) != null) {
            definition.setWidgets(Collections.singletonList(qf));
        }
        return definition.build();
    }

    protected RemotableAbstractControl.Builder createControl(AttributeDefinition attr) {
        Control control = attr.getControlField();
        if (control != null) {
            if (control instanceof CheckboxControl) {
                return RemotableCheckbox.Builder.create();
            }
            if (control instanceof CheckboxGroupControl) {
                return RemotableCheckboxGroup.Builder.create(this.getValues(attr));
            }
            if (control instanceof HiddenControl) {
                return RemotableHiddenInput.Builder.create();
            }
            if (control instanceof SelectControl) {
                RemotableSelect.Builder b = RemotableSelect.Builder.create(this.getValues(attr));
                b.setMultiple(((SelectControl)control).isMultiple());
                b.setSize(Integer.valueOf(((SelectControl)control).getSize()));
            } else {
                if (control instanceof RadioGroupControl) {
                    return RemotableRadioButtonGroup.Builder.create(this.getValues(attr));
                }
                if (control instanceof TextControl) {
                    RemotableTextInput.Builder b = RemotableTextInput.Builder.create();
                    b.setSize(Integer.valueOf(((TextControl)control).getSize()));
                    return b;
                }
                if (control instanceof UserControl) {
                    RemotableTextInput.Builder b = RemotableTextInput.Builder.create();
                    b.setSize(Integer.valueOf(((UserControl)control).getSize()));
                    return b;
                }
                if (control instanceof GroupControl) {
                    RemotableTextInput.Builder b = RemotableTextInput.Builder.create();
                    b.setSize(Integer.valueOf(((GroupControl)control).getSize()));
                    return b;
                }
                if (control instanceof TextAreaControl) {
                    RemotableTextarea.Builder b = RemotableTextarea.Builder.create();
                    b.setCols(Integer.valueOf(((TextAreaControl)control).getCols()));
                    b.setRows(Integer.valueOf(((TextAreaControl)control).getRows()));
                    return b;
                }
            }
        }
        return null;
    }

    protected Map<String, String> getValues(AttributeDefinition attr) {
        Control control = attr.getControlField();
        if (control instanceof MultiValueControl && ((MultiValueControl)((Object)control)).getOptions() != null && !((MultiValueControl)((Object)control)).getOptions().isEmpty()) {
            List<KeyValue> keyValues = ((MultiValueControl)((Object)control)).getOptions();
            HashMap<String, String> options = new HashMap<String, String>();
            for (KeyValue keyValue : keyValues) {
                options.put(keyValue.getKey(), keyValue.getValue());
            }
            return options;
        }
        if (attr.getOptionsFinder() != null) {
            return attr.getOptionsFinder().getKeyLabelMap();
        }
        return Collections.emptyMap();
    }

    protected RemotableQuickFinder.Builder createQuickFinder(Class<?> componentClass, String attributeName) {
        Object sampleComponent;
        try {
            sampleComponent = componentClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RiceRuntimeException((Throwable)e);
        }
        String lookupClassName = null;
        HashMap<String, String> fieldConversions = new HashMap<String, String>();
        HashMap<String, String> lookupParameters = new HashMap<String, String>();
        DataObjectRelationship relationship = this.getDataObjectMetaDataService().getDataObjectRelationship(sampleComponent, componentClass, attributeName, "", true, true, false);
        if (relationship != null) {
            String toField;
            String fromField;
            lookupClassName = relationship.getRelatedClass().getName();
            for (Map.Entry<String, String> entry : relationship.getParentToChildReferences().entrySet()) {
                fromField = entry.getValue();
                toField = entry.getKey();
                fieldConversions.put(fromField, toField);
            }
            for (Map.Entry<String, String> entry : relationship.getParentToChildReferences().entrySet()) {
                fromField = entry.getKey();
                toField = entry.getValue();
                if (relationship.getUserVisibleIdentifierKey() != null && !relationship.getUserVisibleIdentifierKey().equals(fromField)) continue;
                lookupParameters.put(fromField, toField);
            }
        } else {
            String titleAttribute = this.getDataObjectMetaDataService().getTitleAttribute(componentClass);
            if (StringUtils.equals((CharSequence)titleAttribute, (CharSequence)attributeName)) {
                lookupClassName = componentClass.getName();
                List<String> pkAttributes = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(componentClass);
                for (String pkAttribute : pkAttributes) {
                    fieldConversions.put(pkAttribute, pkAttribute);
                    if (StringUtils.equals((CharSequence)pkAttribute, (CharSequence)attributeName)) continue;
                    lookupParameters.put(pkAttribute, pkAttribute);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)lookupClassName)) {
            String baseUrl = this.getKualiConfigurationService().getPropertyValueAsString("krad.lookup.url");
            RemotableQuickFinder.Builder builder = RemotableQuickFinder.Builder.create((String)baseUrl, (String)lookupClassName);
            builder.setLookupParameters(lookupParameters);
            builder.setFieldConversions(fieldConversions);
            return builder;
        }
        return null;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        return KRADServiceLocatorWeb.getDataObjectMetaDataService();
    }

    protected ConfigurationService getKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }
}

