/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.InactivatableFromTo;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.InactivateableFromToService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.BusinessObject;

public class InactivateableFromToServiceImpl
implements InactivateableFromToService {
    protected DateTimeService dateTimeService;
    protected LookupService lookupService;
    protected DataDictionaryService dataDictionaryService;

    @Override
    public List<InactivatableFromTo> findMatchingActive(Class<? extends InactivatableFromTo> clazz, Map fieldValues) {
        fieldValues.put("active", "true");
        return (List)this.lookupService.findCollectionBySearchUnbounded(clazz, fieldValues);
    }

    @Override
    public List<InactivatableFromTo> findMatchingActiveAsOfDate(Class<? extends InactivatableFromTo> clazz, Map fieldValues, Date activeAsOfDate) {
        fieldValues.put("active", "true");
        fieldValues.put("activeAsOfDate", this.dateTimeService.toDateString(activeAsOfDate));
        return (List)this.lookupService.findCollectionBySearchUnbounded(clazz, fieldValues);
    }

    @Override
    public List<InactivatableFromTo> filterOutNonActive(List<InactivatableFromTo> filterList) {
        return this.filterOutNonActive(filterList, this.dateTimeService.getCurrentDate());
    }

    @Override
    public List<InactivatableFromTo> filterOutNonActive(List<InactivatableFromTo> filterList, Date activeAsOfDate) {
        ArrayList<InactivatableFromTo> filteredList = new ArrayList<InactivatableFromTo>();
        for (InactivatableFromTo inactivateable : filterList) {
            inactivateable.setActiveAsOfDate(new Timestamp(activeAsOfDate.getTime()));
            if (!inactivateable.isActive()) continue;
            filteredList.add(inactivateable);
        }
        return filteredList;
    }

    @Override
    public List<InactivatableFromTo> findMatchingCurrent(Class<? extends InactivatableFromTo> clazz, Map fieldValues) {
        fieldValues.put("active", "true");
        fieldValues.put("current", "true");
        return (List)this.lookupService.findCollectionBySearchUnbounded(clazz, fieldValues);
    }

    @Override
    public List<InactivatableFromTo> findMatchingCurrent(Class<? extends InactivatableFromTo> clazz, Map fieldValues, Date currentAsOfDate) {
        fieldValues.put("active", "true");
        fieldValues.put("current", "true");
        fieldValues.put("activeAsOfDate", this.dateTimeService.toDateString(currentAsOfDate));
        return (List)this.lookupService.findCollectionBySearchUnbounded(clazz, fieldValues);
    }

    @Override
    public List<InactivatableFromTo> filterOutNonCurrent(List<InactivatableFromTo> filterList) {
        return this.filterOutNonCurrent(filterList, this.dateTimeService.getCurrentDate());
    }

    @Override
    public List<InactivatableFromTo> filterOutNonCurrent(List<InactivatableFromTo> filterList, Date currentAsOfDate) {
        List<InactivatableFromTo> activeList = this.filterOutNonActive(filterList, currentAsOfDate);
        if (activeList.isEmpty()) {
            return activeList;
        }
        ArrayList<InactivatableFromTo> currentList = new ArrayList();
        List<String> groupByList = this.getDataDictionaryService().getGroupByAttributesForEffectiveDating(activeList.get(0).getClass());
        if (groupByList != null) {
            ArrayList<String> sortByList = new ArrayList<String>(groupByList);
            sortByList.add("activeFromDate");
            activeList.sort(new BeanPropertyComparator(sortByList, true));
            Collections.reverse(activeList);
            String previousGroupByString = "";
            Timestamp previousActiveFromDate = null;
            for (InactivatableFromTo inactivateable : activeList) {
                String groupByString = this.buildGroupByValueString((BusinessObject)inactivateable, groupByList);
                if (!StringUtils.equals((CharSequence)groupByString, (CharSequence)previousGroupByString)) {
                    currentList.add(inactivateable);
                } else if (inactivateable.getActiveFromDate().equals((Object)previousActiveFromDate)) {
                    currentList.add(inactivateable);
                }
                previousGroupByString = groupByString;
                previousActiveFromDate = inactivateable.getActiveFromDate();
            }
        } else {
            currentList = activeList;
        }
        return currentList;
    }

    protected String buildGroupByValueString(BusinessObject businessObject, List<String> groupByList) {
        String groupByValueString = "";
        for (String groupByField : groupByList) {
            Object fieldValue = ObjectUtils.getPropertyValue(businessObject, groupByField);
            groupByValueString = groupByValueString + "|";
            if (fieldValue == null) continue;
            groupByValueString = groupByValueString + fieldValue;
        }
        return groupByValueString;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

