/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.uif.CssConstants;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.container.Container;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.layout.LayoutManagerBase;
import org.kuali.kfs.krad.uif.view.View;

public class BoxLayoutManager
extends LayoutManagerBase {
    private static final long serialVersionUID = 4467342272983290044L;
    private UifConstants.Orientation orientation = UifConstants.Orientation.HORIZONTAL;
    private String padding;
    private String itemStyle;
    private List<String> itemStyleClasses = new ArrayList<String>();
    private boolean layoutFieldErrors;

    @Override
    public void performInitialization(View view, Object model, Container container) {
        super.performInitialization(view, model, container);
        if (StringUtils.isBlank((CharSequence)this.itemStyle)) {
            this.itemStyle = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)this.padding)) {
            this.itemStyle = this.orientation.equals((Object)UifConstants.Orientation.VERTICAL) ? this.itemStyle + CssConstants.getCssStyle("padding-bottom: {0};", this.padding) : this.itemStyle + CssConstants.getCssStyle("padding-right: {0};", this.padding);
        }
        this.addStyleClass("fieldLine");
        this.addStyleClass("clearfix");
        for (Component component : container.getItems()) {
            if (component == null) continue;
            if (this.orientation.equals((Object)UifConstants.Orientation.HORIZONTAL) && component instanceof InputField) {
                ((InputField)component).getErrorsField().setAlternateContainer(true);
                this.layoutFieldErrors = true;
            }
            if (!container.isFieldContainer() || !(component instanceof InputField)) continue;
            ((InputField)component).getErrorsField().setAlternateContainer(true);
            this.layoutFieldErrors = true;
        }
    }

    public UifConstants.Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(UifConstants.Orientation orientation) {
        this.orientation = orientation;
    }

    public String getPadding() {
        return this.padding;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    public String getItemStyle() {
        return this.itemStyle;
    }

    public void setItemStyle(String itemStyle) {
        this.itemStyle = itemStyle;
    }

    public List<String> getItemStyleClasses() {
        return this.itemStyleClasses;
    }

    public void setItemStyleClasses(List<String> itemStyleClasses) {
        this.itemStyleClasses = itemStyleClasses;
    }

    public String getItemStyleClassesAsString() {
        if (this.itemStyleClasses != null) {
            return StringUtils.join(this.itemStyleClasses, (String)" ");
        }
        return "";
    }

    public boolean isLayoutFieldErrors() {
        return this.layoutFieldErrors;
    }

    public void setLayoutFieldErrors(boolean layoutFieldErrors) {
        this.layoutFieldErrors = layoutFieldErrors;
    }
}

