/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.DataBinding;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.container.Container;
import org.kuali.kfs.krad.uif.container.Group;
import org.kuali.kfs.krad.uif.field.ActionField;
import org.kuali.kfs.krad.uif.field.DataField;
import org.kuali.kfs.krad.uif.field.Field;
import org.kuali.kfs.krad.uif.field.FieldGroup;
import org.kuali.kfs.krad.uif.field.LabelField;
import org.kuali.kfs.krad.uif.field.MessageField;
import org.kuali.kfs.krad.uif.layout.CollectionLayoutManager;
import org.kuali.kfs.krad.uif.layout.CollectionLayoutUtils;
import org.kuali.kfs.krad.uif.layout.GridLayoutManager;
import org.kuali.kfs.krad.uif.util.ComponentFactory;
import org.kuali.kfs.krad.uif.util.ComponentUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.widget.RichTable;
import org.kuali.kfs.krad.web.form.UifFormBase;

public class TableLayoutManager
extends GridLayoutManager
implements CollectionLayoutManager {
    private static final long serialVersionUID = 3622267585541524208L;
    private boolean useShortLabels = true;
    private boolean repeatHeader = false;
    private LabelField headerFieldPrototype;
    private boolean renderSequenceField = true;
    private boolean generateAutoSequence = false;
    private Field sequenceFieldPrototype;
    private FieldGroup actionFieldPrototype;
    private FieldGroup subCollectionFieldGroupPrototype;
    private Field selectFieldPrototype;
    private boolean separateAddLine = false;
    private Group addLineGroup;
    private int numberOfDataColumns;
    private List<LabelField> headerFields = new ArrayList<LabelField>();
    private List<Field> dataFields = new ArrayList<Field>();
    private RichTable richTable;
    private boolean headerAdded = false;
    private Set<String> hiddenColumns;
    private Set<String> sortableColumns;

    @Override
    public void performInitialization(View view, Object model, Container container) {
        super.performInitialization(view, model, container);
        if (this.generateAutoSequence && !(this.sequenceFieldPrototype instanceof MessageField)) {
            this.sequenceFieldPrototype = ComponentFactory.getMessageField();
            view.assignComponentIds(this.sequenceFieldPrototype);
        }
        view.getViewHelperService().performComponentInitialization(view, model, this.headerFieldPrototype);
        view.getViewHelperService().performComponentInitialization(view, model, this.sequenceFieldPrototype);
        view.getViewHelperService().performComponentInitialization(view, model, this.actionFieldPrototype);
        view.getViewHelperService().performComponentInitialization(view, model, this.subCollectionFieldGroupPrototype);
        view.getViewHelperService().performComponentInitialization(view, model, this.selectFieldPrototype);
    }

    @Override
    public void performFinalize(View view, Object model, Container container) {
        super.performFinalize(view, model, container);
        UifFormBase formBase = (UifFormBase)model;
        CollectionGroup collectionGroup = (CollectionGroup)container;
        int totalColumns = this.getNumberOfDataColumns();
        if (this.renderSequenceField) {
            ++totalColumns;
        }
        if (collectionGroup.isRenderSelectField()) {
            ++totalColumns;
        }
        if (collectionGroup.isRenderLineActions() && !collectionGroup.isReadOnly()) {
            ++totalColumns;
        }
        if (collectionGroup.isRenderAddLine() && StringUtils.isBlank((CharSequence)this.getFirstLineStyle()) && !this.isSeparateAddLine()) {
            this.setFirstLineStyle("kr-addLine");
        }
        if ("addLine".equals(formBase.getActionEvent())) {
            String highlightScript = "jq(\"#" + container.getId() + "_div > tr:first\").effect(\"highlight\",{}, 6000);";
            String onReadyScript = collectionGroup.getOnDocumentReadyScript();
            if (StringUtils.isNotBlank((CharSequence)onReadyScript)) {
                highlightScript = onReadyScript + highlightScript;
            }
            collectionGroup.setOnDocumentReadyScript(highlightScript);
        }
        this.setNumberOfColumns(totalColumns);
    }

    @Override
    public void buildLine(View view, Object model, CollectionGroup collectionGroup, List<Field> lineFields, List<FieldGroup> subCollectionFields, String bindingPath, List<ActionField> actions, String idSuffix, Object currentLine, int lineIndex) {
        boolean isAddLine;
        boolean bl = isAddLine = lineIndex == -1;
        if (isAddLine && this.separateAddLine) {
            if (StringUtils.isBlank((CharSequence)this.addLineGroup.getTitle()) && StringUtils.isBlank((CharSequence)this.addLineGroup.getHeader().getHeaderText())) {
                this.addLineGroup.getHeader().setHeaderText(collectionGroup.getAddLineLabel());
            }
            this.addLineGroup.setItems(lineFields);
            ArrayList<ActionField> footerItems = new ArrayList<ActionField>(actions);
            footerItems.addAll(this.addLineGroup.getFooter().getItems());
            this.addLineGroup.getFooter().setItems(footerItems);
            return;
        }
        if (this.dataFields.isEmpty()) {
            if (this.isSuppressLineWrapping()) {
                this.setNumberOfDataColumns(lineFields.size());
            } else {
                this.setNumberOfDataColumns(this.getNumberOfColumns());
            }
        }
        if (!this.headerAdded) {
            this.headerFields = new ArrayList<LabelField>();
            this.dataFields = new ArrayList<Field>();
            this.buildTableHeaderRows(collectionGroup, lineFields);
            ComponentUtils.pushObjectToContext(this.headerFields, "line", currentLine);
            ComponentUtils.pushObjectToContext(this.headerFields, "index", (Object)lineIndex);
            this.headerAdded = true;
        }
        for (Field field : lineFields) {
            field.setLabelFieldRendered(true);
            ComponentUtils.setComponentPropertyDeep(field, "summaryMessageField.render", Boolean.FALSE);
        }
        int rowCount = this.calculateNumberOfRows(lineFields);
        int rowSpan = rowCount + subCollectionFields.size();
        if (this.renderSequenceField) {
            Field sequenceField;
            if (!isAddLine) {
                sequenceField = ComponentUtils.copy(this.sequenceFieldPrototype, idSuffix);
                if (this.generateAutoSequence && sequenceField instanceof MessageField) {
                    ((MessageField)sequenceField).setMessageText(Integer.toString(lineIndex + 1));
                }
            } else {
                sequenceField = ComponentUtils.copy(collectionGroup.getAddLineLabelField(), idSuffix);
            }
            sequenceField.setRowSpan(rowSpan);
            if (sequenceField instanceof DataBinding) {
                ((DataBinding)((Object)sequenceField)).getBindingInfo().setBindByNamePrefix(bindingPath);
            }
            ComponentUtils.updateContextForLine(sequenceField, currentLine, lineIndex);
            this.dataFields.add(sequenceField);
        }
        if (collectionGroup.isRenderSelectField()) {
            Field selectField = ComponentUtils.copy(this.selectFieldPrototype, idSuffix);
            CollectionLayoutUtils.prepareSelectFieldForLine(selectField, collectionGroup, bindingPath, currentLine);
            ComponentUtils.updateContextForLine(selectField, currentLine, lineIndex);
            this.dataFields.add(selectField);
        }
        int cellPosition = 0;
        for (Field lineField : lineFields) {
            this.dataFields.add(lineField);
            if ((cellPosition += lineField.getColSpan()) != this.getNumberOfDataColumns() || !collectionGroup.isRenderLineActions() || collectionGroup.isReadOnly()) continue;
            FieldGroup lineActionsField = ComponentUtils.copy(this.actionFieldPrototype, idSuffix);
            ComponentUtils.updateContextForLine(lineActionsField, currentLine, lineIndex);
            lineActionsField.setRowSpan(rowSpan);
            lineActionsField.setItems(actions);
            this.dataFields.add(lineActionsField);
        }
        for (FieldGroup subCollectionField : subCollectionFields) {
            subCollectionField.setColSpan(this.numberOfDataColumns);
        }
        this.dataFields.addAll(subCollectionFields);
    }

    protected void buildTableHeaderRows(CollectionGroup collectionGroup, List<Field> lineFields) {
        int rowCount = this.calculateNumberOfRows(lineFields);
        if (this.renderSequenceField) {
            this.sequenceFieldPrototype.setLabelFieldRendered(true);
            this.sequenceFieldPrototype.setRowSpan(rowCount);
            this.addHeaderField(this.sequenceFieldPrototype, 1);
        }
        if (collectionGroup.isRenderSelectField()) {
            this.selectFieldPrototype.setLabelFieldRendered(true);
            this.selectFieldPrototype.setRowSpan(rowCount);
            this.addHeaderField(this.selectFieldPrototype, 1);
        }
        int cellPosition = 0;
        for (Field field : lineFields) {
            if (!field.isRender() && StringUtils.isEmpty((CharSequence)field.getProgressiveRender())) continue;
            this.addHeaderField(field, cellPosition += field.getColSpan());
            if (cellPosition != this.getNumberOfDataColumns() || !collectionGroup.isRenderLineActions() || collectionGroup.isReadOnly()) continue;
            this.actionFieldPrototype.setLabelFieldRendered(true);
            this.actionFieldPrototype.setRowSpan(rowCount);
            this.addHeaderField(this.actionFieldPrototype, cellPosition);
        }
    }

    protected void addHeaderField(Field field, int column) {
        LabelField headerField = ComponentUtils.copy(this.headerFieldPrototype, "_c" + column);
        if (this.useShortLabels) {
            headerField.setLabelText(field.getLabel());
        } else {
            headerField.setLabelText(field.getLabel());
        }
        headerField.setRowSpan(field.getRowSpan());
        headerField.setColSpan(field.getColSpan());
        if (field.getRequired() != null && field.getRequired().booleanValue()) {
            headerField.getRequiredMessageField().setRender(true);
        } else {
            headerField.getRequiredMessageField().setRender(false);
        }
        this.headerFields.add(headerField);
    }

    protected int calculateNumberOfRows(List<? extends Field> items) {
        int rowCount = 0;
        if (this.isSuppressLineWrapping()) {
            return 1;
        }
        int cellCount = 0;
        for (Field field : items) {
            cellCount += field.getColSpan() + field.getRowSpan() - 1;
        }
        if (cellCount != 0) {
            rowCount = cellCount / this.getNumberOfDataColumns();
        }
        return rowCount;
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return CollectionGroup.class;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.richTable);
        components.add(this.addLineGroup);
        components.addAll(this.headerFields);
        components.addAll(this.dataFields);
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        components.add(this.headerFieldPrototype);
        components.add(this.sequenceFieldPrototype);
        components.add(this.actionFieldPrototype);
        components.add(this.subCollectionFieldGroupPrototype);
        components.add(this.selectFieldPrototype);
        return components;
    }

    public boolean isUseShortLabels() {
        return this.useShortLabels;
    }

    public void setUseShortLabels(boolean useShortLabels) {
        this.useShortLabels = useShortLabels;
    }

    public boolean isRepeatHeader() {
        return this.repeatHeader;
    }

    public void setRepeatHeader(boolean repeatHeader) {
        this.repeatHeader = repeatHeader;
    }

    public LabelField getHeaderFieldPrototype() {
        return this.headerFieldPrototype;
    }

    public void setHeaderFieldPrototype(LabelField headerFieldPrototype) {
        this.headerFieldPrototype = headerFieldPrototype;
    }

    public List<LabelField> getHeaderFields() {
        return this.headerFields;
    }

    public boolean isRenderSequenceField() {
        return this.renderSequenceField;
    }

    public void setRenderSequenceField(boolean renderSequenceField) {
        this.renderSequenceField = renderSequenceField;
    }

    public String getSequencePropertyName() {
        if (this.sequenceFieldPrototype instanceof DataField) {
            return ((DataField)this.sequenceFieldPrototype).getPropertyName();
        }
        return null;
    }

    public void setSequencePropertyName(String sequencePropertyName) {
        if (this.sequenceFieldPrototype instanceof DataField) {
            ((DataField)this.sequenceFieldPrototype).setPropertyName(sequencePropertyName);
        }
    }

    public boolean isGenerateAutoSequence() {
        return this.generateAutoSequence;
    }

    public void setGenerateAutoSequence(boolean generateAutoSequence) {
        this.generateAutoSequence = generateAutoSequence;
    }

    public Field getSequenceFieldPrototype() {
        return this.sequenceFieldPrototype;
    }

    public void setSequenceFieldPrototype(Field sequenceFieldPrototype) {
        this.sequenceFieldPrototype = sequenceFieldPrototype;
    }

    public FieldGroup getActionFieldPrototype() {
        return this.actionFieldPrototype;
    }

    public void setActionFieldPrototype(FieldGroup actionFieldPrototype) {
        this.actionFieldPrototype = actionFieldPrototype;
    }

    @Override
    public FieldGroup getSubCollectionFieldGroupPrototype() {
        return this.subCollectionFieldGroupPrototype;
    }

    public void setSubCollectionFieldGroupPrototype(FieldGroup subCollectionFieldGroupPrototype) {
        this.subCollectionFieldGroupPrototype = subCollectionFieldGroupPrototype;
    }

    public Field getSelectFieldPrototype() {
        return this.selectFieldPrototype;
    }

    public void setSelectFieldPrototype(Field selectFieldPrototype) {
        this.selectFieldPrototype = selectFieldPrototype;
    }

    public boolean isSeparateAddLine() {
        return this.separateAddLine;
    }

    public void setSeparateAddLine(boolean separateAddLine) {
        this.separateAddLine = separateAddLine;
    }

    public Group getAddLineGroup() {
        return this.addLineGroup;
    }

    public void setAddLineGroup(Group addLineGroup) {
        this.addLineGroup = addLineGroup;
    }

    public List<Field> getDataFields() {
        return this.dataFields;
    }

    public RichTable getRichTable() {
        return this.richTable;
    }

    public void setRichTable(RichTable richTable) {
        this.richTable = richTable;
    }

    public int getNumberOfDataColumns() {
        return this.numberOfDataColumns;
    }

    public void setNumberOfDataColumns(int numberOfDataColumns) {
        this.numberOfDataColumns = numberOfDataColumns;
    }

    public Set<String> getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(Set<String> hiddenColumns) {
        this.hiddenColumns = hiddenColumns;
    }

    public Set<String> getSortableColumns() {
        return this.sortableColumns;
    }

    public void setSortableColumns(Set<String> sortableColumns) {
        this.sortableColumns = sortableColumns;
    }
}

