/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.service.ViewHelperService;
import org.kuali.kfs.krad.uif.service.ViewService;
import org.kuali.kfs.krad.uif.service.ViewTypeService;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.web.form.UifFormBase;

public class ViewServiceImpl
implements ViewService {
    private static final Logger LOG = LogManager.getLogger(ViewServiceImpl.class);
    private DataDictionaryService dataDictionaryService;
    private List<ViewTypeService> viewTypeServices;

    @Override
    public View getViewById(String viewId) {
        View view;
        if (LOG.isDebugEnabled()) {
            LOG.debug("retrieving view instance for id: " + viewId);
        }
        if ((view = this.dataDictionaryService.getViewById(viewId)) == null) {
            LOG.warn("View not found for id: " + viewId);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating view status to CREATED for view: " + view.getId());
            }
            view.setViewStatus("C");
        }
        return view;
    }

    @Override
    public View getViewByType(UifConstants.ViewType viewType, Map<String, String> parameters) {
        ViewTypeService typeService = this.getViewTypeService(viewType);
        if (typeService == null) {
            throw new RuntimeException("Unable to find view type service for view type name: " + (Object)((Object)viewType));
        }
        Map<String, String> typeParameters = typeService.getParametersFromRequest(parameters);
        HashMap<String, String> indexKey = new HashMap<String, String>();
        for (Map.Entry<String, String> parameter : typeParameters.entrySet()) {
            indexKey.put(parameter.getKey(), parameter.getValue());
        }
        View view = this.dataDictionaryService.getViewByTypeIndex(viewType, indexKey);
        if (view == null) {
            LOG.warn("View not found for type: " + (Object)((Object)viewType));
        } else {
            LOG.debug("Updating view status to CREATED for view: " + view.getId());
            view.setViewStatus("C");
        }
        return view;
    }

    @Override
    public void buildView(View view, Object model, Map<String, String> parameters) {
        ViewHelperService helperService = view.getViewHelperService();
        helperService.populateViewFromRequestParameters(view, parameters);
        ((UifFormBase)model).setViewRequestParameters(view.getViewRequestParameters());
        this.performViewLifecycle(view, model, parameters);
    }

    protected void performViewLifecycle(View view, Object model, Map<String, String> parameters) {
        ViewHelperService helperService = view.getViewHelperService();
        if (LOG.isInfoEnabled()) {
            LOG.info("performing initialize phase for view: " + view.getId());
        }
        helperService.performInitialization(view, model);
        if (LOG.isDebugEnabled()) {
            LOG.debug("processing indexing for view: " + view.getId());
        }
        view.index();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating view status to INITIALIZED for view: " + view.getId());
        }
        view.setViewStatus("I");
        if (LOG.isInfoEnabled()) {
            LOG.info("performing apply model phase for view: " + view.getId());
        }
        helperService.performApplyModel(view, model);
        if (LOG.isInfoEnabled()) {
            LOG.info("reindexing after apply model for view: " + view.getId());
        }
        view.index();
        if (LOG.isInfoEnabled()) {
            LOG.info("performing finalize phase for view: " + view.getId());
        }
        helperService.performFinalize(view, model);
        if (LOG.isInfoEnabled()) {
            LOG.info("processing final indexing for view: " + view.getId());
        }
        view.index();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating view status to FINAL for view: " + view.getId());
        }
        view.setViewStatus("F");
    }

    @Override
    public ViewTypeService getViewTypeService(UifConstants.ViewType viewType) {
        if (this.viewTypeServices != null) {
            for (ViewTypeService typeService : this.viewTypeServices) {
                if (!viewType.equals((Object)typeService.getViewTypeName())) continue;
                return typeService;
            }
        }
        return null;
    }

    public List<ViewTypeService> getViewTypeServices() {
        return this.viewTypeServices;
    }

    public void setViewTypeServices(List<ViewTypeService> viewTypeServices) {
        this.viewTypeServices = viewTypeServices;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

