/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.view;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.RequestParameter;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.container.Group;
import org.kuali.kfs.krad.uif.field.Field;
import org.kuali.kfs.krad.uif.view.FormView;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.web.form.LookupForm;

public class LookupView
extends FormView {
    private static final long serialVersionUID = 716926008488403616L;
    private Class<?> dataObjectClassName;
    private Group criteriaGroup;
    private CollectionGroup resultsGroup;
    private Field resultsActionsField;
    private Field resultsReturnField;
    private List<Component> criteriaFields;
    private List<Component> resultFields;
    private List<String> defaultSortAttributeNames;
    protected boolean defaultSortAscending = true;
    @RequestParameter
    private boolean hideReturnLinks = false;
    @RequestParameter
    private boolean suppressActions = false;
    @RequestParameter
    private boolean showMaintenanceLinks = false;
    @RequestParameter
    private boolean multipleValuesSelect = false;
    @RequestParameter
    private String returnTarget;
    @RequestParameter
    private boolean returnByScript;
    private Integer resultSetLimit = null;
    private String maintenanceUrlMapping;

    public LookupView() {
        this.setViewTypeName(UifConstants.ViewType.LOOKUP);
        this.setValidateDirty(false);
    }

    @Override
    public void performInitialization(View view, Object model) {
        this.initializeGroups();
        if (this.getItems().isEmpty()) {
            this.setItems(Arrays.asList(this.getCriteriaGroup(), this.getResultsGroup()));
        }
        super.performInitialization(view, model);
        if (this.multipleValuesSelect) {
            this.hideReturnLinks = true;
        }
        this.getAbstractTypeClasses().put("criteriaFields", this.getDataObjectClassName());
        if (StringUtils.isNotBlank((CharSequence)this.getDefaultBindingObjectPath())) {
            this.getAbstractTypeClasses().put(this.getDefaultBindingObjectPath(), this.getDataObjectClassName());
        }
    }

    protected void initializeGroups() {
        if (this.getCriteriaGroup() != null && this.getCriteriaGroup().getItems().isEmpty()) {
            this.getCriteriaGroup().setItems(this.getCriteriaFields());
        }
        if (this.getResultsGroup() != null) {
            if (this.getResultsGroup().getItems().isEmpty() && this.getResultFields() != null) {
                this.getResultsGroup().setItems(this.getResultFields());
            }
            if (this.getResultsGroup().getCollectionObjectClass() == null) {
                this.getResultsGroup().setCollectionObjectClass(this.getDataObjectClassName());
            }
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        LookupForm lookupForm = (LookupForm)model;
        if (!this.isSuppressActions() && this.isShowMaintenanceLinks()) {
            this.getResultsGroup().getItems().add(0, this.getResultsActionsField());
        }
        if (StringUtils.isNotBlank((CharSequence)lookupForm.getReturnFormKey()) && StringUtils.isNotBlank((CharSequence)lookupForm.getReturnLocation()) && !this.isHideReturnLinks()) {
            this.getResultsGroup().getItems().add(0, this.getResultsReturnField());
        }
        super.performApplyModel(view, model, parent);
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        components.add(this.criteriaGroup);
        components.add(this.resultsGroup);
        components.add(this.resultsActionsField);
        components.add(this.resultsReturnField);
        components.addAll(this.criteriaFields);
        components.addAll(this.resultFields);
        return components;
    }

    public void applyConditionalLogicForFieldDisplay() {
    }

    public Class<?> getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(Class<?> dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    public boolean isHideReturnLinks() {
        return this.hideReturnLinks;
    }

    public void setHideReturnLinks(boolean hideReturnLinks) {
        this.hideReturnLinks = hideReturnLinks;
    }

    public boolean isSuppressActions() {
        return this.suppressActions;
    }

    public void setSuppressActions(boolean suppressActions) {
        this.suppressActions = suppressActions;
    }

    public boolean isShowMaintenanceLinks() {
        return this.showMaintenanceLinks;
    }

    public void setShowMaintenanceLinks(boolean showMaintenanceLinks) {
        this.showMaintenanceLinks = showMaintenanceLinks;
    }

    public boolean isMultipleValuesSelect() {
        return this.multipleValuesSelect;
    }

    public void setMultipleValuesSelect(boolean multipleValuesSelect) {
        this.multipleValuesSelect = multipleValuesSelect;
    }

    public Field getResultsActionsField() {
        return this.resultsActionsField;
    }

    public void setResultsActionsField(Field resultsActionsField) {
        this.resultsActionsField = resultsActionsField;
    }

    public Field getResultsReturnField() {
        return this.resultsReturnField;
    }

    public void setResultsReturnField(Field resultsReturnField) {
        this.resultsReturnField = resultsReturnField;
    }

    public Group getCriteriaGroup() {
        return this.criteriaGroup;
    }

    public void setCriteriaGroup(Group criteriaGroup) {
        this.criteriaGroup = criteriaGroup;
    }

    public CollectionGroup getResultsGroup() {
        return this.resultsGroup;
    }

    public void setResultsGroup(CollectionGroup resultsGroup) {
        this.resultsGroup = resultsGroup;
    }

    public List<Component> getCriteriaFields() {
        return this.criteriaFields;
    }

    public void setCriteriaFields(List<Component> criteriaFields) {
        this.criteriaFields = criteriaFields;
    }

    public List<Component> getResultFields() {
        return this.resultFields;
    }

    public void setResultFields(List<Component> resultFields) {
        this.resultFields = resultFields;
    }

    public List<String> getDefaultSortAttributeNames() {
        return this.defaultSortAttributeNames;
    }

    public void setDefaultSortAttributeNames(List<String> defaultSortAttributeNames) {
        this.defaultSortAttributeNames = defaultSortAttributeNames;
    }

    public boolean isDefaultSortAscending() {
        return this.defaultSortAscending;
    }

    public void setDefaultSortAscending(boolean defaultSortAscending) {
        this.defaultSortAscending = defaultSortAscending;
    }

    public Integer getResultSetLimit() {
        return this.resultSetLimit;
    }

    public void setResultSetLimit(Integer resultSetLimit) {
        this.resultSetLimit = resultSetLimit;
    }

    public boolean hasResultSetLimit() {
        return this.resultSetLimit != null;
    }

    public void setReturnTarget(String returnTarget) {
        this.returnTarget = returnTarget;
    }

    public String getReturnTarget() {
        return this.returnTarget;
    }

    public boolean isReturnByScript() {
        return this.returnByScript;
    }

    public void setReturnByScript(boolean returnByScript) {
        this.returnByScript = returnByScript;
    }

    public String getMaintenanceUrlMapping() {
        return this.maintenanceUrlMapping;
    }

    public void setMaintenanceUrlMapping(String maintenanceUrlMapping) {
        this.maintenanceUrlMapping = maintenanceUrlMapping;
    }
}

