/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.widget;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.component.BindingInfo;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.field.ActionField;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.util.ViewModelUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.widget.WidgetBase;
import org.kuali.kfs.krad.util.KRADUtils;

public class QuickFinder
extends WidgetBase {
    private static final long serialVersionUID = 3302390972815386785L;
    private String baseLookupUrl;
    private String dataObjectClassName;
    private String viewName;
    private String referencesToRefresh;
    private Map<String, String> fieldConversions = new HashMap<String, String>();
    private Map<String, String> lookupParameters = new HashMap<String, String>();
    private String readOnlySearchFields;
    private Boolean hideReturnLink;
    private Boolean suppressActions;
    private Boolean autoSearch;
    private Boolean lookupCriteriaEnabled;
    private Boolean supplementalActionsEnabled;
    private Boolean disableSearchButtons;
    private Boolean headerBarEnabled;
    private Boolean showMaintenanceLinks;
    private Boolean multipleValuesSelect;
    private String lookupCollectionName;
    private ActionField quickfinderActionField;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (!this.isRender()) {
            return;
        }
        if (parent instanceof InputField) {
            InputField field = (InputField)parent;
            if (StringUtils.isBlank((CharSequence)this.dataObjectClassName)) {
                DataObjectRelationship relationship = this.getRelationshipForField(view, model, field);
                if (relationship == null) {
                    this.setRender(false);
                    return;
                }
                this.dataObjectClassName = relationship.getRelatedClass().getName();
                if (this.fieldConversions == null || this.fieldConversions.isEmpty()) {
                    this.generateFieldConversions(field, relationship);
                }
                if (this.lookupParameters == null || this.lookupParameters.isEmpty()) {
                    this.generateLookupParameters(field, relationship);
                }
            }
            this.updateFieldConversions(field.getBindingInfo());
            this.updateLookupParameters(field.getBindingInfo());
        } else if (parent instanceof CollectionGroup) {
            CollectionGroup collectionGroup = (CollectionGroup)parent;
            if (StringUtils.isBlank((CharSequence)this.getDataObjectClassName())) {
                Class<?> collectionObjectClass = collectionGroup.getCollectionObjectClass();
                boolean isCollectionClassLookupable = KRADServiceLocatorWeb.getViewDictionaryService().isLookupable(collectionObjectClass);
                if (isCollectionClassLookupable) {
                    this.setDataObjectClassName(collectionObjectClass.getName());
                    if (this.fieldConversions == null || this.fieldConversions.isEmpty()) {
                        List<String> collectionObjectPKFields = KRADServiceLocatorWeb.getDataObjectMetaDataService().listPrimaryKeyFieldNames(collectionObjectClass);
                        for (String pkField : collectionObjectPKFields) {
                            this.fieldConversions.put(pkField, pkField);
                        }
                    }
                } else {
                    this.setRender(false);
                }
            }
            if (this.isRender() && StringUtils.isBlank((CharSequence)this.getLookupCollectionName())) {
                this.setLookupCollectionName(collectionGroup.getBindingInfo().getBindingPath());
            }
        }
        this.quickfinderActionField.addActionParameter("baseLookupUrl", this.baseLookupUrl);
        this.quickfinderActionField.addActionParameter("dataObjectClassName", this.dataObjectClassName);
        if (!this.fieldConversions.isEmpty()) {
            this.quickfinderActionField.addActionParameter("conversionFields", KRADUtils.buildMapParameterString(this.fieldConversions));
        }
        if (!this.lookupParameters.isEmpty()) {
            this.quickfinderActionField.addActionParameter("lookupParameters", KRADUtils.buildMapParameterString(this.lookupParameters));
        }
        this.addActionParameterIfNotNull("viewName", this.viewName);
        this.addActionParameterIfNotNull("readOnlyFields", this.readOnlySearchFields);
        this.addActionParameterIfNotNull("hideReturnLink", this.hideReturnLink);
        this.addActionParameterIfNotNull("supressActions", this.suppressActions);
        this.addActionParameterIfNotNull("referencesToRefresh", this.referencesToRefresh);
        this.addActionParameterIfNotNull("autoSearch", this.autoSearch);
        this.addActionParameterIfNotNull("lookupCriteriaEnabled", this.lookupCriteriaEnabled);
        this.addActionParameterIfNotNull("supplementalActionsEnabled", this.supplementalActionsEnabled);
        this.addActionParameterIfNotNull("disableSearchButtons", this.disableSearchButtons);
        this.addActionParameterIfNotNull("headerBarEnabled", this.headerBarEnabled);
        this.addActionParameterIfNotNull("showMaintenanceLinks", this.showMaintenanceLinks);
        this.addActionParameterIfNotNull("multipleValuesSelect", this.multipleValuesSelect);
        this.addActionParameterIfNotNull("lookupCollectionName", this.lookupCollectionName);
    }

    protected void addActionParameterIfNotNull(String parameterName, Object parameterValue) {
        if (parameterValue != null && StringUtils.isNotBlank((CharSequence)parameterValue.toString())) {
            this.quickfinderActionField.addActionParameter(parameterName, parameterValue.toString());
        }
    }

    protected DataObjectRelationship getRelationshipForField(View view, Object model, InputField field) {
        String propertyName = field.getBindingInfo().getBindingName();
        Object parentObject = ViewModelUtils.getParentObjectForMetadata(view, model, field);
        Class<?> parentObjectClass = null;
        if (parentObject != null) {
            parentObjectClass = parentObject.getClass();
        }
        return KRADServiceLocatorWeb.getDataObjectMetaDataService().getDataObjectRelationship(parentObject, parentObjectClass, propertyName, "", true, true, false);
    }

    protected void generateFieldConversions(InputField field, DataObjectRelationship relationship) {
        this.fieldConversions = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : relationship.getParentToChildReferences().entrySet()) {
            String fromField = entry.getValue();
            String toField = entry.getKey();
            this.fieldConversions.put(fromField, toField);
        }
    }

    protected void generateLookupParameters(InputField field, DataObjectRelationship relationship) {
        this.lookupParameters = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : relationship.getParentToChildReferences().entrySet()) {
            String fromField = entry.getKey();
            String toField = entry.getValue();
            if (relationship.getUserVisibleIdentifierKey() != null && !relationship.getUserVisibleIdentifierKey().equals(fromField)) continue;
            this.lookupParameters.put(fromField, toField);
        }
    }

    public void updateFieldConversions(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedFieldConversions = new HashMap<String, String>();
        for (String fromField : this.fieldConversions.keySet()) {
            String toField = this.fieldConversions.get(fromField);
            String adjustedToFieldPath = bindingInfo.getPropertyAdjustedBindingPath(toField);
            adjustedFieldConversions.put(fromField, adjustedToFieldPath);
        }
        this.fieldConversions = adjustedFieldConversions;
    }

    public void updateLookupParameters(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedLookupParameters = new HashMap<String, String>();
        for (String fromField : this.lookupParameters.keySet()) {
            String toField = this.lookupParameters.get(fromField);
            String adjustedFromFieldPath = bindingInfo.getPropertyAdjustedBindingPath(fromField);
            adjustedLookupParameters.put(adjustedFromFieldPath, toField);
        }
        this.lookupParameters = adjustedLookupParameters;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.quickfinderActionField);
        return components;
    }

    public String getBaseLookupUrl() {
        return this.baseLookupUrl;
    }

    public void setBaseLookupUrl(String baseLookupUrl) {
        this.baseLookupUrl = baseLookupUrl;
    }

    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getReferencesToRefresh() {
        return this.referencesToRefresh;
    }

    public void setReferencesToRefresh(String referencesToRefresh) {
        this.referencesToRefresh = referencesToRefresh;
    }

    public Map<String, String> getFieldConversions() {
        return this.fieldConversions;
    }

    public void setFieldConversions(Map<String, String> fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    public Map<String, String> getLookupParameters() {
        return this.lookupParameters;
    }

    public void setLookupParameters(Map<String, String> lookupParameters) {
        this.lookupParameters = lookupParameters;
    }

    public String getReadOnlySearchFields() {
        return this.readOnlySearchFields;
    }

    public void setReadOnlySearchFields(String readOnlySearchFields) {
        this.readOnlySearchFields = readOnlySearchFields;
    }

    public Boolean getHideReturnLink() {
        return this.hideReturnLink;
    }

    public void setHideReturnLink(Boolean hideReturnLink) {
        this.hideReturnLink = hideReturnLink;
    }

    public Boolean getSuppressActions() {
        return this.suppressActions;
    }

    public void setSuppressActions(Boolean suppressActions) {
        this.suppressActions = suppressActions;
    }

    public Boolean getAutoSearch() {
        return this.autoSearch;
    }

    public void setAutoSearch(Boolean autoSearch) {
        this.autoSearch = autoSearch;
    }

    public Boolean getLookupCriteriaEnabled() {
        return this.lookupCriteriaEnabled;
    }

    public void setLookupCriteriaEnabled(Boolean lookupCriteriaEnabled) {
        this.lookupCriteriaEnabled = lookupCriteriaEnabled;
    }

    public Boolean getSupplementalActionsEnabled() {
        return this.supplementalActionsEnabled;
    }

    public void setSupplementalActionsEnabled(Boolean supplementalActionsEnabled) {
        this.supplementalActionsEnabled = supplementalActionsEnabled;
    }

    public Boolean getDisableSearchButtons() {
        return this.disableSearchButtons;
    }

    public void setDisableSearchButtons(Boolean disableSearchButtons) {
        this.disableSearchButtons = disableSearchButtons;
    }

    public Boolean getHeaderBarEnabled() {
        return this.headerBarEnabled;
    }

    public void setHeaderBarEnabled(Boolean headerBarEnabled) {
        this.headerBarEnabled = headerBarEnabled;
    }

    public Boolean getShowMaintenanceLinks() {
        return this.showMaintenanceLinks;
    }

    public void setShowMaintenanceLinks(Boolean showMaintenanceLinks) {
        this.showMaintenanceLinks = showMaintenanceLinks;
    }

    public ActionField getQuickfinderActionField() {
        return this.quickfinderActionField;
    }

    public void setQuickfinderActionField(ActionField quickfinderActionField) {
        this.quickfinderActionField = quickfinderActionField;
    }

    public Boolean getMultipleValuesSelect() {
        return this.multipleValuesSelect;
    }

    public void setMultipleValuesSelect(Boolean multipleValuesSelect) {
        this.multipleValuesSelect = multipleValuesSelect;
    }

    public String getLookupCollectionName() {
        return this.lookupCollectionName;
    }

    public void setLookupCollectionName(String lookupCollectionName) {
        this.lookupCollectionName = lookupCollectionName;
    }
}

