/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.kfs.krad.exception.ClassNotPersistableException;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.cache.CopiedObject;
import org.kuali.rice.core.web.format.CollectionFormatter;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public final class ObjectUtils {
    private static final Logger LOG = LogManager.getLogger(ObjectUtils.class);

    private ObjectUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Serializable deepCopy(Serializable src) {
        CopiedObject co = ObjectUtils.deepCopyForCaching(src);
        return co.getContent();
    }

    public static CopiedObject deepCopyForCaching(Serializable src) {
        CopiedObject co = new CopiedObject();
        co.setContent(src);
        return co;
    }

    public static byte[] toByteArray(Object object) throws Exception {
        try (ObjectOutputStream oos = null;){
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static Object fromByteArray(byte[] bytes) throws Exception {
        try (ObjectInputStream ois = null;){
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bis);
            Object object = ois.readObject();
            return object;
        }
    }

    public static String getMD5Hash(Object object) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(ObjectUtils.toByteArray(object));
            return new String(md.digest());
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            throw e;
        }
    }

    public static BusinessObject createHybridBusinessObject(Class businessObjectClass, BusinessObject source, Map<String, String> template) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object obj;
        try {
            ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(businessObjectClass);
            obj = moduleService != null && moduleService.isExternalizable(businessObjectClass) ? moduleService.createNewObjectFromExternalizableClass(businessObjectClass) : (BusinessObject)businessObjectClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate " + businessObjectClass.getName(), e);
        }
        ObjectUtils.createHybridBusinessObject(obj, source, template);
        return obj;
    }

    public static void createHybridBusinessObject(BusinessObject businessObject, BusinessObject source, Map<String, String> template) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (String name : template.keySet()) {
            String sourcePropertyName = template.get(name);
            ObjectUtils.setObjectProperty(businessObject, name, ObjectUtils.easyGetPropertyType(source, sourcePropertyName), ObjectUtils.getPropertyValue(source, sourcePropertyName));
        }
    }

    public static Class easyGetPropertyType(Object object, String propertyName) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return PropertyUtils.getPropertyType((Object)object, (String)propertyName);
    }

    public static Class getPropertyType(Object object, String propertyName, PersistenceStructureService persistenceStructureService) {
        if (object == null || propertyName == null) {
            throw new RuntimeException("Business object and property name can not be null");
        }
        Class propertyType = null;
        try {
            try {
                propertyType = PropertyUtils.getPropertyType((Object)object, (String)propertyName);
            }
            catch (IllegalArgumentException | NoSuchMethodException exception) {
                // empty catch block
            }
            if (propertyType != null && propertyType.equals(PersistableBusinessObjectExtension.class)) {
                propertyType = persistenceStructureService.getBusinessObjectAttributeClass(ProxyHelper.getRealClass((Object)object), propertyName);
            }
            if (null == propertyType && -1 != propertyName.indexOf(46)) {
                if (null == persistenceStructureService) {
                    LOG.info("PropertyType couldn't be determined simply and no PersistenceStructureService was given. If you pass in a PersistenceStructureService I can look in other places to try to determine the type of the property.");
                } else {
                    String prePeriod = StringUtils.substringBefore((String)propertyName, (String)".");
                    String postPeriod = StringUtils.substringAfter((String)propertyName, (String)".");
                    Class prePeriodClass = ObjectUtils.getPropertyType(object, prePeriod, persistenceStructureService);
                    Object prePeriodClassInstance = prePeriodClass.newInstance();
                    propertyType = ObjectUtils.getPropertyType(prePeriodClassInstance, postPeriod, persistenceStructureService);
                }
            } else if (Collection.class.isAssignableFrom(propertyType)) {
                Map<String, Class> map = persistenceStructureService.listCollectionObjectTypes(object.getClass());
                propertyType = map.get(propertyName);
            }
        }
        catch (Exception e) {
            LOG.debug("unable to get property type for " + propertyName + " " + e.getMessage());
        }
        return propertyType;
    }

    public static Object getPropertyValue(Object businessObject, String propertyName) {
        if (businessObject == null || propertyName == null) {
            throw new RuntimeException("Business object and property name can not be null");
        }
        Object propertyValue = null;
        try {
            propertyValue = PropertyUtils.getProperty((Object)businessObject, (String)propertyName);
        }
        catch (InvocationTargetException | NestedNullException throwable) {
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            LOG.error("error getting property value for  " + businessObject.getClass() + "." + propertyName + " " + e.getMessage());
            throw new RuntimeException("error getting property value for  " + businessObject.getClass() + "." + propertyName + " " + e.getMessage(), e);
        }
        return propertyValue;
    }

    public static String getFormattedPropertyValue(BusinessObject businessObject, String propertyName, Formatter formatter) {
        String propValue = "";
        Object prop = ObjectUtils.getPropertyValue(businessObject, propertyName);
        if (formatter == null) {
            propValue = ObjectUtils.formatPropertyValue(prop);
        } else {
            Object formattedValue = formatter.format(prop);
            if (formattedValue != null) {
                propValue = String.valueOf(formattedValue);
            }
        }
        return propValue;
    }

    public static String getFormattedPropertyValueUsingDataDictionary(BusinessObject businessObject, String propertyName) {
        Formatter formatter = ObjectUtils.getFormatterWithDataDictionary(businessObject, propertyName);
        return ObjectUtils.getFormattedPropertyValue(businessObject, propertyName, formatter);
    }

    public static String formatPropertyValue(Object propertyValue) {
        Object propValue = "";
        if (propertyValue != null) {
            Object formatter = propertyValue instanceof Collection ? new CollectionFormatter() : Formatter.getFormatter(propertyValue.getClass());
            propValue = formatter != null ? formatter.format(propertyValue) : propertyValue;
        }
        return propValue != null ? String.valueOf(propValue) : "";
    }

    public static void setObjectProperty(Object bo, String propertyName, Object propertyValue) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class propertyType = ObjectUtils.easyGetPropertyType(bo, propertyName);
        ObjectUtils.setObjectProperty(bo, propertyName, propertyType, propertyValue);
    }

    public static void setObjectProperty(Object bo, String propertyName, Class propertyType, Object propertyValue) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        boolean reformat = false;
        if (propertyType != null) {
            if (propertyValue != null && propertyType.isAssignableFrom(String.class)) {
                reformat = true;
            } else if (propertyValue != null && !propertyType.isAssignableFrom(propertyValue.getClass())) {
                reformat = true;
            }
            if (Boolean.TYPE.isAssignableFrom(propertyType) && propertyValue == null) {
                propertyValue = false;
            }
        }
        Formatter formatter = ObjectUtils.getFormatterWithDataDictionary(bo, propertyName);
        if (reformat && formatter != null) {
            LOG.debug("reformatting propertyValue using Formatter " + formatter.getClass().getName());
            propertyValue = formatter.convertFromPresentationFormat(propertyValue);
        }
        PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)propertyValue);
    }

    public static void setObjectProperty(Formatter formatter, Object bo, String propertyName, Class type, Object propertyValue) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (formatter != null) {
            propertyValue = formatter.convertFromPresentationFormat(propertyValue);
        }
        if (propertyValue instanceof String) {
            String propVal = (String)propertyValue;
            if (propVal.endsWith("(&^#&)")) {
                propVal = StringUtils.removeEnd((String)propVal, (String)"(&^#&)");
            }
            if (KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(bo.getClass(), propertyName)) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        propertyValue = CoreApiServiceLocator.getEncryptionService().decrypt(propVal);
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)propertyValue);
    }

    public static Formatter getFormatterWithDataDictionary(Object bo, String propertyName) {
        Class formatterClass;
        Object collectionParent;
        Formatter formatter = null;
        Class<?> boClass = bo.getClass();
        String boPropertyName = propertyName;
        if (StringUtils.contains((CharSequence)propertyName, (CharSequence)"]") && (collectionParent = ObjectUtils.getNestedValue(bo, StringUtils.substringBeforeLast((String)propertyName, (String)"].") + "]")) != null) {
            boClass = collectionParent.getClass();
            boPropertyName = StringUtils.substringAfterLast((String)propertyName, (String)"].");
        }
        if ((formatterClass = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeFormatter(boClass, boPropertyName)) == null) {
            try {
                formatterClass = Formatter.findFormatter((Class)ObjectUtils.getPropertyType(boClass.newInstance(), boPropertyName, KRADServiceLocator.getPersistenceStructureService()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.warn("Unable to find a formatter for bo class " + boClass + " and property " + boPropertyName);
            }
        }
        if (formatterClass != null) {
            try {
                formatter = formatterClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("cannot create new instance of formatter class " + formatterClass.toString(), e);
            }
        }
        return formatter;
    }

    public static void setObjectPropertyDeep(Object bo, String propertyName, Class type, Object propertyValue) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor[] propertyDescriptors;
        if (ObjectUtils.isNull(bo) || !PropertyUtils.isReadable((Object)bo, (String)propertyName) || propertyValue != null && propertyValue.equals(ObjectUtils.getPropertyValue(bo, propertyName)) || type != null && !type.equals(ObjectUtils.easyGetPropertyType(bo, propertyName))) {
            return;
        }
        ObjectUtils.materializeUpdateableCollections(bo);
        ObjectUtils.setObjectProperty(bo, propertyName, type, propertyValue);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(bo.getClass())) {
            if (propertyDescriptor.getPropertyType() != null && BusinessObject.class.isAssignableFrom(propertyDescriptor.getPropertyType()) && PropertyUtils.isReadable((Object)bo, (String)propertyDescriptor.getName())) {
                Object nestedBo = ObjectUtils.getPropertyValue(bo, propertyDescriptor.getName());
                if (!(nestedBo instanceof BusinessObject)) continue;
                ObjectUtils.setObjectPropertyDeep(nestedBo, propertyName, type, propertyValue);
                continue;
            }
            if (propertyDescriptor.getPropertyType() == null || !List.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || ObjectUtils.getPropertyValue(bo, propertyDescriptor.getName()) == null) continue;
            List propertyList = (List)ObjectUtils.getPropertyValue(bo, propertyDescriptor.getName());
            for (Object listedBo : propertyList) {
                if (!(listedBo instanceof BusinessObject)) continue;
                ObjectUtils.setObjectPropertyDeep(listedBo, propertyName, type, propertyValue);
            }
        }
    }

    public static void setObjectPropertyDeep(Object bo, String propertyName, Class type, Object propertyValue, int depth) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor[] propertyDescriptors;
        if (depth == 0 || ObjectUtils.isNull(bo) || !PropertyUtils.isReadable((Object)bo, (String)propertyName)) {
            return;
        }
        try {
            ObjectUtils.materializeUpdateableCollections(bo);
        }
        catch (ClassNotPersistableException ex) {
            LOG.info("Not persistable dataObjectClass: " + bo.getClass().getName() + ", field: " + propertyName);
        }
        ObjectUtils.setObjectProperty(bo, propertyName, type, propertyValue);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(bo.getClass())) {
            if (propertyDescriptor.getPropertyType() != null && BusinessObject.class.isAssignableFrom(propertyDescriptor.getPropertyType()) && PropertyUtils.isReadable((Object)bo, (String)propertyDescriptor.getName())) {
                Object nestedBo = ObjectUtils.getPropertyValue(bo, propertyDescriptor.getName());
                if (!(nestedBo instanceof BusinessObject)) continue;
                ObjectUtils.setObjectPropertyDeep(nestedBo, propertyName, type, propertyValue, depth - 1);
                continue;
            }
            if (propertyDescriptor.getPropertyType() == null || !List.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || ObjectUtils.getPropertyValue(bo, propertyDescriptor.getName()) == null) continue;
            List propertyList = (List)ObjectUtils.getPropertyValue(bo, propertyDescriptor.getName());
            for (Object listedBo : propertyList) {
                if (!(listedBo instanceof BusinessObject)) continue;
                ObjectUtils.setObjectPropertyDeep(listedBo, propertyName, type, propertyValue, depth - 1);
            }
        }
    }

    public static void materializeUpdateableCollections(Object bo) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (ObjectUtils.isNotNull(bo)) {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(bo.getClass())) {
                Collection updateableCollection;
                if (!KRADServiceLocator.getPersistenceStructureService().hasCollection(bo.getClass(), propertyDescriptor.getName()) || !KRADServiceLocator.getPersistenceStructureService().isCollectionUpdatable(bo.getClass(), propertyDescriptor.getName()) || (updateableCollection = (Collection)ObjectUtils.getPropertyValue(bo, propertyDescriptor.getName())) == null || !ProxyHelper.isCollectionProxy((Object)updateableCollection)) continue;
                ObjectUtils.materializeObjects(updateableCollection);
            }
        }
    }

    public static String clean(String string) {
        for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
            string = StringUtils.replace((String)string, (String)op.op(), (String)"");
        }
        return string;
    }

    public static boolean equalByKeys(PersistableBusinessObject bo1, PersistableBusinessObject bo2) {
        boolean equal = true;
        if (bo1 == null && bo2 == null) {
            equal = true;
        } else if (bo1 == null || bo2 == null) {
            equal = false;
        } else if (!bo1.getClass().getName().equals(bo2.getClass().getName())) {
            equal = false;
        } else {
            Map bo1Keys = KRADServiceLocator.getPersistenceService().getPrimaryKeyFieldValues(bo1);
            Map bo2Keys = KRADServiceLocator.getPersistenceService().getPrimaryKeyFieldValues(bo2);
            for (Object boKey : bo1Keys.keySet()) {
                String keyName = (String)boKey;
                if (bo1Keys.get(keyName) != null && bo2Keys.get(keyName) != null) {
                    if (bo1Keys.get(keyName).toString().equals(bo2Keys.get(keyName).toString())) continue;
                    equal = false;
                    continue;
                }
                equal = false;
            }
        }
        return equal;
    }

    public static boolean collectionContainsObjectWithIdentitcalKey(Collection<? extends PersistableBusinessObject> controlList, PersistableBusinessObject bo) {
        for (PersistableBusinessObject persistableBusinessObject : controlList) {
            if (!ObjectUtils.equalByKeys(persistableBusinessObject, bo)) continue;
            return true;
        }
        return false;
    }

    public static int countObjectsWithIdentitcalKey(Collection<? extends PersistableBusinessObject> collection, PersistableBusinessObject bo) {
        int n = 0;
        for (PersistableBusinessObject persistableBusinessObject : collection) {
            if (!ObjectUtils.equalByKeys(persistableBusinessObject, bo)) continue;
            ++n;
        }
        return n;
    }

    public static void removeObjectWithIdentitcalKey(Collection<? extends PersistableBusinessObject> controlList, PersistableBusinessObject bo) {
        controlList.removeIf(listBo -> ObjectUtils.equalByKeys(listBo, bo));
    }

    public static BusinessObject retrieveObjectWithIdentitcalKey(Collection<? extends PersistableBusinessObject> controlList, PersistableBusinessObject bo) {
        PersistableBusinessObject returnBo = null;
        for (PersistableBusinessObject persistableBusinessObject : controlList) {
            if (!ObjectUtils.equalByKeys(persistableBusinessObject, bo)) continue;
            returnBo = persistableBusinessObject;
        }
        return returnBo;
    }

    public static boolean isNestedAttribute(String attributeName) {
        boolean isNested = false;
        if (StringUtils.contains((CharSequence)attributeName, (CharSequence)".")) {
            isNested = true;
        }
        return isNested;
    }

    public static String getNestedAttributePrefix(String attributeName) {
        String prefix = "";
        if (StringUtils.contains((CharSequence)attributeName, (CharSequence)".")) {
            prefix = StringUtils.substringBeforeLast((String)attributeName, (String)".");
        }
        return prefix;
    }

    public static String getNestedAttributePrimitive(String attributeName) {
        String primitive = attributeName;
        if (StringUtils.contains((CharSequence)attributeName, (CharSequence)".")) {
            primitive = StringUtils.substringAfterLast((String)attributeName, (String)".");
        }
        return primitive;
    }

    public static boolean isNull(Object object) {
        if (object == null) {
            return true;
        }
        if ((ProxyHelper.isProxy((Object)object) || ProxyHelper.isCollectionProxy((Object)object)) && ProxyHelper.getRealObject((Object)object) == null) {
            return true;
        }
        try {
            object.equals(null);
        }
        catch (EntityNotFoundException e) {
            return true;
        }
        return false;
    }

    public static boolean isNotNull(Object object) {
        return !ObjectUtils.isNull(object);
    }

    public static Class materializeClassForProxiedObject(Object object) {
        if (object == null) {
            return null;
        }
        if (ProxyHelper.isProxy((Object)object) || ProxyHelper.isCollectionProxy((Object)object)) {
            return ProxyHelper.getRealClass((Object)object);
        }
        return object.getClass();
    }

    public static void materializeObjects(Collection possiblyProxiedObjects) {
        for (Object possiblyProxiedObject : possiblyProxiedObjects) {
            ObjectUtils.isNotNull(possiblyProxiedObject);
        }
    }

    public static void materializeSubObjectsToDepth(PersistableBusinessObject bo, int depth) {
        if (bo == null) {
            throw new IllegalArgumentException("The bo passed in was null.");
        }
        if (depth < 0 || depth > 5) {
            throw new IllegalArgumentException("The depth passed in was out of bounds. Only values between 0 and 5, inclusively, are allowed.");
        }
        if (depth == 0) {
            return;
        }
        if (ProxyHelper.isProxy((Object)bo) && !ProxyHelper.isMaterialized((Object)bo)) {
            throw new IllegalArgumentException("The bo passed in is an un-materialized proxy, and cannot be used.");
        }
        if (KRADServiceLocator.getPersistenceStructureService().isPersistable(bo.getClass())) {
            Map<String, Class> references = KRADServiceLocator.getPersistenceStructureService().listReferenceObjectFields(bo);
            Object realReferenceValue = null;
            Iterator<String> iterator = references.keySet().iterator();
            while (iterator.hasNext()) {
                String s;
                String referenceName = s = iterator.next();
                Class referenceClass = references.get(referenceName);
                Object referenceValue = ObjectUtils.getPropertyValue(bo, referenceName);
                if (referenceValue == null) continue;
                if (ProxyHelper.isProxy((Object)referenceValue) && (realReferenceValue = ProxyHelper.getRealObject((Object)referenceValue)) != null) {
                    try {
                        ObjectUtils.setObjectProperty(bo, referenceName, referenceClass, realReferenceValue);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | FormatException e) {
                        throw new RuntimeException(e.getClass().getSimpleName() + ": could not set the property '" + referenceName + "'.", e);
                    }
                }
                if (!(realReferenceValue instanceof PersistableBusinessObject) || depth <= 1) continue;
                ObjectUtils.materializeSubObjectsToDepth((PersistableBusinessObject)realReferenceValue, depth - 1);
            }
        }
    }

    public static void materializeAllSubObjects(PersistableBusinessObject bo) {
        ObjectUtils.materializeSubObjectsToDepth(bo, 3);
    }

    public static Object getNestedValue(Object bo, String fieldName) {
        if (bo == null) {
            throw new IllegalArgumentException("The bo passed in was null.");
        }
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("The fieldName passed in was blank.");
        }
        String[] fieldNameParts = fieldName.split("\\.");
        Object currentObject = null;
        Object priorObject = bo;
        for (String fieldNamePart : fieldNameParts) {
            try {
                currentObject = fieldNamePart.indexOf("]") > 0 ? PropertyUtils.getIndexedProperty((Object)priorObject, (String)fieldNamePart) : PropertyUtils.getSimpleProperty((Object)priorObject, (String)fieldNamePart);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Caller does not have access to the property accessor method.", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Property accessor method threw an exception.", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("The accessor method requested for this property cannot be found.", e);
            }
            if (ProxyHelper.isProxy((Object)currentObject)) {
                currentObject = ProxyHelper.getRealObject((Object)currentObject);
            }
            if (currentObject == null) {
                return null;
            }
            priorObject = currentObject;
        }
        return currentObject;
    }

    public static Object createNewObjectFromClass(Class clazz) {
        if (clazz == null) {
            throw new RuntimeException("BO class was passed in as null");
        }
        try {
            if (ExternalizableBusinessObject.class.isAssignableFrom(clazz)) {
                Class eboInterface = ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface(clazz);
                ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(eboInterface);
                return moduleService.createNewObjectFromExternalizableClass(eboInterface);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while trying to create a new instance for class " + clazz, e);
        }
    }

    public static boolean isWriteable(Object object, String property, PersistenceStructureService persistenceStructureService) throws IllegalArgumentException {
        if (null == object || null == property) {
            throw new IllegalArgumentException("Cannot check writeable status with null arguments.");
        }
        try {
            if (!PropertyUtils.isWriteable((Object)object, (String)property)) {
                return ObjectUtils.isWriteableHelper(object, property, persistenceStructureService);
            }
            return true;
        }
        catch (NestedNullException nestedNullException) {
            return ObjectUtils.isWriteableHelper(object, property, persistenceStructureService);
        }
    }

    private static boolean isWriteableHelper(Object object, String property, PersistenceStructureService persistenceStructureService) {
        if (property.contains(".")) {
            String propertyName = StringUtils.substringBefore((String)property, (String)".");
            Class c = ObjectUtils.getPropertyType(object, propertyName, persistenceStructureService);
            if (c != null) {
                if (Collection.class.isAssignableFrom(c)) {
                    Map<String, Class> m = persistenceStructureService.listCollectionObjectTypes(object.getClass());
                    c = m.get(propertyName);
                }
                try {
                    Object i = c.newInstance();
                    return ObjectUtils.isWriteable(i, StringUtils.substringAfter((String)property, (String)"."), persistenceStructureService);
                }
                catch (Exception ex) {
                    LOG.error("Skipping Criteria: " + property + " - Unable to instantiate class : " + c.getName(), (Throwable)ex);
                }
            } else {
                LOG.error("Skipping Criteria: " + property + " - Unable to determine class for object: " + object.getClass().getName() + " - " + propertyName);
            }
        }
        return false;
    }

    public static <T> T newInstance(Class<T> clazz) {
        T object;
        try {
            object = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Unable to create new instance of class: " + clazz.getName());
            throw new RuntimeException(e);
        }
        return object;
    }
}

